/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage;

import com.intellij.analysis.pwa.analyser.FileIdList;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaHighPriorityFilesSuggester;
import com.intellij.analysis.pwa.storage.RawAnalysisBatch;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;
import java.util.List;
import java.util.function.IntConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000eJ\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001dR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/analysis/pwa/storage/PwaTaskCache;", "", "suggesters", "", "Lcom/intellij/analysis/pwa/analyser/PwaHighPriorityFilesSuggester;", "(Ljava/util/List;)V", "toAnalyseInvalidatingDeps", "Ljava/util/BitSet;", "toAnalyseOnly", "clear", "", "dispatchPrioritizedFiles", "", "prioritizedFiles", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "filesToFind", "filesToAnalyseOnly", "Lit/unimi/dsi/fastutil/ints/IntSet;", "filesToAnalyseInvalidatingDeps", "getFilesToAnalyseCount", "isEmpty", "", "markAnalyseFilesInvalidatingDependencies", "files", "markAnalyseFilesOnly", "prepareBatch", "Lcom/intellij/analysis/pwa/storage/RawAnalysisBatch;", "taskSize", "removeAnalysisStatus", "Lcom/intellij/analysis/pwa/analyser/FileIdList;", "intellij.pwa.core"})
public final class PwaTaskCache {
    private final BitSet toAnalyseOnly;
    private final BitSet toAnalyseInvalidatingDeps;
    private final List<PwaHighPriorityFilesSuggester> suggesters;

    public final void markAnalyseFilesInvalidatingDependencies(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        files.forEach(new IntConsumer(this){
            final /* synthetic */ PwaTaskCache this$0;

            public final void accept(int it) {
                PwaTaskCache.access$getToAnalyseOnly$p(this.this$0).clear(it);
                PwaTaskCache.access$getToAnalyseInvalidatingDeps$p(this.this$0).set(it);
            }
            {
                this.this$0 = pwaTaskCache;
            }
        });
    }

    public final void markAnalyseFilesOnly(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        files.forEach(new IntConsumer(this){
            final /* synthetic */ PwaTaskCache this$0;

            public final void accept(int it) {
                if (!PwaTaskCache.access$getToAnalyseInvalidatingDeps$p(this.this$0).get(it)) {
                    PwaTaskCache.access$getToAnalyseOnly$p(this.this$0).set(it);
                }
            }
            {
                this.this$0 = pwaTaskCache;
            }
        });
    }

    public final boolean isEmpty() {
        return this.toAnalyseOnly.isEmpty() && this.toAnalyseInvalidatingDeps.isEmpty();
    }

    public final int getFilesToAnalyseCount() {
        return this.toAnalyseOnly.cardinality() + this.toAnalyseInvalidatingDeps.cardinality();
    }

    public final void removeAnalysisStatus(@NotNull FileIdList filesToAnalyseOnly, @NotNull FileIdList filesToAnalyseInvalidatingDeps) {
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseOnly, (String)"filesToAnalyseOnly");
        Intrinsics.checkNotNullParameter((Object)filesToAnalyseInvalidatingDeps, (String)"filesToAnalyseInvalidatingDeps");
        filesToAnalyseOnly.forEach(new IntConsumer(this){
            final /* synthetic */ PwaTaskCache this$0;

            public final void accept(int it) {
                PwaTaskCache.access$getToAnalyseOnly$p(this.this$0).clear(it);
            }
            {
                this.this$0 = pwaTaskCache;
            }
        });
        filesToAnalyseInvalidatingDeps.forEach(new IntConsumer(this){
            final /* synthetic */ PwaTaskCache this$0;

            public final void accept(int it) {
                PwaTaskCache.access$getToAnalyseInvalidatingDeps$p(this.this$0).clear(it);
            }
            {
                this.this$0 = pwaTaskCache;
            }
        });
    }

    public final void clear() {
        this.toAnalyseOnly.clear();
        this.toAnalyseInvalidatingDeps.clear();
    }

    @Nullable
    public final RawAnalysisBatch prepareBatch(int taskSize) {
        if (this.getFilesToAnalyseCount() == 0) {
            return null;
        }
        int filesToFind = taskSize;
        IntOpenHashSet filesToAnalyseOnly = new IntOpenHashSet();
        IntOpenHashSet filesToAnalyseInvalidatingDeps = new IntOpenHashSet();
        for (PwaHighPriorityFilesSuggester suggester : this.suggesters) {
            FileIdSet prioritizedFiles;
            if (suggester.suggestFilesForPriorityAnalysis(filesToFind) == null) {
                continue;
            }
            if ((filesToFind = this.dispatchPrioritizedFiles(prioritizedFiles, filesToFind, (IntSet)filesToAnalyseOnly, (IntSet)filesToAnalyseInvalidatingDeps)) != 0) continue;
            break;
        }
        if (filesToFind > 0) {
            int n;
            int it;
            BitSet $this$forEachShortCircuited$iv = this.toAnalyseInvalidatingDeps;
            boolean $i$f$forEachShortCircuited = false;
            int index$iv = $this$forEachShortCircuited$iv.nextSetBit(0);
            while (index$iv >= 0) {
                it = index$iv;
                boolean bl = false;
                if (filesToAnalyseInvalidatingDeps.add(it)) {
                    n = filesToFind;
                    filesToFind = n + -1;
                }
                if (!(filesToFind > 0)) break;
                index$iv = $this$forEachShortCircuited$iv.nextSetBit(index$iv + 1);
            }
            if (filesToFind > 0) {
                $this$forEachShortCircuited$iv = this.toAnalyseOnly;
                $i$f$forEachShortCircuited = false;
                index$iv = $this$forEachShortCircuited$iv.nextSetBit(0);
                while (index$iv >= 0) {
                    it = index$iv;
                    boolean bl = false;
                    if (filesToAnalyseOnly.add(it)) {
                        n = filesToFind;
                        filesToFind = n + -1;
                    }
                    if (!(filesToFind > 0)) break;
                    index$iv = $this$forEachShortCircuited$iv.nextSetBit(index$iv + 1);
                }
            }
        }
        boolean bl = taskSize >= filesToAnalyseOnly.size() + filesToAnalyseInvalidatingDeps.size();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new RawAnalysisBatch(new FileIdSet((IntSet)filesToAnalyseOnly), new FileIdSet((IntSet)filesToAnalyseInvalidatingDeps));
    }

    private final int dispatchPrioritizedFiles(FileIdSet prioritizedFiles, int filesToFind, IntSet filesToAnalyseOnly, IntSet filesToAnalyseInvalidatingDeps) {
        int newFilesToFind = filesToFind;
        IntIterator intIterator = prioritizedFiles.getStorage().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intIterator, (String)"prioritizedFiles.storage.iterator()");
        IntIterator iterator = intIterator;
        while (iterator.hasNext() && newFilesToFind > 0) {
            int fileId = iterator.nextInt();
            boolean added = this.toAnalyseOnly.get(fileId) ? filesToAnalyseOnly.add(fileId) : (this.toAnalyseInvalidatingDeps.get(fileId) ? filesToAnalyseInvalidatingDeps.add(fileId) : false);
            if (!added) continue;
            --newFilesToFind;
        }
        return newFilesToFind;
    }

    public PwaTaskCache(@NotNull List<? extends PwaHighPriorityFilesSuggester> suggesters) {
        Intrinsics.checkNotNullParameter(suggesters, (String)"suggesters");
        this.suggesters = suggesters;
        this.toAnalyseOnly = new BitSet();
        this.toAnalyseInvalidatingDeps = new BitSet();
    }

    public static final /* synthetic */ BitSet access$getToAnalyseOnly$p(PwaTaskCache $this) {
        return $this.toAnalyseOnly;
    }

    public static final /* synthetic */ BitSet access$getToAnalyseInvalidatingDeps$p(PwaTaskCache $this) {
        return $this.toAnalyseInvalidatingDeps;
    }
}

