/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/analysis/pwa/storage/PwaPaths;", "", "()V", "BROKEN_FILE_MARKER_NAME", "", "METADATA_FOLDER_NAME", "getMETADATA_FOLDER_NAME", "()Ljava/lang/String;", "STATE_FOLDER_NAME", "getSTATE_FOLDER_NAME", "TASKS_FOLDER_NAME", "getTASKS_FOLDER_NAME", "indexesDirPath", "Ljava/nio/file/Path;", "getAllPwaDirectories", "Ljava/nio/file/DirectoryStream;", "getProjectBrokenMarkerFilePath", "project", "Lcom/intellij/openapi/project/Project;", "projectDirPath", "getProjectIndexDirPath", "intellij.pwa.core"})
public final class PwaPaths {
    @NotNull
    private static final String METADATA_FOLDER_NAME;
    @NotNull
    private static final String STATE_FOLDER_NAME;
    @NotNull
    private static final String TASKS_FOLDER_NAME;
    private static final String BROKEN_FILE_MARKER_NAME = "broken.file.marker";
    private static final Path indexesDirPath;
    @NotNull
    public static final PwaPaths INSTANCE;

    @NotNull
    public final String getMETADATA_FOLDER_NAME() {
        return METADATA_FOLDER_NAME;
    }

    @NotNull
    public final String getSTATE_FOLDER_NAME() {
        return STATE_FOLDER_NAME;
    }

    @NotNull
    public final String getTASKS_FOLDER_NAME() {
        return TASKS_FOLDER_NAME;
    }

    @NotNull
    public final Path getProjectIndexDirPath(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path path = indexesDirPath.resolve(project2.getLocationHash());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"indexesDirPath.resolve(project.locationHash)");
        return path;
    }

    @NotNull
    public final DirectoryStream<Path> getAllPwaDirectories() {
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(indexesDirPath);
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"Files.newDirectoryStream(indexesDirPath)");
        return directoryStream;
    }

    @NotNull
    public final Path getProjectBrokenMarkerFilePath(@NotNull Path projectDirPath) {
        Intrinsics.checkNotNullParameter((Object)projectDirPath, (String)"projectDirPath");
        Path path = projectDirPath.resolve(BROKEN_FILE_MARKER_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectDirPath.resolve(BROKEN_FILE_MARKER_NAME)");
        return path;
    }

    @NotNull
    public final Path getProjectBrokenMarkerFilePath(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Path path = this.getProjectIndexDirPath(project2).resolve(BROKEN_FILE_MARKER_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getProjectIndexDirPath(p\u2026(BROKEN_FILE_MARKER_NAME)");
        return path;
    }

    private PwaPaths() {
    }

    static {
        PwaPaths pwaPaths;
        INSTANCE = pwaPaths = new PwaPaths();
        METADATA_FOLDER_NAME = "metadata";
        STATE_FOLDER_NAME = "state";
        TASKS_FOLDER_NAME = "tasks";
        Path path = PathManager.getIndexRoot().resolve("pwa");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getIndexRoot().resolve(\"pwa\")");
        indexesDirPath = path;
    }
}

