/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.statistics;

import com.intellij.analysis.pwa.statistics.PwaStateCollectorKt;
import com.intellij.analysis.pwa.storage.PwaPaths;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/statistics/PwaStateCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.pwa.core"})
public final class PwaStateCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup PWA_GROUP;
    private static final EventId1<Long> metadataIndexSize;
    private static final EventId1<Long> stateIndexSize;
    private static final EventId1<Long> tasksIndexSize;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return PWA_GROUP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Object indexNameToSize;
        Object $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean bl = false;
        HashSet<MetricEvent> events = new HashSet<MetricEvent>();
        Path projectIndexDirPath = PwaPaths.INSTANCE.getProjectIndexDirPath(project2);
        if (!Files.exists(projectIndexDirPath, new LinkOption[0])) {
            return SetsKt.emptySet();
        }
        Object object = Files.newDirectoryStream(projectIndexDirPath);
        boolean bl2 = false;
        boolean bl3 = false;
        Object object2 = null;
        try {
            void $this$associateByTo$iv$iv;
            Object children = (DirectoryStream)object;
            boolean bl4 = false;
            DirectoryStream directoryStream = children;
            Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"children");
            $this$associateBy$iv = directoryStream;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Path path;
                Path path2 = (Path)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl5 = false;
                void v1 = path;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"path");
                String string = PathsKt.getName((Path)v1);
                path = (Path)element$iv$iv;
                boolean bl6 = false;
                Path path3 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
                Long l = StatisticsUtil.roundToPowerOfTwo((long)PwaStateCollectorKt.access$getSizeInBytes(path3));
                map.put(string, l);
            }
            children = destination$iv$iv;
        }
        catch (Throwable children) {
            object2 = children;
            throw children;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        object2 = indexNameToSize = children;
        boolean children = false;
        Iterator iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            MetricEvent metricEvent;
            void indexName;
            $this$associateBy$iv = object = iterator.next();
            boolean bl7 = false;
            object2 = (String)$this$associateBy$iv.getKey();
            $this$associateBy$iv = object;
            bl7 = false;
            long size = ((Number)$this$associateBy$iv.getValue()).longValue();
            void var11_18 = indexName;
            if (Intrinsics.areEqual((Object)var11_18, (Object)PwaPaths.INSTANCE.getMETADATA_FOLDER_NAME())) {
                metricEvent = metadataIndexSize.metric((Object)size);
            } else if (Intrinsics.areEqual((Object)var11_18, (Object)PwaPaths.INSTANCE.getSTATE_FOLDER_NAME())) {
                metricEvent = stateIndexSize.metric((Object)size);
            } else {
                if (!Intrinsics.areEqual((Object)var11_18, (Object)PwaPaths.INSTANCE.getTASKS_FOLDER_NAME())) continue;
                metricEvent = tasksIndexSize.metric((Object)size);
            }
            MetricEvent event = metricEvent;
            events.add(event);
        }
        return events;
    }

    static {
        Companion = new Companion(null);
        PWA_GROUP = new EventLogGroup("analysis.pwa", 4);
        metadataIndexSize = PWA_GROUP.registerEvent("index.metadata", (EventField)EventFields.Long((String)"size_bytes"));
        stateIndexSize = PWA_GROUP.registerEvent("index.state", (EventField)EventFields.Long((String)"size_bytes"));
        tasksIndexSize = PWA_GROUP.registerEvent("index.tasks", (EventField)EventFields.Long((String)"size_bytes"));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/analysis/pwa/statistics/PwaStateCollector$Companion;", "", "()V", "PWA_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "metadataIndexSize", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "stateIndexSize", "tasksIndexSize", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

