/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser.core;

import com.intellij.analysis.pwa.PwaInternalSettings;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.analyser.PwaNotificationManager;
import com.intellij.analysis.pwa.analyser.core.PwaAnalyserDaemon;
import com.intellij.analysis.pwa.analyser.core.PwaAnalysisBatch;
import com.intellij.analysis.pwa.analyser.core.PwaContext;
import com.intellij.analysis.pwa.analyser.core.PwaDeletedFileAnalysisResult;
import com.intellij.analysis.pwa.analyser.core.PwaFileAnalysisResult;
import com.intellij.analysis.pwa.analyser.core.PwaProviderInfo;
import com.intellij.analysis.pwa.analyser.core.PwaResultCache;
import com.intellij.analysis.pwa.analyser.core.PwaTask;
import com.intellij.analysis.pwa.analyser.core.PwaTaskResultStatus;
import com.intellij.analysis.pwa.analyser.core.PwaUpdateFilesTask;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.settings.PwaSettings;
import com.intellij.analysis.pwa.statistics.PwaCounterCollector;
import com.intellij.analysis.pwa.storage.PwaFileStateWithId;
import com.intellij.analysis.pwa.support.PwaFileFilterKt;
import com.intellij.analysis.pwa.utils.PwaBundle;
import com.intellij.analysis.pwa.utils.PwaIntListUtils;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.function.IntConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%H\u0016J$\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaUpdateFilesTask;", "Lcom/intellij/analysis/pwa/analyser/core/PwaTask;", "project", "Lcom/intellij/openapi/project/Project;", "resultCache", "Lcom/intellij/analysis/pwa/analyser/core/PwaResultCache;", "notificationManager", "Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/pwa/analyser/core/PwaResultCache;Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;)V", "name", "", "getName", "()Ljava/lang/String;", "showProgress", "", "getShowProgress", "()Z", "analyse", "", "batch", "Lcom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatch;", "context", "Lcom/intellij/analysis/pwa/analyser/core/PwaContext;", "analyseFile", "Lcom/intellij/analysis/pwa/analyser/core/PwaFileAnalysisResult;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "analyseFiles", "", "Lcom/intellij/analysis/pwa/storage/PwaFileStateWithId;", "files", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "doAnalysis", "fileId", "execute", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "suggestDependenciesToAnalyze", "Lcom/intellij/analysis/pwa/analyser/HashesList;", "directlyChanged", "previousFileStates", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "Companion", "intellij.pwa.core"})
public final class PwaUpdateFilesTask
implements PwaTask {
    private final Project project;
    private final PwaResultCache resultCache;
    private final PwaNotificationManager notificationManager;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public void execute(@NotNull PwaContext context, @NotNull ProgressIndicator indicator) {
        block33: {
            void status;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
            boolean bl = progressManager.getProgressIndicator() == indicator;
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            logger.debug("PWA update started");
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = PwaTaskResultStatus.Success;
            PwaAnalyserDaemon engine = context.getDaemon();
            int analysedSuccessfullyCount = 0;
            indicator.setIndeterminate(false);
            StructuredIdeActivity activity = PwaCounterCollector.INSTANCE.startUpdate(this.project);
            long lastTime2333333332 = 0L;
            while (true) {
                PwaAnalysisBatch pwaAnalysisBatch;
                int n;
                boolean bl5;
                indicator.checkCanceled();
                long currentTime = System.currentTimeMillis();
                if (currentTime - lastTime2333333332 > (long)500) {
                    PwaAnalyserDaemon this_$iv = context.getDaemon();
                    boolean $i$f$withPwaLock = false;
                    Lock lock = PwaAnalyserDaemon.access$getLock$p(this_$iv);
                    bl5 = false;
                    n = 0;
                    lock.lock();
                    try {
                        boolean bl6 = false;
                        n = engine.getFilesToAnalyseCount();
                    }
                    finally {
                        lock.unlock();
                    }
                    int filesToAnalyseCount = n;
                    indicator.setFraction((double)analysedSuccessfullyCount / ((double)filesToAnalyseCount + (double)analysedSuccessfullyCount));
                    indicator.setText2(PwaBundle.Companion.message("pwa.update.progress.details", analysedSuccessfullyCount, filesToAnalyseCount + analysedSuccessfullyCount));
                    lastTime2333333332 = currentTime;
                }
                Lock lock = context.getLock();
                boolean bl7 = false;
                boolean bl8 = false;
                lock.lock();
                try {
                    boolean bl9 = false;
                    pwaAnalysisBatch = context.getDaemon().prepareBatch();
                }
                finally {
                    lock.unlock();
                }
                PwaAnalysisBatch batch = pwaAnalysisBatch;
                if (batch == null) break;
                boolean bl10 = batch.getSize() != 0;
                bl7 = false;
                boolean bl11 = false;
                bl11 = false;
                bl5 = false;
                if (!bl10) {
                    n = 0;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                analysedSuccessfullyCount += this.analyse(batch, context);
            }
            Lock lastTime2333333332 = context.getLock();
            boolean bl12 = false;
            boolean bl13 = false;
            lastTime2333333332.lock();
            try {
                boolean bl14 = false;
                context.getDaemon().setNeedToCreateUpdate(true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lastTime2333333332.unlock();
            }
            if ((PwaTaskResultStatus)((Object)status.element) != PwaTaskResultStatus.Success) {
                PwaSettings.Companion.getInstance(this.project).setEnabled(this.project, false);
            }
            activity.finished(new Function0<List<? extends EventPair<?>>>((Ref.ObjectRef)status){
                final /* synthetic */ Ref.ObjectRef $status;

                @NotNull
                public final List<EventPair<?>> invoke() {
                    return CollectionsKt.listOf((Object)new EventPair((EventField)PwaCounterCollector.INSTANCE.getRESULT_STATUS_EVENT_FIELD(), (Object)((Object)((PwaTaskResultStatus)((Object)this.$status.element)))));
                }
                {
                    this.$status = objectRef;
                    super(0);
                }
            });
            logger.info("Update finished");
            break block33;
            catch (Exception e) {
                block30: {
                    try {
                        if (!(e instanceof ProcessCanceledException)) {
                            logger.warn((Throwable)e);
                            status.element = PwaTaskResultStatus.Exception;
                            break block30;
                        }
                        status.element = PwaTaskResultStatus.InterruptedByUser;
                    }
                    catch (Throwable throwable) {
                        Lock lock = context.getLock();
                        boolean bl15 = false;
                        boolean bl16 = false;
                        lock.lock();
                        try {
                            boolean bl17 = false;
                            context.getDaemon().setNeedToCreateUpdate(true);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                        if ((PwaTaskResultStatus)((Object)status.element) != PwaTaskResultStatus.Success) {
                            PwaSettings.Companion.getInstance(this.project).setEnabled(this.project, false);
                        }
                        activity.finished(new /* invalid duplicate definition of identical inner class */);
                        logger.info("Update finished");
                        throw throwable;
                    }
                }
                Lock lock = context.getLock();
                boolean bl18 = false;
                boolean bl19 = false;
                lock.lock();
                try {
                    boolean bl20 = false;
                    context.getDaemon().setNeedToCreateUpdate(true);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                if ((PwaTaskResultStatus)((Object)status.element) != PwaTaskResultStatus.Success) {
                    PwaSettings.Companion.getInstance(this.project).setEnabled(this.project, false);
                }
                activity.finished(new /* invalid duplicate definition of identical inner class */);
                logger.info("Update finished");
            }
        }
    }

    @Override
    @NotNull
    public String getName() {
        return PwaBundle.Companion.message("analyse.changes.task.name", new Object[0]);
    }

    @Override
    public boolean getShowProgress() {
        return true;
    }

    private final int analyse(PwaAnalysisBatch batch, PwaContext context) {
        boolean bl;
        boolean bl2;
        PwaFileStateWithId it;
        boolean $i$f$all;
        FileIdSet filesToAnalyseOnly = batch.getFilesToAnalyseOnly();
        FileIdSet filesToAnalyseInvalidatingDeps = batch.getFilesToAnalyseInvalidatingDeps();
        List<PwaFileStateWithId> analyzedOnlyFiles = this.analyseFiles(filesToAnalyseOnly, context);
        List<PwaFileStateWithId> directlyChangedFiles = this.analyseFiles(filesToAnalyseInvalidatingDeps, context);
        HashesList dependenciesToAnalyze = this.suggestDependenciesToAnalyze(directlyChangedFiles, batch.getPreviousFileStates());
        boolean $i$f$ensure = false;
        if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
            boolean bl3;
            boolean bl4;
            block10: {
                bl4 = false;
                Iterable $this$all$iv2 = analyzedOnlyFiles;
                $i$f$all = false;
                if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv2) {
                        it = (PwaFileStateWithId)element$iv;
                        boolean bl5 = false;
                        if (batch.getFilesToAnalyseOnly().getStorage().contains(it.getFileId())) continue;
                        bl3 = false;
                        break block10;
                    }
                    bl3 = true;
                }
            }
            bl2 = bl3;
            bl = false;
            bl4 = false;
            bl4 = false;
            boolean $this$all$iv2 = false;
            if (!bl2) {
                $i$f$all = false;
                String $this$all$iv2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException($this$all$iv2.toString());
            }
        }
        $i$f$ensure = false;
        if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
            boolean bl6;
            block11: {
                boolean bl7 = false;
                Iterable $this$all$iv = directlyChangedFiles;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl6 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (PwaFileStateWithId)element$iv;
                        boolean bl8 = false;
                        if (batch.getFilesToAnalyseInvalidatingDeps().getStorage().contains(it.getFileId())) continue;
                        bl6 = false;
                        break block11;
                    }
                    bl6 = true;
                }
            }
            bl2 = bl6;
            bl = false;
            boolean bl9 = false;
            bl9 = false;
            boolean bl10 = false;
            if (!bl2) {
                boolean bl11 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        int nonCancelledCount = this.resultCache.submitResult(analyzedOnlyFiles, directlyChangedFiles, dependenciesToAnalyze);
        this.resultCache.flush();
        return nonCancelledCount;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PwaFileStateWithId> analyseFiles(FileIdSet files, PwaContext context) {
        void $this$mapNotNullTo$iv$iv;
        if (files.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List statePromises = new ArrayList(files.getSize());
        files.forEach(new IntConsumer(this, context, statePromises){
            final /* synthetic */ PwaUpdateFilesTask this$0;
            final /* synthetic */ PwaContext $context;
            final /* synthetic */ List $statePromises;

            public final void accept(int fileId) {
                NonBlockingReadAction nonBlockingReadAction = ReadAction.nonBlocking((Callable)new Callable(this, fileId){
                    final /* synthetic */ analyseFiles.1 this$0;
                    final /* synthetic */ int $fileId;

                    public final PwaFileStateWithId call() {
                        return PwaUpdateFilesTask.access$doAnalysis(this.this$0.this$0, this.$fileId, this.this$0.$context);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fileId = n;
                    }
                }).inSmartMode(PwaUpdateFilesTask.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction, (String)"ReadAction.nonBlocking(C\u2026    .inSmartMode(project)");
                NonBlockingReadAction nonBlockingAnalysis2 = nonBlockingReadAction;
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
                ProgressIndicator indicator = progressManager.getProgressIndicator();
                if (indicator != null) {
                    NonBlockingReadAction nonBlockingReadAction2 = nonBlockingAnalysis2.expireWith((Disposable)this.$context.getDaemon()).wrapProgress(indicator);
                    Intrinsics.checkNotNullExpressionValue((Object)nonBlockingReadAction2, (String)"nonBlockingAnalysis\n    \u2026 .wrapProgress(indicator)");
                    nonBlockingAnalysis2 = nonBlockingReadAction2;
                }
                CancellablePromise cancellablePromise = nonBlockingAnalysis2.submit((Executor)this.$context.getAnalysisExecutor());
                Intrinsics.checkNotNullExpressionValue((Object)cancellablePromise, (String)"nonBlockingAnalysis.subm\u2026context.analysisExecutor)");
                this.$statePromises.add(cancellablePromise);
            }
            {
                this.this$0 = pwaUpdateFilesTask;
                this.$context = pwaContext;
                this.$statePromises = list;
            }
        });
        Iterable $this$mapNotNull$iv = statePromises;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            PwaFileStateWithId pwaFileStateWithId;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CancellablePromise it = (CancellablePromise)element$iv$iv;
            boolean bl2 = false;
            if ((PwaFileStateWithId)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)((Future)it)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            PwaFileStateWithId it$iv$iv = pwaFileStateWithId;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List results = (List)destination$iv$iv;
        PsiManager.getInstance((Project)this.project).dropResolveCaches();
        return results;
    }

    @RequiresReadLock
    private final PwaFileStateWithId doAnalysis(int fileId, PwaContext context) {
        PwaFileStateWithId pwaFileStateWithId;
        Integer id;
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager manager = virtualFileManager;
        VirtualFile file = manager.findFileById(fileId);
        VirtualFile virtualFile = file;
        if (!(virtualFile instanceof VirtualFileWithId)) {
            virtualFile = null;
        }
        VirtualFileWithId virtualFileWithId = (VirtualFileWithId)virtualFile;
        Integer n = id = virtualFileWithId != null ? Integer.valueOf(virtualFileWithId.getId()) : null;
        if (id != null && id != fileId) {
            throw (Throwable)new IllegalStateException("File is unexpected: " + file + ", searched file id: " + fileId + ", file reports id: " + id);
        }
        if (file == null) {
            pwaFileStateWithId = new PwaDeletedFileAnalysisResult(fileId);
        } else {
            PwaFileStateWithId pwaFileStateWithId2;
            try {
                pwaFileStateWithId2 = this.analyseFile(file, context);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) {
                    throw (Throwable)e;
                }
                logger.warn("Exception while analysing file", (Throwable)e);
                pwaFileStateWithId2 = new PwaDeletedFileAnalysisResult(fileId);
            }
            pwaFileStateWithId = pwaFileStateWithId2;
        }
        return pwaFileStateWithId;
    }

    @RequiresReadLock
    private final PwaFileAnalysisResult analyseFile(VirtualFile file, PwaContext context) {
        String string;
        Logger logger;
        PwaFileState pwaFileState;
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file);
        if (psiFile == null) {
            pwaFileState = null;
        } else {
            Logger $this$debug$iv = PwaUpdateFilesTask.logger;
            Exception e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                logger = $this$debug$iv;
                boolean bl = false;
                string = "Analysing file: " + file;
                logger.debug(string, (Throwable)e$iv);
            }
            pwaFileState = Companion.analyseFile(file, psiFile, context.getDaemon().getSupportProviders());
        }
        PwaFileState state = pwaFileState;
        PwaFileAnalysisResult result = new PwaFileAnalysisResult(file, state);
        this.notificationManager.notifyResultListeners(result);
        Logger $this$debug$iv = PwaUpdateFilesTask.logger;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            string = "File analysed: " + file;
            logger.debug(string, (Throwable)e$iv);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final HashesList suggestDependenciesToAnalyze(List<? extends PwaFileStateWithId> directlyChanged, Int2ObjectMap<PwaFileOwnState> previousFileStates) {
        IntOpenHashSet hashes = new IntOpenHashSet();
        for (PwaFileStateWithId pwaFileStateWithId : directlyChanged) {
            int previousIndex$iv$iv;
            int $noName_1$iv$iv;
            boolean bl;
            int it;
            int it$iv;
            int value$iv$iv;
            boolean bl2;
            boolean bl3;
            void this_$iv$iv;
            void current$iv$iv;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            void previous$iv$iv;
            int fileId = pwaFileStateWithId.getFileId();
            PwaFileOwnState previous = (PwaFileOwnState)previousFileStates.get(fileId);
            PwaFileState currentState = pwaFileStateWithId.getState();
            if (previous == null) {
                Object object = currentState;
                if (object != null && (object = ((PwaFileState)object).getOwnState()) != null && (object = ((PwaFileOwnState)object).getDeclaredSymbols()) != null && (object = ((SymbolHashesList)object).getNameHashes()) != null) {
                    ((HashesList)object).forEach(new IntConsumer(hashes){
                        final /* synthetic */ IntOpenHashSet $hashes;

                        public final void accept(int hash) {
                            this.$hashes.add(hash);
                        }
                        {
                            this.$hashes = intOpenHashSet;
                        }
                    });
                }
                continue;
            }
            if (currentState == null) {
                previous.getDeclaredSymbols().getNameHashes().forEach(new IntConsumer(hashes){
                    final /* synthetic */ IntOpenHashSet $hashes;

                    public final void accept(int hash) {
                        this.$hashes.add(hash);
                    }
                    {
                        this.$hashes = intOpenHashSet;
                    }
                });
                continue;
            }
            SymbolHashesList newDeps = currentState.getOwnState().getDeclaredSymbols();
            SymbolHashesList this_$iv = previous.getDeclaredSymbols();
            boolean $i$f$diffWithNew = false;
            PwaIntListUtils pwaIntListUtils = PwaIntListUtils.INSTANCE;
            IntArrayList intArrayList = this_$iv.getNameHashes().getStorage();
            IntArrayList intArrayList2 = newDeps.getNameHashes().getStorage();
            boolean $i$f$diff = false;
            boolean $i$f$ensure = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl10 = false;
                bl7 = PwaIntListUtils.INSTANCE.isSortedDistinct((IntArrayList)previous$iv$iv);
                bl10 = false;
                bl6 = false;
                bl6 = false;
                bl5 = false;
                if (!bl7) {
                    bl4 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            boolean $i$f$ensure42 = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl11 = false;
                bl7 = PwaIntListUtils.INSTANCE.isSortedDistinct((IntArrayList)current$iv$iv);
                bl11 = false;
                bl6 = false;
                bl6 = false;
                bl5 = false;
                if (!bl7) {
                    bl4 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            void $i$f$ensure42 = this_$iv$iv;
            boolean $i$f$syncSortedBypass = false;
            boolean $i$f$ensure3 = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl12 = false;
                bl5 = CollectionsKt.sorted((Iterable)((Iterable)previous$iv$iv)).size() == previous$iv$iv.size();
                bl12 = false;
                bl4 = false;
                bl4 = false;
                bl3 = false;
                if (!bl5) {
                    bl2 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            boolean $i$f$ensure2 = false;
            if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                boolean bl13 = false;
                bl5 = CollectionsKt.sorted((Iterable)((Iterable)current$iv$iv)).size() == current$iv$iv.size();
                bl13 = false;
                bl4 = false;
                bl4 = false;
                bl3 = false;
                if (!bl5) {
                    bl2 = false;
                    String string = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
            int firstSize$iv$iv$iv = previous$iv$iv.size();
            int secondSize$iv$iv$iv = current$iv$iv.size();
            int iFirst$iv$iv$iv = 0;
            int iSecond$iv$iv$iv = 0;
            while (iFirst$iv$iv$iv < firstSize$iv$iv$iv && iSecond$iv$iv$iv < secondSize$iv$iv$iv) {
                void newIndex$iv;
                void oldIndex$iv;
                void currentIndex$iv$iv;
                int n;
                int n2;
                int firstElem$iv$iv$iv = previous$iv$iv.getInt(iFirst$iv$iv$iv);
                int secondElem$iv$iv$iv = current$iv$iv.getInt(iSecond$iv$iv$iv);
                if (firstElem$iv$iv$iv < secondElem$iv$iv$iv) {
                    int n3 = iFirst$iv$iv$iv++;
                    value$iv$iv = firstElem$iv$iv$iv;
                    boolean bl8 = false;
                    it$iv = value$iv$iv;
                    boolean bl9 = false;
                    it = it$iv;
                    bl = false;
                    hashes.add(it);
                    continue;
                }
                if (firstElem$iv$iv$iv > secondElem$iv$iv$iv) {
                    $noName_1$iv$iv = iSecond$iv$iv$iv++;
                    value$iv$iv = secondElem$iv$iv$iv;
                    n2 = 0;
                    it$iv = value$iv$iv;
                    n = 0;
                    it = it$iv;
                    bl = false;
                    hashes.add(it);
                    continue;
                }
                n2 = iSecond$iv$iv$iv;
                $noName_1$iv$iv = iFirst$iv$iv$iv;
                value$iv$iv = firstElem$iv$iv$iv;
                boolean bl14 = false;
                void var32_40 = currentIndex$iv$iv;
                n = previousIndex$iv$iv;
                int nameHash$iv = value$iv$iv;
                boolean bl15 = false;
                if (this_$iv.getSignatureHashes().getStorage().getInt((int)oldIndex$iv) != newDeps.getSignatureHashes().getStorage().getInt((int)newIndex$iv)) {
                    it = nameHash$iv;
                    bl = false;
                    hashes.add(it);
                }
                ++iFirst$iv$iv$iv;
                ++iSecond$iv$iv$iv;
            }
            while (iFirst$iv$iv$iv < firstSize$iv$iv$iv) {
                previousIndex$iv$iv = iFirst$iv$iv$iv;
                value$iv$iv = previous$iv$iv.getInt(iFirst$iv$iv$iv);
                boolean bl32 = false;
                it$iv = value$iv$iv;
                boolean bl22 = false;
                it = it$iv;
                boolean bl10 = false;
                hashes.add(it);
                ++iFirst$iv$iv$iv;
            }
            while (iSecond$iv$iv$iv < secondSize$iv$iv$iv) {
                $noName_1$iv$iv = iSecond$iv$iv$iv;
                value$iv$iv = current$iv$iv.getInt(iSecond$iv$iv$iv);
                boolean n2 = false;
                it$iv = value$iv$iv;
                boolean n = false;
                it = it$iv;
                bl = false;
                hashes.add(it);
                ++iSecond$iv$iv$iv;
            }
        }
        for (PwaFileStateWithId pwaFileStateWithId : directlyChanged) {
            hashes.remove(pwaFileStateWithId.getFileId());
        }
        IntArrayList intArrayList = new IntArrayList((IntCollection)hashes);
        intArrayList.unstableSort(IntComparators.NATURAL_COMPARATOR);
        return new HashesList(intArrayList, false, 2, null);
    }

    public PwaUpdateFilesTask(@NotNull Project project2, @NotNull PwaResultCache resultCache, @NotNull PwaNotificationManager notificationManager) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)resultCache, (String)"resultCache");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        this.project = project2;
        this.resultCache = resultCache;
        this.notificationManager = notificationManager;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaUpdateFilesTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaUpdateFilesTask.logger = logger;
    }

    public static final /* synthetic */ PwaFileStateWithId access$doAnalysis(PwaUpdateFilesTask $this, int fileId, PwaContext context) {
        return $this.doAnalysis(fileId, context);
    }

    public static final /* synthetic */ Project access$getProject$p(PwaUpdateFilesTask $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaUpdateFilesTask$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "analyseFile", "Lcom/intellij/analysis/pwa/analyser/PwaFileState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "supportProviders", "", "Lcom/intellij/analysis/pwa/analyser/core/PwaProviderInfo;", "intellij.pwa.core"})
    public static final class Companion {
        @RequiresReadLock
        @Nullable
        public final PwaFileState analyseFile(@NotNull VirtualFile file, @NotNull PsiFile psiFile, @NotNull List<PwaProviderInfo> supportProviders) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter(supportProviders, (String)"supportProviders");
            PwaFileState state = null;
            for (PwaProviderInfo supportProvider : supportProviders) {
                try {
                    boolean shouldAnalyse = PwaFileFilterKt.shouldAnalyseWithFastCheck(supportProvider.getFilter(), file, psiFile);
                    if (!shouldAnalyse) continue;
                    PwaFileState providerState = supportProvider.getExtractor().extract(file, psiFile);
                    if (state == null) {
                        state = providerState;
                        continue;
                    }
                    state = state.merge$intellij_pwa_core(providerState);
                }
                catch (Exception e) {
                    if (e instanceof ControlFlowException) {
                        throw (Throwable)e;
                    }
                    logger.warn("Exception thrown while project wide analysis update", (Throwable)e);
                }
            }
            return state;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

