/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser.core;

import com.intellij.analysis.pwa.analyser.core.PwaProjectScanner;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.utils.UtilsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0004\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0003R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaProjectScanner;", "", "project", "Lcom/intellij/openapi/project/Project;", "scanLibs", "", "filters", "", "Lcom/intellij/analysis/pwa/support/PwaFileFilter;", "(Lcom/intellij/openapi/project/Project;ZLjava/util/List;)V", "psiDocumentManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "findFilesForAnalysis", "Lcom/intellij/analysis/pwa/analyser/core/PwaProjectScanner$ScanResult;", "", "allFiles", "Lit/unimi/dsi/fastutil/ints/IntSet;", "shouldAnalyse", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "ScanResult", "intellij.pwa.core"})
public final class PwaProjectScanner {
    private final PsiManager psiDocumentManager;
    private final Project project;
    private final boolean scanLibs;
    private final List<PwaFileFilter> filters;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ScanResult findFilesForAnalysis() {
        String string;
        Logger logger;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex index = projectFileIndex;
        IntOpenHashSet files = new IntOpenHashSet();
        Int2IntOpenHashMap imlToModCount = new Int2IntOpenHashMap();
        Logger $this$debug$iv = PwaProjectScanner.logger;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger = $this$debug$iv;
            boolean bl = false;
            string = "Scanning content files";
            logger.debug(string, (Throwable)e$iv);
        }
        ManagingFS fs = ManagingFS.getInstance();
        ReadAction.nonBlocking((Runnable)new Runnable(this, index, files, imlToModCount, fs){
            final /* synthetic */ PwaProjectScanner this$0;
            final /* synthetic */ ProjectFileIndex $index;
            final /* synthetic */ IntOpenHashSet $files;
            final /* synthetic */ Int2IntOpenHashMap $imlToModCount;
            final /* synthetic */ ManagingFS $fs;

            public final void run() {
                this.$index.iterateContent(new ContentIterator(this){
                    final /* synthetic */ findFilesForAnalysis.2 this$0;

                    public final boolean processFile(@NotNull VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (file instanceof VirtualFileWithId) {
                            this.this$0.$files.add(((VirtualFileWithId)file).getId());
                            if (Intrinsics.areEqual((Object)"iml", (Object)file.getExtension())) {
                                ((Map)this.this$0.$imlToModCount).put(((VirtualFileWithId)file).getId(), this.this$0.$fs.getModificationCount(file));
                            }
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, new VirtualFileFilter(this){
                    final /* synthetic */ findFilesForAnalysis.2 this$0;

                    public final boolean accept(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return PwaProjectScanner.access$shouldAnalyse(this.this$0.this$0, it) || Intrinsics.areEqual((Object)"iml", (Object)it.getExtension());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (PwaProjectScanner.access$getScanLibs$p(this.this$0)) {
                    PwaProjectScanner.access$scanLibs(this.this$0, (IntSet)this.$files);
                } else {
                    Logger $this$debug$iv = PwaProjectScanner.access$getLogger$cp();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl = false;
                        String string = "Scanning libs omitted due to settings";
                        logger.debug(string, (Throwable)e$iv);
                    }
                }
            }
            {
                this.this$0 = pwaProjectScanner;
                this.$index = projectFileIndex;
                this.$files = intOpenHashSet;
                this.$imlToModCount = int2IntOpenHashMap;
                this.$fs = managingFS;
            }
        }).inSmartMode(this.project).executeSynchronously();
        Logger $this$debug$iv2 = PwaProjectScanner.logger;
        Exception e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            logger = $this$debug$iv2;
            boolean bl = false;
            string = "Found files for analysis: " + files.size();
            logger.debug(string, (Throwable)e$iv2);
        }
        return new ScanResult((IntSet)files, imlToModCount);
    }

    private final void scanLibs(IntSet allFiles) {
        Logger $this$debug$iv = logger;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Scanning libs";
            logger.debug(string, (Throwable)e$iv);
        }
        OrderEnumerator orderEnumerator = OrderEnumerator.orderEntries((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"OrderEnumerator.orderEntries(project)");
        OrderEnumerator orderEntries = orderEnumerator;
        VirtualFile[] virtualFileArray = orderEntries.getSourceRoots();
        Stream.of(Arrays.copyOf(virtualFileArray, virtualFileArray.length)).forEach(new Consumer(this, allFiles){
            final /* synthetic */ PwaProjectScanner this$0;
            final /* synthetic */ IntSet $allFiles;

            public final void accept(@NotNull VirtualFile root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                UtilsKt.collectAnalyzableFileIdsUnderRoot(root, this.$allFiles, PwaProjectScanner.access$getFilters$p(this.this$0));
            }
            {
                this.this$0 = pwaProjectScanner;
                this.$allFiles = intSet;
            }
        });
    }

    @RequiresReadLock
    private final boolean shouldAnalyse(VirtualFile file) {
        boolean bl;
        block9: {
            boolean bl2;
            block8: {
                Iterable $this$none$iv = this.filters;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        PwaFileFilter it = (PwaFileFilter)element$iv;
                        boolean bl3 = false;
                        if (!it.fastShouldAnalyse(file)) continue;
                        bl2 = false;
                        break block8;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return false;
            }
            PsiFile psiFile = this.psiDocumentManager.findFile(file);
            if (psiFile == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiDocumentManager.findFile(file) ?: return false");
            PsiFile psiFile2 = psiFile;
            Iterable $this$any$iv = this.filters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PwaFileFilter it = (PwaFileFilter)element$iv;
                    boolean bl4 = false;
                    if (!it.shouldAnalyse(file, psiFile2)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public PwaProjectScanner(@NotNull Project project2, boolean scanLibs2, @NotNull List<? extends PwaFileFilter> filters2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        this.project = project2;
        this.scanLibs = scanLibs2;
        this.filters = filters2;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
        this.psiDocumentManager = psiManager;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaProjectScanner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaProjectScanner.logger = logger;
    }

    public static final /* synthetic */ boolean access$shouldAnalyse(PwaProjectScanner $this, VirtualFile file) {
        return $this.shouldAnalyse(file);
    }

    public static final /* synthetic */ boolean access$getScanLibs$p(PwaProjectScanner $this) {
        return $this.scanLibs;
    }

    public static final /* synthetic */ void access$scanLibs(PwaProjectScanner $this, IntSet allFiles) {
        $this.scanLibs(allFiles);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ List access$getFilters$p(PwaProjectScanner $this) {
        return $this.filters;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaProjectScanner$ScanResult;", "", "filesForAnalysis", "Lit/unimi/dsi/fastutil/ints/IntSet;", "imlToModCount", "Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "(Lit/unimi/dsi/fastutil/ints/IntSet;Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;)V", "getFilesForAnalysis", "()Lit/unimi/dsi/fastutil/ints/IntSet;", "getImlToModCount", "()Lit/unimi/dsi/fastutil/ints/Int2IntOpenHashMap;", "intellij.pwa.core"})
    public static final class ScanResult {
        @NotNull
        private final IntSet filesForAnalysis;
        @NotNull
        private final Int2IntOpenHashMap imlToModCount;

        @NotNull
        public final IntSet getFilesForAnalysis() {
            return this.filesForAnalysis;
        }

        @NotNull
        public final Int2IntOpenHashMap getImlToModCount() {
            return this.imlToModCount;
        }

        public ScanResult(@NotNull IntSet filesForAnalysis, @NotNull Int2IntOpenHashMap imlToModCount) {
            Intrinsics.checkNotNullParameter((Object)filesForAnalysis, (String)"filesForAnalysis");
            Intrinsics.checkNotNullParameter((Object)imlToModCount, (String)"imlToModCount");
            this.filesForAnalysis = filesForAnalysis;
            this.imlToModCount = imlToModCount;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaProjectScanner$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "intellij.pwa.core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

