/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser.core;

import com.intellij.analysis.pwa.PwaInternalSettings;
import com.intellij.analysis.pwa.analyser.FileIdList;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.HashesList;
import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFilesWithErrorsSuggester;
import com.intellij.analysis.pwa.analyser.PwaHighPriorityFilesSuggester;
import com.intellij.analysis.pwa.analyser.PwaNotificationManager;
import com.intellij.analysis.pwa.analyser.PwaNotificationManagerImpl;
import com.intellij.analysis.pwa.analyser.PwaOpenedFilesSuggester;
import com.intellij.analysis.pwa.analyser.core.PwaAnalyserDaemon;
import com.intellij.analysis.pwa.analyser.core.PwaAnalyserDaemonState;
import com.intellij.analysis.pwa.analyser.core.PwaAnalysisBatch;
import com.intellij.analysis.pwa.analyser.core.PwaAnalysisBatchResult;
import com.intellij.analysis.pwa.analyser.core.PwaContext;
import com.intellij.analysis.pwa.analyser.core.PwaDaemonSettings;
import com.intellij.analysis.pwa.analyser.core.PwaProjectScanner;
import com.intellij.analysis.pwa.analyser.core.PwaProviderInfo;
import com.intellij.analysis.pwa.analyser.core.PwaResultCache;
import com.intellij.analysis.pwa.analyser.core.PwaScanProjectTask;
import com.intellij.analysis.pwa.analyser.core.PwaTask;
import com.intellij.analysis.pwa.analyser.core.PwaThreadService;
import com.intellij.analysis.pwa.analyser.core.PwaUpdateFilesTask;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaFileStateStorage;
import com.intellij.analysis.pwa.storage.PwaFileStateWithId;
import com.intellij.analysis.pwa.storage.PwaMetadataStorage;
import com.intellij.analysis.pwa.storage.PwaPaths;
import com.intellij.analysis.pwa.storage.PwaPersistentFileWithProblems;
import com.intellij.analysis.pwa.storage.PwaTaskCache;
import com.intellij.analysis.pwa.storage.PwaTaskStorage;
import com.intellij.analysis.pwa.storage.RawAnalysisBatch;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.support.PwaSupportProvider;
import com.intellij.analysis.pwa.utils.PwaIntListUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 z2\u00020\u0001:\u0001zB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010;\u001a\u00020\u001dH\u0002J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020?H\u0002J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010C\u001a\u00020DJ\u000e\u0010E\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\u0006\u0010F\u001a\u00020DJ\b\u0010G\u001a\u00020\u001dH\u0002J*\u0010H\u001a\u00020\u001d2\n\u0010I\u001a\u00060Dj\u0002`J2\u0006\u0010K\u001a\u00020D2\u0006\u0010L\u001a\u00020D2\u0006\u0010M\u001a\u00020DJ\u000e\u0010N\u001a\u00020=2\u0006\u0010O\u001a\u00020PJ\u000e\u0010Q\u001a\u00020=2\u0006\u0010O\u001a\u00020PJ\u0012\u0010R\u001a\u0006\u0012\u0002\b\u00030S2\u0006\u0010T\u001a\u00020PJ\b\u0010U\u001a\u0004\u0018\u00010VJ\u000e\u0010W\u001a\u00020=2\u0006\u0010X\u001a\u00020?J\u0014\u0010Y\u001a\u0006\u0012\u0002\b\u00030S2\b\b\u0002\u0010Z\u001a\u00020\u001dJ \u0010[\u001a\u00020=2\u0006\u0010\\\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010]\u001a\u00020DH\u0002J\u0018\u0010^\u001a\u00020=2\u0006\u0010\\\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010_\u001a\u0006\u0012\u0002\b\u00030SJ\u0015\u0010`\u001a\u00020=2\u0006\u0010a\u001a\u00020bH\u0000\u00a2\u0006\u0002\bcJ\u0010\u0010d\u001a\u00020=2\u0006\u0010T\u001a\u00020PH\u0002J\u0016\u0010e\u001a\u00020f2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020h02H\u0002J\b\u0010i\u001a\u00020=H\u0002J\u001a\u0010j\u001a\u0006\u0012\u0002\b\u00030S2\u0006\u0010k\u001a\u00020D2\u0006\u0010l\u001a\u00020mJ\u000e\u0010n\u001a\u00020=2\u0006\u0010o\u001a\u00020?J\u0018\u0010p\u001a\u00020\u001d2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tH\u0007J%\u0010u\u001a\u0002Hv\"\u0004\b\u0000\u0010v2\f\u0010w\u001a\b\u0012\u0004\u0012\u0002Hv0xH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010yR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010,\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020+8B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006{"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemon;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "stateStorage", "Lcom/intellij/analysis/pwa/storage/PwaFileStateStorage;", "taskStorage", "Lcom/intellij/analysis/pwa/storage/PwaTaskStorage;", "metadataStorage", "Lcom/intellij/analysis/pwa/storage/PwaMetadataStorage;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "analysisExecutor", "Ljava/util/concurrent/ExecutorService;", "settings", "Lcom/intellij/analysis/pwa/analyser/core/PwaDaemonSettings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/analysis/pwa/storage/PwaFileStateStorage;Lcom/intellij/analysis/pwa/storage/PwaTaskStorage;Lcom/intellij/analysis/pwa/storage/PwaMetadataStorage;Ljava/util/concurrent/locks/ReentrantLock;Ljava/util/concurrent/ExecutorService;Lcom/intellij/analysis/pwa/analyser/core/PwaDaemonSettings;)V", "activeIndicators", "", "Lcom/intellij/openapi/progress/ProgressIndicator;", "activeScheduledTasks", "", "Lcom/intellij/analysis/pwa/analyser/core/PwaTask;", "Ljava/util/concurrent/ScheduledFuture;", "cache", "Lcom/intellij/analysis/pwa/storage/PwaTaskCache;", "context", "Lcom/intellij/analysis/pwa/analyser/core/PwaContext;", "value", "", "needToCreateUpdate", "getNeedToCreateUpdate", "()Z", "setNeedToCreateUpdate", "(Z)V", "notificationManager", "Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;", "resultCache", "Lcom/intellij/analysis/pwa/analyser/core/PwaResultCache;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "shortTasksExecutor", "Lcom/intellij/util/concurrency/BoundedTaskExecutor;", "Lcom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemonState;", "state", "getState", "()Lcom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemonState;", "setState", "(Lcom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemonState;)V", "supportProviders", "", "Lcom/intellij/analysis/pwa/analyser/core/PwaProviderInfo;", "getSupportProviders", "()Ljava/util/List;", "setSupportProviders", "(Ljava/util/List;)V", "taskExecutor", "tasksMutex", "", "checkIndexWasNotMarkedAsBroken", "dispose", "", "findCurrentImlToModCount", "Lit/unimi/dsi/fastutil/ints/Int2IntMap;", "findDependantFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "declarationNameHash", "", "findSupportedProviders", "getFilesToAnalyseCount", "imlFilesChanged", "isFileStateUpToDate", "fileId", "Lcom/intellij/analysis/pwa/analyser/VFileId;", "currentModificationCount", "currentProviderNameHash", "currentVersionFingerprint", "markAnalyseFilesOnly", "toAnalyse", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "markAnalyzeFilesInvalidatingDependencies", "notifyFilesChanged", "Lorg/jetbrains/concurrency/Promise;", "files", "prepareBatch", "Lcom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatch;", "setImlModCounts", "new", "start", "forceFromScratch", "startOrDelayTask", "task", "delayMs", "startTask", "stop", "submitResult", "result", "Lcom/intellij/analysis/pwa/analyser/core/PwaAnalysisBatchResult;", "submitResult$intellij_pwa_core", "syncNotifyFilesChanged", "toFileIdList", "Lcom/intellij/analysis/pwa/analyser/FileIdList;", "states", "Lcom/intellij/analysis/pwa/storage/PwaFileStateWithId;", "tryScheduleUpdate", "updateGlobalSymbolsAndInvalidateDependencies", "id", "symbols", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "updateImlModCounts", "toAdd", "waitTasksFinished", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "withPwaLock", "R", "l", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "intellij.pwa.core"})
public final class PwaAnalyserDaemon
implements Disposable {
    private volatile PwaDaemonSettings settings;
    private final BoundedTaskExecutor shortTasksExecutor;
    private final BoundedTaskExecutor taskExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final PwaNotificationManager notificationManager;
    private final PwaContext context;
    private final PwaResultCache resultCache;
    private final PwaTaskCache cache;
    private boolean needToCreateUpdate;
    private PwaAnalyserDaemonState state;
    @NotNull
    private List<PwaProviderInfo> supportProviders;
    private final Object tasksMutex;
    private final Set<ProgressIndicator> activeIndicators;
    private final Map<PwaTask, ScheduledFuture<?>> activeScheduledTasks;
    private final Project project;
    private final PwaFileStateStorage stateStorage;
    private final PwaTaskStorage taskStorage;
    private final PwaMetadataStorage metadataStorage;
    private final ReentrantLock lock;
    private static final int BATCH_SIZE = 50;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final boolean getNeedToCreateUpdate() {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.needToCreateUpdate;
    }

    public final void setNeedToCreateUpdate(boolean value) {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.needToCreateUpdate = value;
    }

    private final PwaAnalyserDaemonState getState() {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.state;
    }

    private final void setState(PwaAnalyserDaemonState value) {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.state = value;
    }

    @NotNull
    public final List<PwaProviderInfo> getSupportProviders() {
        return this.supportProviders;
    }

    public final void setSupportProviders(@NotNull List<PwaProviderInfo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.supportProviders = list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PwaProviderInfo> findSupportedProviders() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = PwaSupportProvider.Companion.getEP().getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"PwaSupportProvider.EP.extensions");
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PwaSupportProvider pwaSupportProvider = (PwaSupportProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PwaProviderInfo pwaProviderInfo = new PwaProviderInfo(it.createFilter(this.project), it.createStateExtractor(this.project), it.getId(), it.getVersion());
            collection.add(pwaProviderInfo);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Promise<?> start(boolean forceFromScratch) throws IOException {
        PluginVerifier.verifyUltimatePlugin();
        AsyncPromise promise = new AsyncPromise();
        this.shortTasksExecutor.execute(new Runnable(this, promise, forceFromScratch){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ boolean $forceFromScratch;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void run() {
                PwaAnalyserDaemon this_$iv = this.this$0;
                boolean $i$f$withPwaLock = false;
                Lock lock = PwaAnalyserDaemon.access$getLock$p(this_$iv);
                boolean bl = false;
                boolean bl2 = false;
                lock.lock();
                try {
                    block13: {
                        Object var9_12;
                        AsyncPromise $this$compute$iv;
                        block11: {
                            block10: {
                                boolean bl3 = false;
                                $this$compute$iv = this.$promise;
                                boolean $i$f$compute = false;
                                boolean bl4 = false;
                                if (PwaAnalyserDaemon.access$getState$p(this.this$0) != PwaAnalyserDaemonState.Running || this.$forceFromScratch) break block10;
                                return;
                            }
                            try {
                                Collection<PwaFileFilter> collection;
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                boolean fromScratch;
                                boolean previousWasBroken = PwaAnalyserDaemon.access$checkIndexWasNotMarkedAsBroken(this.this$0);
                                boolean bl5 = fromScratch = this.$forceFromScratch || previousWasBroken || PwaAnalyserDaemon.access$getCache$p(this.this$0).getFilesToAnalyseCount() == 0 && PwaAnalyserDaemon.access$getStateStorage$p(this.this$0).isEmpty() || PwaAnalyserDaemon.access$imlFilesChanged(this.this$0);
                                if (fromScratch) {
                                    PwaAnalyserDaemon.access$getLogger$cp().info("Starting PWA from scratch");
                                    PwaAnalyserDaemon.access$getStateStorage$p(this.this$0).clear();
                                    PwaAnalyserDaemon.access$getTaskStorage$p(this.this$0).clear();
                                    PwaAnalyserDaemon.access$getCache$p(this.this$0).clear();
                                    PwaErrorStorage.Companion.getInstance(PwaAnalyserDaemon.access$getProject$p(this.this$0)).clear();
                                } else {
                                    List<PwaPersistentFileWithProblems> filesWithProblemsPersisted = PwaAnalyserDaemon.access$getStateStorage$p(this.this$0).getAllFilesWithProblems();
                                    PwaAnalyserDaemon.access$getNotificationManager$p(this.this$0).notifyResultListeners(filesWithProblemsPersisted);
                                    PwaAnalyserDaemon.access$getNotificationManager$p(this.this$0).flush();
                                    PwaAnalyserDaemon.access$getLogger$cp().info("Starting PWA from storage, " + filesWithProblemsPersisted.size() + " files with dependencies have to be updated");
                                }
                                Iterable iterable = this.this$0.getSupportProviders();
                                boolean bl6 = PwaAnalyserDaemon.access$getSettings$p(this.this$0).getScanLibrariesInFullReanalysis();
                                Project project2 = PwaAnalyserDaemon.access$getProject$p(this.this$0);
                                boolean $i$f$map = false;
                                void var19_21 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    PwaProviderInfo pwaProviderInfo = (PwaProviderInfo)item$iv$iv;
                                    collection = destination$iv$iv;
                                    boolean bl7 = false;
                                    PwaFileFilter pwaFileFilter = it.getFilter();
                                    collection.add(pwaFileFilter);
                                }
                                collection = (List)destination$iv$iv;
                                List list = collection;
                                boolean bl8 = bl6;
                                Project project3 = project2;
                                PwaProjectScanner scanner = new PwaProjectScanner(project3, bl8, list);
                                PwaAnalyserDaemon.access$startTask(this.this$0, new PwaScanProjectTask(scanner, fromScratch, this.this$0.getSupportProviders(), PwaAnalyserDaemon.access$getProject$p(this.this$0)), PwaAnalyserDaemon.access$getContext$p(this.this$0));
                                PwaAnalyserDaemon.access$setState$p(this.this$0, PwaAnalyserDaemonState.Running);
                                PwaAnalyserDaemon.access$tryScheduleUpdate(this.this$0);
                                var9_12 = null;
                                break block11;
                            }
                            catch (Throwable e$iv) {
                                $this$compute$iv.setError(e$iv);
                            }
                            break block13;
                        }
                        Object result$iv = var9_12;
                        $this$compute$iv.setResult(result$iv);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.$promise.setResult(null);
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$promise = asyncPromise;
                this.$forceFromScratch = bl;
            }
        });
        return (Promise)promise;
    }

    public static /* synthetic */ Promise start$default(PwaAnalyserDaemon pwaAnalyserDaemon, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = false;
        }
        return pwaAnalyserDaemon.start(bl);
    }

    @NotNull
    public final Promise<?> stop() throws IOException {
        logger.info("Stopping PWA");
        AsyncPromise promise = new AsyncPromise();
        this.shortTasksExecutor.execute(new Runnable(this, promise){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ AsyncPromise $promise;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                block16: {
                    Object var3_4;
                    AsyncPromise $this$compute$iv = this.$promise;
                    boolean $i$f$compute = false;
                    try {
                        boolean bl = false;
                        Object object = PwaAnalyserDaemon.access$getLock$p(this.this$0);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        object.lock();
                        try {
                            boolean bl4 = false;
                            if (PwaAnalyserDaemon.access$getState$p(this.this$0) == PwaAnalyserDaemonState.Stopping || PwaAnalyserDaemon.access$getState$p(this.this$0) == PwaAnalyserDaemonState.Stopped) {
                                return;
                            }
                            PwaAnalyserDaemon.access$setState$p(this.this$0, PwaAnalyserDaemonState.Stopping);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            object.unlock();
                        }
                        object = PwaAnalyserDaemon.access$getTasksMutex$p(this.this$0);
                        bl2 = false;
                        boolean bl5 = false;
                        synchronized (object) {
                            boolean bl6 = false;
                            for (ProgressIndicator indicator : PwaAnalyserDaemon.access$getActiveIndicators$p(this.this$0)) {
                                indicator.cancel();
                            }
                            PwaAnalyserDaemon.access$getActiveIndicators$p(this.this$0).clear();
                            Unit unit = Unit.INSTANCE;
                        }
                        PwaAnalyserDaemon.access$getTaskExecutor$p(this.this$0).clearAndCancelAll();
                        object = PwaAnalyserDaemon.access$getLock$p(this.this$0);
                        bl2 = false;
                        boolean bl7 = false;
                        object.lock();
                        try {
                            boolean bl8 = false;
                            PwaAnalyserDaemon.access$setState$p(this.this$0, PwaAnalyserDaemonState.Stopped);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            object.unlock();
                        }
                        var3_4 = null;
                    }
                    catch (Throwable e$iv) {
                        $this$compute$iv.setError(e$iv);
                        break block16;
                    }
                    Object result$iv = var3_4;
                    $this$compute$iv.setResult(result$iv);
                }
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$promise = asyncPromise;
            }
        });
        return (Promise)promise;
    }

    @NotNull
    public final Promise<?> updateGlobalSymbolsAndInvalidateDependencies(int id, @NotNull SymbolHashesList symbols) throws IOException {
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        AsyncPromise promise = new AsyncPromise();
        this.shortTasksExecutor.execute(new Runnable(this, promise, id, symbols){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ int $id;
            final /* synthetic */ SymbolHashesList $symbols;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void run() {
                block22: {
                    Object var3_4;
                    AsyncPromise $this$compute$iv = this.$promise;
                    boolean $i$f$compute = false;
                    try {
                        boolean bl = false;
                        Lock lock = PwaAnalyserDaemon.access$getLock$p(this.this$0);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        lock.lock();
                        try {
                            HashesList hashesList;
                            boolean bl4 = false;
                            SymbolHashesList oldGlobalSymbols = PwaAnalyserDaemon.access$getStateStorage$p(this.this$0).getGlobalSymbols(this.$id);
                            PwaAnalyserDaemon.access$getStateStorage$p(this.this$0).setGlobalSymbols(this.$id, this.$symbols);
                            if (oldGlobalSymbols == null) {
                                hashesList = this.$symbols.getNameHashes();
                            } else {
                                int previousIndex$iv$iv;
                                int n;
                                int n2;
                                int $noName_1$iv$iv;
                                boolean bl5;
                                int it;
                                boolean bl6;
                                int it$iv;
                                boolean bl7;
                                int value$iv$iv;
                                boolean bl8;
                                boolean bl9;
                                void this_$iv$iv;
                                void current$iv$iv;
                                boolean bl10;
                                boolean bl11;
                                boolean bl12;
                                void previous$iv$iv;
                                void this_$iv;
                                IntArrayList toInvalidate = new IntArrayList();
                                SymbolHashesList symbolHashesList = oldGlobalSymbols;
                                SymbolHashesList newList$iv = this.$symbols;
                                boolean $i$f$diffWithNew = false;
                                PwaIntListUtils pwaIntListUtils = PwaIntListUtils.INSTANCE;
                                IntArrayList intArrayList = this_$iv.getNameHashes().getStorage();
                                IntArrayList intArrayList2 = newList$iv.getNameHashes().getStorage();
                                boolean $i$f$diff = false;
                                boolean $i$f$ensure = false;
                                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                                    boolean bl13 = false;
                                    bl12 = PwaIntListUtils.INSTANCE.isSortedDistinct((IntArrayList)previous$iv$iv);
                                    bl13 = false;
                                    bl11 = false;
                                    bl11 = false;
                                    bl10 = false;
                                    if (!bl12) {
                                        boolean bl14 = false;
                                        String string = "Failed requirement.";
                                        throw (Throwable)new IllegalArgumentException(string.toString());
                                    }
                                }
                                $i$f$ensure = false;
                                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                                    boolean bl15 = false;
                                    bl12 = PwaIntListUtils.INSTANCE.isSortedDistinct((IntArrayList)current$iv$iv);
                                    bl15 = false;
                                    bl11 = false;
                                    bl11 = false;
                                    bl10 = false;
                                    if (!bl12) {
                                        boolean bl16 = false;
                                        String string = "Failed requirement.";
                                        throw (Throwable)new IllegalArgumentException(string.toString());
                                    }
                                }
                                void $i$f$ensure2 = this_$iv$iv;
                                boolean $i$f$syncSortedBypass = false;
                                boolean $i$f$ensure3 = false;
                                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                                    boolean bl17 = false;
                                    bl10 = CollectionsKt.sorted((Iterable)((Iterable)previous$iv$iv)).size() == previous$iv$iv.size();
                                    bl17 = false;
                                    bl9 = false;
                                    bl9 = false;
                                    bl8 = false;
                                    if (!bl10) {
                                        boolean bl18 = false;
                                        String string = "Failed requirement.";
                                        throw (Throwable)new IllegalArgumentException(string.toString());
                                    }
                                }
                                $i$f$ensure3 = false;
                                if (PwaInternalSettings.INSTANCE.sanityChecksEnabled()) {
                                    boolean bl19 = false;
                                    bl10 = CollectionsKt.sorted((Iterable)((Iterable)current$iv$iv)).size() == current$iv$iv.size();
                                    bl19 = false;
                                    bl9 = false;
                                    bl9 = false;
                                    bl8 = false;
                                    if (!bl10) {
                                        boolean bl20 = false;
                                        String string = "Failed requirement.";
                                        throw (Throwable)new IllegalArgumentException(string.toString());
                                    }
                                }
                                int firstSize$iv$iv$iv = previous$iv$iv.size();
                                int secondSize$iv$iv$iv = current$iv$iv.size();
                                int iFirst$iv$iv$iv = 0;
                                int iSecond$iv$iv$iv = 0;
                                while (iFirst$iv$iv$iv < firstSize$iv$iv$iv && iSecond$iv$iv$iv < secondSize$iv$iv$iv) {
                                    void newIndex$iv;
                                    void oldIndex$iv;
                                    void currentIndex$iv$iv;
                                    int firstElem$iv$iv$iv = previous$iv$iv.getInt(iFirst$iv$iv$iv);
                                    int secondElem$iv$iv$iv = current$iv$iv.getInt(iSecond$iv$iv$iv);
                                    if (firstElem$iv$iv$iv < secondElem$iv$iv$iv) {
                                        int n3 = iFirst$iv$iv$iv++;
                                        value$iv$iv = firstElem$iv$iv$iv;
                                        bl7 = false;
                                        it$iv = value$iv$iv;
                                        bl6 = false;
                                        it = it$iv;
                                        bl5 = false;
                                        toInvalidate.add(it);
                                        continue;
                                    }
                                    if (firstElem$iv$iv$iv > secondElem$iv$iv$iv) {
                                        $noName_1$iv$iv = iSecond$iv$iv$iv++;
                                        value$iv$iv = secondElem$iv$iv$iv;
                                        n2 = 0;
                                        it$iv = value$iv$iv;
                                        n = 0;
                                        it = it$iv;
                                        bl5 = false;
                                        toInvalidate.add(it);
                                        continue;
                                    }
                                    n2 = iSecond$iv$iv$iv;
                                    $noName_1$iv$iv = iFirst$iv$iv$iv;
                                    value$iv$iv = firstElem$iv$iv$iv;
                                    boolean bl21 = false;
                                    void var33_46 = currentIndex$iv$iv;
                                    n = previousIndex$iv$iv;
                                    int nameHash$iv = value$iv$iv;
                                    boolean bl22 = false;
                                    if (this_$iv.getSignatureHashes().getStorage().getInt((int)oldIndex$iv) != newList$iv.getSignatureHashes().getStorage().getInt((int)newIndex$iv)) {
                                        it = nameHash$iv;
                                        bl5 = false;
                                        toInvalidate.add(it);
                                    }
                                    ++iFirst$iv$iv$iv;
                                    ++iSecond$iv$iv$iv;
                                }
                                while (iFirst$iv$iv$iv < firstSize$iv$iv$iv) {
                                    previousIndex$iv$iv = iFirst$iv$iv$iv;
                                    value$iv$iv = previous$iv$iv.getInt(iFirst$iv$iv$iv);
                                    bl7 = false;
                                    it$iv = value$iv$iv;
                                    bl6 = false;
                                    it = it$iv;
                                    bl5 = false;
                                    toInvalidate.add(it);
                                    ++iFirst$iv$iv$iv;
                                }
                                while (iSecond$iv$iv$iv < secondSize$iv$iv$iv) {
                                    $noName_1$iv$iv = iSecond$iv$iv$iv;
                                    value$iv$iv = current$iv$iv.getInt(iSecond$iv$iv$iv);
                                    n2 = 0;
                                    it$iv = value$iv$iv;
                                    n = 0;
                                    it = it$iv;
                                    bl5 = false;
                                    toInvalidate.add(it);
                                    ++iSecond$iv$iv$iv;
                                }
                                hashesList = new HashesList(toInvalidate, false, 2, null);
                            }
                            HashesList toInvalidate = hashesList;
                            FileIdSet filesWithDependencies = PwaAnalyserDaemon.access$getStateStorage$p(this.this$0).findFilesWithDependencies(toInvalidate);
                            this.this$0.markAnalyseFilesOnly(filesWithDependencies);
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                        var3_4 = null;
                    }
                    catch (Throwable e$iv) {
                        $this$compute$iv.setError(e$iv);
                        break block22;
                    }
                    Object result$iv = var3_4;
                    $this$compute$iv.setResult(result$iv);
                }
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$promise = asyncPromise;
                this.$id = n;
                this.$symbols = symbolHashesList;
            }
        });
        return (Promise)promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public final boolean waitTasksFinished(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            List list;
            logger.info("Waiting PWA to finish all tasks");
            this.shortTasksExecutor.waitAllTasksExecuted(timeout, timeUnit);
            Object object = this.tasksMutex;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                list = CollectionsKt.toList((Iterable)this.activeScheduledTasks.values());
            }
            List tasksToWait = list;
            for (ScheduledFuture future : tasksToWait) {
                future.get(timeout, timeUnit);
            }
            this.taskExecutor.waitAllTasksExecuted(timeout, timeUnit);
            this.shortTasksExecutor.waitAllTasksExecuted(timeout, timeUnit);
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    @NotNull
    public final Promise<?> notifyFilesChanged(@NotNull FileIdSet files) throws IOException {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        AsyncPromise promise = new AsyncPromise();
        this.shortTasksExecutor.execute(new Runnable(this, promise, files){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ FileIdSet $files;

            public final void run() {
                block2: {
                    Object var3_4;
                    AsyncPromise $this$compute$iv = this.$promise;
                    boolean $i$f$compute = false;
                    try {
                        boolean bl = false;
                        PwaAnalyserDaemon.access$syncNotifyFilesChanged(this.this$0, this.$files);
                        var3_4 = null;
                    }
                    catch (Throwable e$iv) {
                        $this$compute$iv.setError(e$iv);
                        break block2;
                    }
                    Object result$iv = var3_4;
                    $this$compute$iv.setResult(result$iv);
                }
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$promise = asyncPromise;
                this.$files = fileIdSet;
            }
        });
        return (Promise)promise;
    }

    @Nullable
    public final PwaAnalysisBatch prepareBatch() throws IOException {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        RawAnalysisBatch rawAnalysisBatch = this.cache.prepareBatch(50);
        if (rawAnalysisBatch == null) {
            return null;
        }
        RawAnalysisBatch raw = rawAnalysisBatch;
        IntArrayList files = new IntArrayList(raw.getFilesToAnalyseOnly().getSize() + raw.getFilesToAnalyseInvalidatingDeps().getSize());
        files.addAll((IntCollection)raw.getFilesToAnalyseOnly().getStorage());
        files.addAll((IntCollection)raw.getFilesToAnalyseInvalidatingDeps().getStorage());
        Int2ObjectMap<PwaFileOwnState> stateMap = this.stateStorage.getStates(new FileIdList(files));
        return new PwaAnalysisBatch(raw.getFilesToAnalyseOnly(), raw.getFilesToAnalyseInvalidatingDeps(), stateMap);
    }

    public final int getFilesToAnalyseCount() throws IOException {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return this.cache.getFilesToAnalyseCount();
    }

    public final void markAnalyseFilesOnly(@NotNull FileIdSet toAnalyse) throws IOException {
        Intrinsics.checkNotNullParameter((Object)toAnalyse, (String)"toAnalyse");
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (toAnalyse.isEmpty()) {
            return;
        }
        this.cache.markAnalyseFilesOnly(toAnalyse);
        this.taskStorage.markAnalyzeFilesOnly(toAnalyse);
        this.tryScheduleUpdate();
    }

    public final void markAnalyzeFilesInvalidatingDependencies(@NotNull FileIdSet toAnalyse) throws IOException {
        Intrinsics.checkNotNullParameter((Object)toAnalyse, (String)"toAnalyse");
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (toAnalyse.isEmpty()) {
            return;
        }
        this.cache.markAnalyseFilesInvalidatingDependencies(toAnalyse);
        this.taskStorage.markAnalyzeFilesInvalidatingDependencies(toAnalyse);
        this.tryScheduleUpdate();
    }

    public final void setImlModCounts(@NotNull Int2IntMap int2IntMap) throws IOException {
        Intrinsics.checkNotNullParameter((Object)int2IntMap, (String)"new");
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.metadataStorage.clear();
        this.metadataStorage.putAll(int2IntMap);
    }

    public final void updateImlModCounts(@NotNull Int2IntMap toAdd) throws IOException {
        Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.metadataStorage.putAll(toAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFileStateUpToDate(int fileId, int currentModificationCount, int currentProviderNameHash, int currentVersionFingerprint) throws IOException {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!this.settings.getDoUpToDateCheck()) {
            return true;
        }
        PwaAnalyserDaemon this_$iv = this;
        boolean $i$f$withPwaLock = false;
        Lock lock = this_$iv.lock;
        boolean bl5 = false;
        boolean bl6 = false;
        lock.lock();
        try {
            boolean bl7 = false;
            PwaFileOwnState state = this.stateStorage.getState(fileId);
            if (state == null) {
                boolean bl8 = false;
                return bl8;
            }
            if (state.getModCountAtMomentOfAnalysis() != currentModificationCount) {
                boolean bl9 = false;
                return bl9;
            }
            if (state.getProvidersNameHash() != currentProviderNameHash) {
                boolean bl10 = false;
                return bl10;
            }
            if (state.getProviderVersionFingerprint() != currentVersionFingerprint) {
                boolean bl11 = false;
                return bl11;
            }
            boolean bl12 = true;
            return bl12;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean imlFilesChanged() {
        Int2IntMap imlIdToModCount = this.findCurrentImlToModCount();
        return !this.metadataStorage.isSame(imlIdToModCount);
    }

    private final Int2IntMap findCurrentImlToModCount() {
        ArrayList imlFiles = new ArrayList();
        ReadAction.nonBlocking((Runnable)new Runnable(this, imlFiles){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ ArrayList $imlFiles;

            public final void run() {
                ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)PwaAnalyserDaemon.access$getProject$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
                ProjectFileIndex index = projectFileIndex;
                index.iterateContent(new ContentIterator(this){
                    final /* synthetic */ findCurrentImlToModCount.1 this$0;

                    public final boolean processFile(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.this$0.$imlFiles.add(it);
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, (VirtualFileFilter)findCurrentImlToModCount.2.INSTANCE);
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$imlFiles = arrayList;
            }
        }).inSmartMode(this.project).executeSynchronously();
        Int2IntOpenHashMap imlIdToModCount = new Int2IntOpenHashMap();
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable(imlFiles, imlIdToModCount){
            final /* synthetic */ ArrayList $imlFiles$inlined;
            final /* synthetic */ Int2IntOpenHashMap $imlIdToModCount$inlined;
            {
                this.$imlFiles$inlined = arrayList;
                this.$imlIdToModCount$inlined = int2IntOpenHashMap;
            }

            public final T compute() {
                boolean bl = false;
                ManagingFS fs = ManagingFS.getInstance();
                for (VirtualFile imlFile : this.$imlFiles$inlined) {
                    VirtualFile virtualFile = imlFile;
                    if (!(virtualFile instanceof VirtualFileWithId)) {
                        virtualFile = null;
                    }
                    if ((VirtualFileWithId)virtualFile == null) {
                        continue;
                    }
                    int modCount = fs.getModificationCount(imlFile);
                    Map map = (Map)this.$imlIdToModCount$inlined;
                    VirtualFile virtualFile2 = imlFile;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"imlFile");
                    map.put(((VirtualFileWithId)virtualFile2).getId(), modCount);
                }
                return (T)Unit.INSTANCE;
            }
        });
        return (Int2IntMap)imlIdToModCount;
    }

    private final boolean checkIndexWasNotMarkedAsBroken() {
        boolean bl;
        Path brokenMarkerFilePath = PwaPaths.INSTANCE.getProjectBrokenMarkerFilePath(this.project);
        if (Files.exists(brokenMarkerFilePath, new LinkOption[0])) {
            FileUtil.delete((Path)brokenMarkerFilePath);
            logger.warn("Project wide analysis indexes were marked as broken, starting from scratch");
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startOrDelayTask(PwaTask task, PwaContext context, int delayMs) {
        ScheduledFuture<?> scheduledFuture2 = this.scheduledExecutor.schedule(new Runnable(this, task, context){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ PwaTask $task;
            final /* synthetic */ PwaContext $context;

            public final void run() {
                PwaAnalyserDaemon.access$startTask(this.this$0, this.$task, this.$context);
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$task = pwaTask;
                this.$context = pwaContext;
            }
        }, (long)delayMs, TimeUnit.MILLISECONDS);
        Object object = this.tasksMutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            ScheduledFuture<?> scheduledFuture3 = scheduledFuture2;
            Intrinsics.checkNotNullExpressionValue(scheduledFuture3, (String)"scheduledFuture");
            this.activeScheduledTasks.put(task, scheduledFuture3);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startTask(PwaTask task, PwaContext context) {
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(this.project, task.getName(), null, null, true);
        indicator.setDelayInMillis(3000);
        Object object = this.tasksMutex;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            bl2 = this.activeIndicators.add((ProgressIndicator)indicator);
        }
        this.taskExecutor.execute(new Runnable(this, task, context, indicator){
            final /* synthetic */ PwaAnalyserDaemon this$0;
            final /* synthetic */ PwaTask $task;
            final /* synthetic */ PwaContext $context;
            final /* synthetic */ BackgroundableProcessIndicator $indicator;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                ProgressManager.getInstance().runProcess(new Runnable(this){
                    final /* synthetic */ startTask.2 this$0;

                    public final void run() {
                        this.this$0.$task.execute(this.this$0.$context, (ProgressIndicator)this.this$0.$indicator);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, (ProgressIndicator)this.$indicator);
                Object object = PwaAnalyserDaemon.access$getTasksMutex$p(this.this$0);
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    PwaAnalyserDaemon.access$getActiveIndicators$p(this.this$0).remove(this.$indicator);
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = pwaAnalyserDaemon;
                this.$task = pwaTask;
                this.$context = pwaContext;
                this.$indicator = backgroundableProcessIndicator;
            }
        });
        object = this.tasksMutex;
        bl = false;
        bl2 = false;
        synchronized (object) {
            boolean bl4 = false;
            ScheduledFuture<?> scheduledFuture2 = this.activeScheduledTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void syncNotifyFilesChanged(FileIdSet files) {
        PwaAnalyserDaemon this_$iv = this;
        boolean $i$f$withPwaLock = false;
        Lock lock = this_$iv.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            Int2IntOpenHashMap imlFiles = new Int2IntOpenHashMap();
            ManagingFS fs = ManagingFS.getInstance();
            files.forEach(new IntConsumer(fs, imlFiles){
                final /* synthetic */ ManagingFS $fs;
                final /* synthetic */ Int2IntOpenHashMap $imlFiles;

                public final void accept(int fileId) {
                    VirtualFile virtualFile = this.$fs.findFileById(fileId);
                    if (virtualFile == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"fs.findFileById(fileId) ?: return@IntConsumer");
                    VirtualFile file = virtualFile;
                    if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"iml")) {
                        ((Map)this.$imlFiles).put(fileId, this.$fs.getModificationCount(file));
                    }
                }
                {
                    this.$fs = managingFS;
                    this.$imlFiles = int2IntOpenHashMap;
                }
            });
            Map map = (Map)imlFiles;
            boolean bl4 = false;
            if (!map.isEmpty()) {
                this.metadataStorage.putAll((Int2IntMap)imlFiles);
            }
            this.markAnalyzeFilesInvalidatingDependencies(files);
            this.resultCache.cancelFilesAnalysis(files);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void tryScheduleUpdate() {
        boolean bl = this.lock.isLocked();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.getNeedToCreateUpdate() && this.getState() == PwaAnalyserDaemonState.Running) {
            this.startOrDelayTask(new PwaUpdateFilesTask(this.project, this.resultCache, this.notificationManager), this.context, this.settings.getDelayMs());
            this.setNeedToCreateUpdate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<VirtualFile> findDependantFiles(int declarationNameHash) {
        Set<VirtualFile> set;
        PwaAnalyserDaemon this_$iv = this;
        boolean $i$f$withPwaLock = false;
        Lock lock = this_$iv.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            set = this.stateStorage.findFilesWithDependencies(new HashesList(new IntArrayList(new int[]{declarationNameHash}), false, 2, null)).toFileSet();
        }
        finally {
            lock.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void submitResult$intellij_pwa_core(@NotNull PwaAnalysisBatchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            HashesList hashesToInvalidate = result.getDependenciesToInvalidate();
            FileIdSet filesToInvalidate = this.stateStorage.findFilesWithDependencies(hashesToInvalidate);
            if (hashesToInvalidate.getSize() != 0) {
                Logger $this$debug$iv = logger;
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl4 = false;
                    String string = "Hashes changed: " + hashesToInvalidate.getSize() + ", files with these hashes: " + filesToInvalidate.toFileList();
                    logger.debug(string, (Throwable)e$iv);
                }
            }
            this.markAnalyseFilesOnly(filesToInvalidate);
            JBIterable jBIterable = JBIterable.from((Iterable)result.getSuccessfullyAnalyzedFiles()).append((Iterable)result.getSuccessfullyAnalyzedFilesInvalidatingDependencies());
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(result.s\u2026InvalidatingDependencies)");
            JBIterable allSuccessfullyAnalysedFiles = jBIterable;
            this.stateStorage.updateStates((Iterable)allSuccessfullyAnalysedFiles);
            FileIdList successfullyAnalysedOnlyFiles = this.toFileIdList(result.getSuccessfullyAnalyzedFiles());
            FileIdList successfullyAnalysedInvalidatingDependenciesFiles = this.toFileIdList(result.getSuccessfullyAnalyzedFilesInvalidatingDependencies());
            this.cache.markAnalyseFilesOnly(filesToInvalidate);
            this.taskStorage.removeAnalysisStatus(successfullyAnalysedOnlyFiles, successfullyAnalysedInvalidatingDependenciesFiles);
            this.cache.removeAnalysisStatus(successfullyAnalysedOnlyFiles, successfullyAnalysedInvalidatingDependenciesFiles);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final FileIdList toFileIdList(List<? extends PwaFileStateWithId> states) {
        IntArrayList files = new IntArrayList(states.size());
        for (PwaFileStateWithId pwaFileStateWithId : states) {
            files.add(pwaFileStateWithId.getFileId());
        }
        return new FileIdList(files);
    }

    public void dispose() {
        this.stateStorage.close();
        this.taskStorage.close();
        this.metadataStorage.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withPwaLock(@NotNull Function0<? extends R> l) {
        Object object;
        int $i$f$withPwaLock = 0;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            object = l.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            lock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PwaAnalyserDaemon(@NotNull Project project2, @NotNull PwaFileStateStorage stateStorage, @NotNull PwaTaskStorage taskStorage, @NotNull PwaMetadataStorage metadataStorage, @NotNull ReentrantLock lock, @NotNull ExecutorService analysisExecutor, @NotNull PwaDaemonSettings settings) {
        RawAnalysisBatch rawAnalysisBatch;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        Intrinsics.checkNotNullParameter((Object)taskStorage, (String)"taskStorage");
        Intrinsics.checkNotNullParameter((Object)metadataStorage, (String)"metadataStorage");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        Intrinsics.checkNotNullParameter((Object)analysisExecutor, (String)"analysisExecutor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.project = project2;
        this.stateStorage = stateStorage;
        this.taskStorage = taskStorage;
        this.metadataStorage = metadataStorage;
        this.lock = lock;
        this.settings = settings;
        this.shortTasksExecutor = PwaThreadService.Companion.getInstance().getShortTaskExecutor();
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PWA infrastructure", (int)1);
        if (executorService == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.concurrency.BoundedTaskExecutor");
        }
        this.taskExecutor = (BoundedTaskExecutor)executorService;
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"AppExecutorUtil.getAppScheduledExecutorService()");
        this.scheduledExecutor = scheduledExecutorService;
        this.notificationManager = new PwaNotificationManagerImpl(this.project, (ExecutorService)this.shortTasksExecutor);
        this.context = new PwaContext(this.project, this, this.lock, analysisExecutor);
        this.resultCache = new PwaResultCache(this, this.lock);
        this.cache = new PwaTaskCache(CollectionsKt.listOf((Object[])new PwaHighPriorityFilesSuggester[]{new PwaFilesWithErrorsSuggester(this.project), new PwaOpenedFilesSuggester()}));
        PwaAnalyserDaemon this_$iv = this;
        boolean $i$f$withPwaLock = false;
        Lock lock2 = this_$iv.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock2.lock();
        try {
            boolean bl3 = false;
            rawAnalysisBatch = this.taskStorage.getAllFilesToAnalyse();
        }
        finally {
            lock2.unlock();
        }
        RawAnalysisBatch persistedFilesToAnalyse = rawAnalysisBatch;
        this.cache.markAnalyseFilesOnly(persistedFilesToAnalyse.getFilesToAnalyseOnly());
        this.cache.markAnalyseFilesInvalidatingDependencies(persistedFilesToAnalyse.getFilesToAnalyseInvalidatingDeps());
        this.needToCreateUpdate = true;
        this.state = PwaAnalyserDaemonState.Stopped;
        this.supportProviders = this.findSupportedProviders();
        PwaSupportProvider.Companion.getEP().addChangeListener(new Runnable(){

            @Override
            public final void run() {
                this.setSupportProviders(this.findSupportedProviders());
            }
        }, (Disposable)this);
        this.tasksMutex = new Object();
        this.activeIndicators = new HashSet();
        this.activeScheduledTasks = new HashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaAnalyserDaemon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaAnalyserDaemon.logger = logger;
    }

    public static final /* synthetic */ PwaAnalyserDaemonState access$getState$p(PwaAnalyserDaemon $this) {
        return $this.getState();
    }

    public static final /* synthetic */ void access$setState$p(PwaAnalyserDaemon $this, PwaAnalyserDaemonState pwaAnalyserDaemonState) {
        $this.setState(pwaAnalyserDaemonState);
    }

    public static final /* synthetic */ boolean access$checkIndexWasNotMarkedAsBroken(PwaAnalyserDaemon $this) {
        return $this.checkIndexWasNotMarkedAsBroken();
    }

    public static final /* synthetic */ boolean access$imlFilesChanged(PwaAnalyserDaemon $this) {
        return $this.imlFilesChanged();
    }

    public static final /* synthetic */ PwaTaskCache access$getCache$p(PwaAnalyserDaemon $this) {
        return $this.cache;
    }

    public static final /* synthetic */ PwaFileStateStorage access$getStateStorage$p(PwaAnalyserDaemon $this) {
        return $this.stateStorage;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ PwaTaskStorage access$getTaskStorage$p(PwaAnalyserDaemon $this) {
        return $this.taskStorage;
    }

    public static final /* synthetic */ Project access$getProject$p(PwaAnalyserDaemon $this) {
        return $this.project;
    }

    public static final /* synthetic */ PwaNotificationManager access$getNotificationManager$p(PwaAnalyserDaemon $this) {
        return $this.notificationManager;
    }

    public static final /* synthetic */ PwaDaemonSettings access$getSettings$p(PwaAnalyserDaemon $this) {
        return $this.settings;
    }

    public static final /* synthetic */ void access$setSettings$p(PwaAnalyserDaemon $this, PwaDaemonSettings pwaDaemonSettings) {
        $this.settings = pwaDaemonSettings;
    }

    public static final /* synthetic */ void access$startTask(PwaAnalyserDaemon $this, PwaTask task, PwaContext context) {
        $this.startTask(task, context);
    }

    public static final /* synthetic */ PwaContext access$getContext$p(PwaAnalyserDaemon $this) {
        return $this.context;
    }

    public static final /* synthetic */ void access$tryScheduleUpdate(PwaAnalyserDaemon $this) {
        $this.tryScheduleUpdate();
    }

    public static final /* synthetic */ Object access$getTasksMutex$p(PwaAnalyserDaemon $this) {
        return $this.tasksMutex;
    }

    public static final /* synthetic */ Set access$getActiveIndicators$p(PwaAnalyserDaemon $this) {
        return $this.activeIndicators;
    }

    public static final /* synthetic */ BoundedTaskExecutor access$getTaskExecutor$p(PwaAnalyserDaemon $this) {
        return $this.taskExecutor;
    }

    public static final /* synthetic */ void access$syncNotifyFilesChanged(PwaAnalyserDaemon $this, FileIdSet files) {
        $this.syncNotifyFilesChanged(files);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemon$Companion;", "", "()V", "BATCH_SIZE", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.pwa.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

