/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.utils.UtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.VersionedStorageChange;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.SourceRootEntity;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\u0012\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaWorkspaceChangeListener;", "Lcom/intellij/workspaceModel/ide/WorkspaceModelChangeListener;", "service", "Lcom/intellij/analysis/pwa/analyser/PwaService;", "filters", "", "Lcom/intellij/analysis/pwa/support/PwaFileFilter;", "(Lcom/intellij/analysis/pwa/analyser/PwaService;Ljava/util/List;)V", "addLibraryRoots", "", "library", "Lcom/intellij/workspaceModel/storage/bridgeEntities/LibraryEntity;", "changed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "addModuleRoots", "entity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "addSourceRoots", "Lcom/intellij/workspaceModel/storage/bridgeEntities/SourceRootEntity;", "sourceRoots", "Lkotlin/sequences/Sequence;", "event", "Lcom/intellij/workspaceModel/storage/VersionedStorageChange;", "intellij.pwa.core"})
public final class PwaWorkspaceChangeListener
implements WorkspaceModelChangeListener {
    private final PwaService service;
    private final List<PwaFileFilter> filters;

    public void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CompactVirtualFileSet roots = new CompactVirtualFileSet();
        List libraryChanges = event.getChanges(LibraryEntity.class);
        for (EntityChange change : libraryChanges) {
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                this.addLibraryRoots((LibraryEntity)((EntityChange.Added)change).getEntity(), (Set)roots);
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                this.addLibraryRoots((LibraryEntity)((EntityChange.Removed)change).getEntity(), (Set)roots);
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced)) continue;
            this.addLibraryRoots((LibraryEntity)((EntityChange.Replaced)change).getNewEntity(), (Set)roots);
            this.addLibraryRoots((LibraryEntity)((EntityChange.Replaced)change).getOldEntity(), (Set)roots);
        }
        List moduleChanges = event.getChanges(ModuleEntity.class);
        for (EntityChange change : moduleChanges) {
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                this.addModuleRoots((ModuleEntity)((EntityChange.Added)change).getEntity(), (Set)roots);
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                this.addModuleRoots((ModuleEntity)((EntityChange.Removed)change).getEntity(), (Set)roots);
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced)) continue;
            this.addModuleRoots((ModuleEntity)((EntityChange.Replaced)change).getNewEntity(), (Set)roots);
            this.addModuleRoots((ModuleEntity)((EntityChange.Replaced)change).getOldEntity(), (Set)roots);
        }
        List sourceRootChanges = event.getChanges(SourceRootEntity.class);
        for (EntityChange change : sourceRootChanges) {
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                SourceRootEntity entity = (SourceRootEntity)((EntityChange.Added)change).getEntity();
                this.addSourceRoots(entity, (Set<VirtualFile>)((Set)roots));
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                this.addSourceRoots((SourceRootEntity)((EntityChange.Removed)change).getEntity(), (Set<VirtualFile>)((Set)roots));
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced)) continue;
            this.addSourceRoots((SourceRootEntity)((EntityChange.Replaced)change).getNewEntity(), (Set<VirtualFile>)((Set)roots));
            this.addSourceRoots((SourceRootEntity)((EntityChange.Replaced)change).getOldEntity(), (Set<VirtualFile>)((Set)roots));
        }
        IntOpenHashSet changed = new IntOpenHashSet();
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable(this, roots, changed){
            final /* synthetic */ PwaWorkspaceChangeListener this$0;
            final /* synthetic */ CompactVirtualFileSet $roots$inlined;
            final /* synthetic */ IntOpenHashSet $changed$inlined;
            {
                this.this$0 = pwaWorkspaceChangeListener;
                this.$roots$inlined = compactVirtualFileSet;
                this.$changed$inlined = intOpenHashSet;
            }

            public final T compute() {
                boolean bl = false;
                Iterator iterator = this.$roots$inlined.iterator();
                while (iterator.hasNext()) {
                    VirtualFile root;
                    VirtualFile virtualFile = root = (VirtualFile)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
                    UtilsKt.collectAnalyzableFileIdsUnderRoot(virtualFile, (IntSet)this.$changed$inlined, PwaWorkspaceChangeListener.access$getFilters$p(this.this$0));
                }
                return (T)Unit.INSTANCE;
            }
        });
        this.service.notifyFilesChanged(new FileIdSet((IntSet)changed));
    }

    private final void addSourceRoots(SourceRootEntity entity, Set<VirtualFile> changed) {
        this.addSourceRoots((Sequence<? extends SourceRootEntity>)entity.getContentRoot().getSourceRoots(), changed);
    }

    private final void addModuleRoots(ModuleEntity entity, Set<VirtualFile> changed) {
        Sequence sourceRoots = entity.getSourceRoots();
        this.addSourceRoots((Sequence<? extends SourceRootEntity>)sourceRoots, changed);
    }

    private final void addSourceRoots(Sequence<? extends SourceRootEntity> sourceRoots, Set<VirtualFile> changed) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        for (SourceRootEntity sourceRoot : sourceRoots) {
            VirtualFile file;
            String url = sourceRoot.getUrl().getUrl();
            if (fileManager.findFileByUrl(url) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fileManager.findFileByUrl(url) ?: continue");
            changed.add(file);
        }
    }

    private final void addLibraryRoots(LibraryEntity library, Set<VirtualFile> changed) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager fileManager = virtualFileManager;
        for (LibraryRoot root : library.getRoots()) {
            VirtualFile file;
            String url = root.getUrl().getUrl();
            if (fileManager.findFileByUrl(url) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fileManager.findFileByUrl(url) ?: continue");
            changed.add(file);
        }
    }

    public PwaWorkspaceChangeListener(@NotNull PwaService service, @NotNull List<? extends PwaFileFilter> filters2) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        this.service = service;
        this.filters = filters2;
    }

    public void beforeChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        WorkspaceModelChangeListener.DefaultImpls.beforeChanged((WorkspaceModelChangeListener)this, (VersionedStorageChange)event);
    }

    public static final /* synthetic */ List access$getFilters$p(PwaWorkspaceChangeListener $this) {
        return $this.filters;
    }
}

