/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.analysis.pwa.analyser.PwaVfsListener;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n0\u000ej\b\u0012\u0004\u0012\u00020\n`\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "pwaService", "Lcom/intellij/analysis/pwa/analyser/PwaService;", "errorStorage", "Lcom/intellij/analysis/pwa/analyser/PwaErrorStorage;", "(Lcom/intellij/analysis/pwa/analyser/PwaService;Lcom/intellij/analysis/pwa/analyser/PwaErrorStorage;)V", "handleDeleteNonRecursive", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "changedFiles", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "deletedFiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "Companion", "intellij.pwa.core"})
public final class PwaVfsListener
implements AsyncFileListener {
    private final PwaService pwaService;
    private final PwaErrorStorage errorStorage;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        IntOpenHashSet changedFiles = new IntOpenHashSet();
        HashSet<VirtualFile> deletedFiles = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            ProgressManager.checkCanceled();
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileCreateEvent) {
                PwaVfsListener.Companion.addIfHasId((IntSet)changedFiles, ((VFileCreateEvent)vFileEvent).getFile());
                continue;
            }
            if (vFileEvent2 instanceof VFileDeleteEvent) {
                VirtualFile file;
                Intrinsics.checkNotNullExpressionValue((Object)((VFileDeleteEvent)vFileEvent).getFile(), (String)"event.file");
                this.handleDeleteNonRecursive(file, changedFiles, deletedFiles);
                if (!file.isDirectory()) continue;
                VfsUtil.iterateChildrenRecursively((VirtualFile)file, (VirtualFileFilter)prepareChange.1.INSTANCE, (ContentIterator)new ContentIterator(this, changedFiles, deletedFiles){
                    final /* synthetic */ PwaVfsListener this$0;
                    final /* synthetic */ IntOpenHashSet $changedFiles;
                    final /* synthetic */ HashSet $deletedFiles;

                    public final boolean processFile(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ProgressManager.checkCanceled();
                        PwaVfsListener.access$handleDeleteNonRecursive(this.this$0, it, this.$changedFiles, this.$deletedFiles);
                        return true;
                    }
                    {
                        this.this$0 = pwaVfsListener;
                        this.$changedFiles = intOpenHashSet;
                        this.$deletedFiles = hashSet;
                    }
                });
                continue;
            }
            if (vFileEvent2 instanceof VFileContentChangeEvent) {
                PwaVfsListener.Companion.addIfHasId((IntSet)changedFiles, ((VFileContentChangeEvent)vFileEvent).getFile());
                continue;
            }
            if (vFileEvent2 instanceof VFileMoveEvent) {
                PwaVfsListener.Companion.addIfHasId((IntSet)changedFiles, ((VFileMoveEvent)vFileEvent).getFile());
                continue;
            }
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                PwaVfsListener.Companion.addIfHasId((IntSet)changedFiles, ((VFilePropertyChangeEvent)vFileEvent).getFile());
                continue;
            }
            if (vFileEvent2 instanceof VFileCopyEvent) {
                PwaVfsListener.Companion.addIfHasId((IntSet)changedFiles, ((VFileCopyEvent)vFileEvent).getFile());
                PwaVfsListener.Companion.addIfHasId((IntSet)changedFiles, ((VFileCopyEvent)vFileEvent).findCreatedFile());
                continue;
            }
            throw (Throwable)new RuntimeException("Event is not expected: " + vFileEvent);
        }
        return new AsyncFileListener.ChangeApplier(this, changedFiles, deletedFiles){
            final /* synthetic */ PwaVfsListener this$0;
            final /* synthetic */ IntOpenHashSet $changedFiles;
            final /* synthetic */ HashSet $deletedFiles;

            public void afterVfsChange() {
                PwaVfsListener.access$getPwaService$p(this.this$0).notifyFilesChanged(new FileIdSet((IntSet)this.$changedFiles));
                PwaVfsListener.access$getErrorStorage$p(this.this$0).deleteAll(this.$deletedFiles);
            }
            {
                this.this$0 = this$0;
                this.$changedFiles = $captured_local_variable$1;
                this.$deletedFiles = $captured_local_variable$2;
            }
        };
    }

    private final void handleDeleteNonRecursive(VirtualFile file, IntOpenHashSet changedFiles, HashSet<VirtualFile> deletedFiles) {
        if (file instanceof VirtualFileWithId) {
            changedFiles.add(((VirtualFileWithId)file).getId());
            deletedFiles.add(file);
        }
    }

    public PwaVfsListener(@NotNull PwaService pwaService, @NotNull PwaErrorStorage errorStorage) {
        Intrinsics.checkNotNullParameter((Object)pwaService, (String)"pwaService");
        Intrinsics.checkNotNullParameter((Object)errorStorage, (String)"errorStorage");
        this.pwaService = pwaService;
        this.errorStorage = errorStorage;
    }

    public static final /* synthetic */ void access$handleDeleteNonRecursive(PwaVfsListener $this, VirtualFile file, IntOpenHashSet changedFiles, HashSet deletedFiles) {
        $this.handleDeleteNonRecursive(file, changedFiles, deletedFiles);
    }

    public static final /* synthetic */ PwaService access$getPwaService$p(PwaVfsListener $this) {
        return $this.pwaService;
    }

    public static final /* synthetic */ PwaErrorStorage access$getErrorStorage$p(PwaVfsListener $this) {
        return $this.errorStorage;
    }

    @JvmStatic
    private static final void addIfHasId(IntSet $this$addIfHasId, VirtualFile el) {
        PwaVfsListener.Companion.addIfHasId($this$addIfHasId, el);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0003\u00a8\u0006\b"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaVfsListener$Companion;", "", "()V", "addIfHasId", "", "Lit/unimi/dsi/fastutil/ints/IntSet;", "el", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.pwa.core"})
    public static final class Companion {
        @JvmStatic
        private final void addIfHasId(IntSet $this$addIfHasId, VirtualFile el) {
            if (el instanceof VirtualFileWithId) {
                $this$addIfHasId.add(((VirtualFileWithId)el).getId());
                if (el.isDirectory()) {
                    VfsUtil.iterateChildrenRecursively((VirtualFile)el, (VirtualFileFilter)addIfHasId.1.INSTANCE, (ContentIterator)new ContentIterator($this$addIfHasId){
                        final /* synthetic */ IntSet $this_addIfHasId;

                        public final boolean processFile(@NotNull VirtualFile it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            ProgressManager.checkCanceled();
                            if (it instanceof VirtualFileWithId) {
                                this.$this_addIfHasId.add(((VirtualFileWithId)it).getId());
                            }
                            return true;
                        }
                        {
                            this.$this_addIfHasId = intSet;
                        }
                    });
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

