/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.analyser.PwaFailedToStartException;
import com.intellij.analysis.pwa.analyser.PwaPowerSaveModeListener;
import com.intellij.analysis.pwa.analyser.PwaPsiTreeListener;
import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.analysis.pwa.analyser.PwaServiceImpl;
import com.intellij.analysis.pwa.analyser.PwaVfsListener;
import com.intellij.analysis.pwa.analyser.PwaWorkspaceChangeListener;
import com.intellij.analysis.pwa.analyser.core.PwaAnalyserDaemon;
import com.intellij.analysis.pwa.analyser.core.PwaDaemonSettings;
import com.intellij.analysis.pwa.analyser.core.PwaThreadService;
import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaCachesInvalidator;
import com.intellij.analysis.pwa.storage.PwaPaths;
import com.intellij.analysis.pwa.storage.indexes.PwaIndexFileStateStorage;
import com.intellij.analysis.pwa.storage.indexes.PwaIndexMetadataStorage;
import com.intellij.analysis.pwa.storage.indexes.PwaIndexTaskStorage;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.support.PwaSupportProvider;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Function;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.workspaceModel.ide.WorkspaceModelChangeListener;
import com.intellij.workspaceModel.ide.WorkspaceModelTopics;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016JR\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0007\"\u0004\b\u0000\u0010\u00162<\u0010\u0017\u001a8\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u0002H\u00160\u0018H\u0002J\u001c\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u00072\u0006\u0010 \u001a\u00020\fH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\u0014\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010&\u001a\u00020'H\u0016J\f\u0010(\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u001e\u0010)\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0018\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0017R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaServiceImpl;", "Lcom/intellij/analysis/pwa/analyser/PwaService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "daemonPromise", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/analysis/pwa/analyser/core/PwaAnalyserDaemon;", "executor", "Lcom/intellij/util/concurrency/BoundedTaskExecutor;", "retryCount", "", "computeDaemonPromise", "", "newPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "continueAnalysis", "createDaemonSafe", "createDaemonUnsafe", "dispose", "doOperationOnDaemon", "R", "operation", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "daemon", "promise", "findDependantFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "declarationNameHash", "getOrCreateDaemon", "notifyFilesChanged", "files", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "start", "forceFromScratch", "", "stop", "tryRecreateDaemon", "updateGlobalSymbolsAndInvalidateDependencies", "moduleSymbolsGlobalId", "symbolsHashesList", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "waitNoTasks", "duration", "Ljava/time/Duration;", "Companion", "intellij.pwa.core"})
public final class PwaServiceImpl
implements PwaService {
    private final BoundedTaskExecutor executor;
    private volatile int retryCount;
    private AtomicReference<Promise<PwaAnalyserDaemon>> daemonPromise;
    private final Project project;
    private static final Logger logger;
    private static final int TRY_COUNT = 2;
    private static final String DELAY_MS = "pwa.delay.ms";
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public Promise<?> start(boolean forceFromScratch) {
        return this.doOperationOnDaemon((Function2)new Function2<PwaAnalyserDaemon, Promise<PwaAnalyserDaemon>, Promise<?>>(forceFromScratch){
            final /* synthetic */ boolean $forceFromScratch;

            @NotNull
            public final Promise<?> invoke(@NotNull PwaAnalyserDaemon daemon, @NotNull Promise<PwaAnalyserDaemon> $noName_1) {
                Intrinsics.checkNotNullParameter((Object)daemon, (String)"daemon");
                Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                return daemon.start(this.$forceFromScratch);
            }
            {
                this.$forceFromScratch = bl;
                super(2);
            }
        });
    }

    @Override
    @NotNull
    public Promise<?> stop() {
        return this.doOperationOnDaemon(stop.1.INSTANCE);
    }

    @Override
    @NotNull
    public Promise<?> continueAnalysis() {
        return this.start(false);
    }

    @Override
    @TestOnly
    public boolean waitNoTasks(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        boolean bl2 = false;
        this.executor.waitAllTasksExecuted(duration.toNanos(), TimeUnit.NANOSECONDS);
        long waitedForTasksNanos = System.nanoTime() - start$iv;
        PwaAnalyserDaemon daemon = null;
        boolean $i$f$measureNanoTime2 = false;
        boolean bl3 = false;
        long start$iv2 = System.nanoTime();
        boolean bl4 = false;
        Object object = this.getOrCreateDaemon().blockingGet((int)duration.minusNanos(waitedForTasksNanos).toNanos(), TimeUnit.NANOSECONDS);
        Intrinsics.checkNotNull((Object)object);
        daemon = (PwaAnalyserDaemon)object;
        long waitedForDaemonNanos = System.nanoTime() - start$iv2;
        return daemon.waitTasksFinished(duration.minusNanos(waitedForDaemonNanos + waitedForTasksNanos).toNanos(), TimeUnit.NANOSECONDS);
    }

    @Override
    @NotNull
    public Promise<Set<VirtualFile>> findDependantFiles(int declarationNameHash) {
        return this.doOperationOnDaemon((Function2)new Function2<PwaAnalyserDaemon, Promise<PwaAnalyserDaemon>, Set<? extends VirtualFile>>(declarationNameHash){
            final /* synthetic */ int $declarationNameHash;

            @NotNull
            public final Set<VirtualFile> invoke(@NotNull PwaAnalyserDaemon daemon, @NotNull Promise<PwaAnalyserDaemon> $noName_1) {
                Intrinsics.checkNotNullParameter((Object)daemon, (String)"daemon");
                Intrinsics.checkNotNullParameter($noName_1, (String)"<anonymous parameter 1>");
                return daemon.findDependantFiles(this.$declarationNameHash);
            }
            {
                this.$declarationNameHash = n;
                super(2);
            }
        });
    }

    @Override
    public void notifyFilesChanged(@NotNull FileIdSet files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.doOperationOnDaemon((Function2)new Function2<PwaAnalyserDaemon, Promise<PwaAnalyserDaemon>, Promise<? extends Object>>(this, files){
            final /* synthetic */ PwaServiceImpl this$0;
            final /* synthetic */ FileIdSet $files;

            @NotNull
            public final Promise<? extends Object> invoke(@NotNull PwaAnalyserDaemon daemon, @NotNull Promise<PwaAnalyserDaemon> promise) {
                Intrinsics.checkNotNullParameter((Object)daemon, (String)"daemon");
                Intrinsics.checkNotNullParameter(promise, (String)"promise");
                return daemon.notifyFilesChanged(this.$files).onError(new Consumer(this, promise, daemon){
                    final /* synthetic */ notifyFilesChanged.1 this$0;
                    final /* synthetic */ Promise $promise;
                    final /* synthetic */ PwaAnalyserDaemon $daemon;

                    public final void accept(Throwable e) {
                        if (e instanceof IOException) {
                            PwaServiceImpl.access$tryRecreateDaemon(this.this$0.this$0, this.$promise, this.$daemon);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$promise = promise;
                        this.$daemon = pwaAnalyserDaemon;
                    }
                });
            }
            {
                this.this$0 = pwaServiceImpl;
                this.$files = fileIdSet;
                super(2);
            }
        });
    }

    @Override
    public void updateGlobalSymbolsAndInvalidateDependencies(int moduleSymbolsGlobalId, @NotNull SymbolHashesList symbolsHashesList) {
        Intrinsics.checkNotNullParameter((Object)symbolsHashesList, (String)"symbolsHashesList");
        this.doOperationOnDaemon((Function2)new Function2<PwaAnalyserDaemon, Promise<PwaAnalyserDaemon>, Promise<? extends Object>>(this, moduleSymbolsGlobalId, symbolsHashesList){
            final /* synthetic */ PwaServiceImpl this$0;
            final /* synthetic */ int $moduleSymbolsGlobalId;
            final /* synthetic */ SymbolHashesList $symbolsHashesList;

            @NotNull
            public final Promise<? extends Object> invoke(@NotNull PwaAnalyserDaemon daemon, @NotNull Promise<PwaAnalyserDaemon> promise) {
                Intrinsics.checkNotNullParameter((Object)daemon, (String)"daemon");
                Intrinsics.checkNotNullParameter(promise, (String)"promise");
                return daemon.updateGlobalSymbolsAndInvalidateDependencies(this.$moduleSymbolsGlobalId, this.$symbolsHashesList).onError(new Consumer(this, promise, daemon){
                    final /* synthetic */ updateGlobalSymbolsAndInvalidateDependencies.1 this$0;
                    final /* synthetic */ Promise $promise;
                    final /* synthetic */ PwaAnalyserDaemon $daemon;

                    public final void accept(Throwable e) {
                        if (e instanceof IOException) {
                            PwaServiceImpl.access$tryRecreateDaemon(this.this$0.this$0, this.$promise, this.$daemon);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$promise = promise;
                        this.$daemon = pwaAnalyserDaemon;
                    }
                });
            }
            {
                this.this$0 = pwaServiceImpl;
                this.$moduleSymbolsGlobalId = n;
                this.$symbolsHashesList = symbolHashesList;
                super(2);
            }
        });
    }

    public void dispose() {
    }

    private final PwaAnalyserDaemon createDaemonSafe() {
        while (this.retryCount < 2) {
            int n = this.retryCount;
            this.retryCount = n + 1;
            try {
                return this.createDaemonUnsafe();
            }
            catch (Exception e) {
                logger.warn("Exception while creating PWA daemon, invalidating caches", (Throwable)e);
                PwaCachesInvalidator.Companion.invalidateProjectCaches(this.project);
            }
        }
        logger.warn("Failed to create PWA daemon");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final PwaAnalyserDaemon createDaemonUnsafe() throws IOException {
        Collection<PwaFileFilter> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object extension;
        Path projectIndexDir = PwaPaths.INSTANCE.getProjectIndexDirPath(this.project);
        Path projectBrokenMarkerFilePath = PwaPaths.INSTANCE.getProjectBrokenMarkerFilePath(projectIndexDir);
        if (Files.exists(projectBrokenMarkerFilePath, new LinkOption[0])) {
            FileUtil.delete((Path)projectIndexDir);
        }
        Path path = projectIndexDir.resolve(PwaPaths.INSTANCE.getSTATE_FOLDER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectIndexDir.resolve(\u2026aPaths.STATE_FOLDER_NAME)");
        PwaIndexFileStateStorage stateStorage = new PwaIndexFileStateStorage(path);
        Path path2 = projectIndexDir.resolve(PwaPaths.INSTANCE.getTASKS_FOLDER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectIndexDir.resolve(\u2026aPaths.TASKS_FOLDER_NAME)");
        PwaIndexTaskStorage taskStorage = new PwaIndexTaskStorage(path2);
        Path path3 = projectIndexDir.resolve(PwaPaths.INSTANCE.getMETADATA_FOLDER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"projectIndexDir.resolve(\u2026ths.METADATA_FOLDER_NAME)");
        PwaIndexMetadataStorage metadataStorage = new PwaIndexMetadataStorage(path3);
        BoundedTaskExecutor executor = PwaThreadService.Companion.getInstance().getAnalysisExecutor();
        logger.info("Starting PWA");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        int delayMs = application.isUnitTestMode() ? 0 : AdvancedSettings.Companion.getInt(DELAY_MS);
        PwaAnalyserDaemon daemon = new PwaAnalyserDaemon(this.project, stateStorage, taskStorage, metadataStorage, new ReentrantLock(), (ExecutorService)executor, new PwaDaemonSettings(delayMs, true, false, 4, null));
        Disposer.register((Disposable)this, (Disposable)daemon);
        PwaPsiTreeListener treeListener = new PwaPsiTreeListener(this);
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)treeListener, (Disposable)this);
        PwaVfsListener vfsListener = new PwaVfsListener(this, PwaErrorStorage.Companion.getInstance(this.project));
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)vfsListener, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection connection = messageBusConnection;
        Iterator iterator = PwaSupportProvider.Companion.getEP().extensions().iterator();
        while (iterator.hasNext()) {
            extension = (PwaSupportProvider)iterator.next();
            if (!extension.isApplicable(this.project)) continue;
            extension.registerListeners(this.project, this);
        }
        connection.subscribe(PowerSaveMode.TOPIC, (Object)new PwaPowerSaveModeListener(this.project));
        WorkspaceModelTopics workspaceModelTopics = WorkspaceModelTopics.Companion.getInstance(this.project);
        PwaService pwaService = this;
        List list = PwaSupportProvider.Companion.getEP().getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PwaSupportProvider.EP.extensionList");
        extension = list;
        PwaService pwaService2 = pwaService;
        MessageBusConnection messageBusConnection2 = connection;
        WorkspaceModelTopics workspaceModelTopics2 = workspaceModelTopics;
        boolean $i$f$map = false;
        void var14_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PwaSupportProvider pwaSupportProvider = (PwaSupportProvider)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            PwaFileFilter pwaFileFilter = it.createFilter(this.project);
            collection.add(pwaFileFilter);
        }
        Collection<PwaFileFilter> collection2 = collection = (List)destination$iv$iv;
        PwaService pwaService3 = pwaService2;
        workspaceModelTopics2.subscribeAfterModuleLoading(messageBusConnection2, (WorkspaceModelChangeListener)new PwaWorkspaceChangeListener(pwaService3, (List<? extends PwaFileFilter>)collection2));
        return daemon;
    }

    private final Promise<PwaAnalyserDaemon> getOrCreateDaemon() {
        Promise<PwaAnalyserDaemon> existingPromise = this.daemonPromise.get();
        if (existingPromise != null) {
            return existingPromise;
        }
        AsyncPromise newPromise = new AsyncPromise();
        boolean updated = this.daemonPromise.compareAndSet(null, (Promise<PwaAnalyserDaemon>)newPromise);
        if (!updated) {
            Promise<PwaAnalyserDaemon> promise = this.daemonPromise.get();
            Intrinsics.checkNotNull(promise);
            return promise;
        }
        this.computeDaemonPromise((AsyncPromise<PwaAnalyserDaemon>)newPromise);
        return (Promise)newPromise;
    }

    private final <R> Promise<R> doOperationOnDaemon(Function2<? super PwaAnalyserDaemon, ? super Promise<PwaAnalyserDaemon>, ? extends R> operation) {
        Promise<PwaAnalyserDaemon> daemonPromise = this.getOrCreateDaemon();
        Promise promise = daemonPromise.then(new Function(this, operation, daemonPromise){
            final /* synthetic */ PwaServiceImpl this$0;
            final /* synthetic */ Function2 $operation;
            final /* synthetic */ Promise $daemonPromise;

            public final R fun(PwaAnalyserDaemon it) {
                Object object;
                try {
                    PwaAnalyserDaemon pwaAnalyserDaemon = it;
                    Intrinsics.checkNotNullExpressionValue((Object)pwaAnalyserDaemon, (String)"it");
                    object = this.$operation.invoke((Object)pwaAnalyserDaemon, (Object)this.$daemonPromise);
                }
                catch (IOException e) {
                    PwaServiceImpl.access$getLogger$cp().warn((Throwable)e);
                    PwaAnalyserDaemon pwaAnalyserDaemon = it;
                    Intrinsics.checkNotNullExpressionValue((Object)pwaAnalyserDaemon, (String)"it");
                    PwaServiceImpl.access$tryRecreateDaemon(this.this$0, this.$daemonPromise, pwaAnalyserDaemon);
                    throw (Throwable)e;
                }
                return (R)object;
            }
            {
                this.this$0 = pwaServiceImpl;
                this.$operation = function2;
                this.$daemonPromise = promise;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"daemonPromise.then {\n   \u2026    throw e\n      }\n    }");
        return promise;
    }

    private final void tryRecreateDaemon(Promise<PwaAnalyserDaemon> daemonPromise, PwaAnalyserDaemon daemon) {
        AsyncPromise newPromise = new AsyncPromise();
        boolean updated = this.daemonPromise.compareAndSet(daemonPromise, (Promise<PwaAnalyserDaemon>)newPromise);
        Disposer.dispose((Disposable)daemon);
        if (updated) {
            daemon.stop();
            PwaCachesInvalidator.Companion.invalidateProjectCaches(this.project);
            this.computeDaemonPromise((AsyncPromise<PwaAnalyserDaemon>)newPromise);
        }
    }

    private final void computeDaemonPromise(AsyncPromise<PwaAnalyserDaemon> newPromise) {
        this.executor.execute(new Runnable(this, newPromise){
            final /* synthetic */ PwaServiceImpl this$0;
            final /* synthetic */ AsyncPromise $newPromise;

            public final void run() {
                block3: {
                    PwaAnalyserDaemon pwaAnalyserDaemon;
                    AsyncPromise $this$compute$iv = this.$newPromise;
                    boolean $i$f$compute = false;
                    try {
                        boolean bl = false;
                        PwaAnalyserDaemon pwaAnalyserDaemon2 = PwaServiceImpl.access$createDaemonSafe(this.this$0);
                        if (pwaAnalyserDaemon2 == null) {
                            throw (Throwable)new PwaFailedToStartException();
                        }
                        pwaAnalyserDaemon = pwaAnalyserDaemon2;
                    }
                    catch (Throwable e$iv) {
                        $this$compute$iv.setError(e$iv);
                        break block3;
                    }
                    PwaAnalyserDaemon result$iv = pwaAnalyserDaemon;
                    $this$compute$iv.setResult((Object)result$iv);
                }
            }
            {
                this.this$0 = pwaServiceImpl;
                this.$newPromise = asyncPromise;
            }
        });
    }

    public PwaServiceImpl(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.executor = PwaThreadService.Companion.getInstance().getShortTaskExecutor();
        this.daemonPromise = new AtomicReference<Object>(null);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaServiceImpl.logger = logger;
    }

    public static final /* synthetic */ void access$tryRecreateDaemon(PwaServiceImpl $this, Promise daemonPromise, PwaAnalyserDaemon daemon) {
        $this.tryRecreateDaemon((Promise<PwaAnalyserDaemon>)daemonPromise, daemon);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ PwaAnalyserDaemon access$createDaemonSafe(PwaServiceImpl $this) {
        return $this.createDaemonSafe();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaServiceImpl$Companion;", "", "()V", "DELAY_MS", "", "TRY_COUNT", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "intellij.pwa.core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

