/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaPsiTreeListener;", "Lcom/intellij/psi/PsiTreeAnyChangeAbstractAdapter;", "service", "Lcom/intellij/analysis/pwa/analyser/PwaService;", "(Lcom/intellij/analysis/pwa/analyser/PwaService;)V", "onChange", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.pwa.core"})
public final class PwaPsiTreeListener
extends PsiTreeAnyChangeAbstractAdapter {
    private final PwaService service;

    protected void onChange(@Nullable PsiFile file) {
        IntSet files;
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (!(virtualFile instanceof VirtualFileWithId)) {
            return;
        }
        IntSet intSet = files = IntSets.singleton((int)((VirtualFileWithId)virtualFile).getId());
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"files");
        this.service.notifyFilesChanged(new FileIdSet(intSet));
    }

    public PwaPsiTreeListener(@NotNull PwaService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this.service = service;
    }
}

