/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.HighlightingDuplicate;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaProblem;", "Lcom/intellij/analysis/problemsView/FileProblem;", "Lcom/intellij/analysis/problemsView/HighlightingDuplicate;", "provider", "Lcom/intellij/analysis/problemsView/ProblemsProvider;", "text", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "column", "(Lcom/intellij/analysis/problemsView/ProblemsProvider;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;II)V", "getColumn", "()I", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getLine", "getProvider", "()Lcom/intellij/analysis/problemsView/ProblemsProvider;", "getText", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "toString", "intellij.pwa.core"})
public final class PwaProblem
implements FileProblem,
HighlightingDuplicate {
    @NotNull
    private final ProblemsProvider provider;
    @NotNull
    private final String text;
    @NotNull
    private final VirtualFile file;
    private final int line;
    private final int column;

    @NotNull
    public Icon getIcon() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"HighlightDisplayLevel.ERROR");
        Icon icon = highlightDisplayLevel.getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"HighlightDisplayLevel.ERROR.icon");
        return icon;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PwaProblem)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getProvider(), (Object)((PwaProblem)other).getProvider()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getText(), (Object)((PwaProblem)other).getText()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.getFile(), (Object)((PwaProblem)other).getFile()) ^ true) {
            return false;
        }
        if (this.getLine() != ((PwaProblem)other).getLine()) {
            return false;
        }
        return this.getColumn() == ((PwaProblem)other).getColumn();
    }

    public int hashCode() {
        int result = this.getProvider().hashCode();
        result = 31 * result + this.getText().hashCode();
        result = 31 * result + this.getFile().hashCode();
        result = 31 * result + this.getLine();
        result = 31 * result + this.getColumn();
        return result;
    }

    @NotNull
    public String toString() {
        return this.getLine() + ": " + this.getText();
    }

    @NotNull
    public ProblemsProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public PwaProblem(@NotNull ProblemsProvider provider, @NotNull String text, @NotNull VirtualFile file, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.provider = provider;
        this.text = text;
        this.file = file;
        this.line = line;
        this.column = column;
    }

    @Nullable
    public String getDescription() {
        return FileProblem.DefaultImpls.getDescription((FileProblem)this);
    }

    @Nullable
    public String getGroup() {
        return FileProblem.DefaultImpls.getGroup((FileProblem)this);
    }
}

