/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.PwaFileOwnState;
import com.intellij.analysis.pwa.analyser.PwaFileState;
import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaNotificationManager;
import com.intellij.analysis.pwa.analyser.PwaNotificationManagerImpl;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import com.intellij.analysis.pwa.analyser.PwaProblemsProvider;
import com.intellij.analysis.pwa.analyser.core.PwaFileAnalysisResult;
import com.intellij.analysis.pwa.analyser.listeners.PwaResultsListener;
import com.intellij.analysis.pwa.storage.PwaPersistentFileWithProblems;
import com.intellij.analysis.pwa.storage.PwaPersistentProblem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl;", "Lcom/intellij/analysis/pwa/analyser/PwaNotificationManager;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/ExecutorService;)V", "provider", "Lcom/intellij/analysis/pwa/analyser/PwaProblemsProvider;", "publisher", "Lcom/intellij/analysis/pwa/analyser/listeners/PwaResultsListener;", "Lorg/jetbrains/annotations/NotNull;", "flush", "", "notifyListeners", "files", "", "Lcom/intellij/analysis/pwa/analyser/PwaFileWithProblems;", "notifyResultListeners", "result", "Lcom/intellij/analysis/pwa/analyser/core/PwaFileAnalysisResult;", "filesWithProblems", "Lcom/intellij/analysis/pwa/storage/PwaPersistentFileWithProblems;", "Companion", "intellij.pwa.core"})
public final class PwaNotificationManagerImpl
implements PwaNotificationManager {
    private final PwaProblemsProvider provider;
    private final PwaResultsListener publisher;
    private final Project project;
    private final ExecutorService executor;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    public void notifyResultListeners(@NotNull PwaFileAnalysisResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.executor.execute(new Runnable(this, result){
            final /* synthetic */ PwaNotificationManagerImpl this$0;
            final /* synthetic */ PwaFileAnalysisResult $result;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ notifyResultListeners.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final T compute() {
                        boolean bl = false;
                        if (!PwaNotificationManagerImpl.access$getProject$p(this.this$0.this$0).isDisposed()) {
                            Object object;
                            PwaFileWithProblems fileWithProblems = PwaNotificationManagerImpl.Companion.convertToNonPersistentProblems(this.this$0.$result.getFile(), (object = this.this$0.$result.getState()) != null && (object = ((PwaFileState)object).getOwnState()) != null ? ((PwaFileOwnState)object).getProblems() : null, PwaNotificationManagerImpl.access$getProvider$p(this.this$0.this$0));
                            List files = CollectionsKt.listOf((Object)fileWithProblems);
                            PwaNotificationManagerImpl.access$notifyListeners(this.this$0.this$0, files);
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = pwaNotificationManagerImpl;
                this.$result = pwaFileAnalysisResult;
            }
        });
    }

    @Override
    public void notifyResultListeners(@NotNull List<PwaPersistentFileWithProblems> filesWithProblems) {
        Intrinsics.checkNotNullParameter(filesWithProblems, (String)"filesWithProblems");
        this.executor.execute(new Runnable(this, filesWithProblems){
            final /* synthetic */ PwaNotificationManagerImpl this$0;
            final /* synthetic */ List $filesWithProblems;

            public final void run() {
                boolean $i$f$runReadAction = false;
                ApplicationManager.getApplication().runReadAction(new Computable(this){
                    final /* synthetic */ notifyResultListeners.2 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final T compute() {
                        boolean bl = false;
                        if (!PwaNotificationManagerImpl.access$getProject$p(this.this$0.this$0).isDisposed()) {
                            void $this$mapNotNullTo$iv$iv;
                            ManagingFS fs = ManagingFS.getInstance();
                            Iterable $this$mapNotNull$iv = this.this$0.$filesWithProblems;
                            boolean $i$f$mapNotNull = false;
                            Iterable iterable = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                PwaFileWithProblems pwaFileWithProblems;
                                T element$iv$iv$iv;
                                T element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl2 = false;
                                PwaPersistentFileWithProblems it = (PwaPersistentFileWithProblems)element$iv$iv;
                                boolean bl3 = false;
                                if (fs.findFileById(it.getFileId()) == null) {
                                    pwaFileWithProblems = null;
                                } else {
                                    VirtualFile file;
                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fs.findFileById(it.fileI\u2026?: return@mapNotNull null");
                                    pwaFileWithProblems = PwaNotificationManagerImpl.Companion.convertToNonPersistentProblems(file, it.getProblems(), PwaNotificationManagerImpl.access$getProvider$p(this.this$0.this$0));
                                }
                                if (pwaFileWithProblems == null) continue;
                                PwaFileWithProblems pwaFileWithProblems2 = pwaFileWithProblems;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                PwaFileWithProblems it$iv$iv = pwaFileWithProblems2;
                                boolean bl6 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            List nonPersistent = (List)destination$iv$iv;
                            PwaNotificationManagerImpl.access$notifyListeners(this.this$0.this$0, nonPersistent);
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
            {
                this.this$0 = pwaNotificationManagerImpl;
                this.$filesWithProblems = list;
            }
        });
    }

    private final void notifyListeners(List<PwaFileWithProblems> files) {
        this.publisher.filesUpdated(this.project, files);
        Logger $this$debug$iv = logger;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Notified about results: \n" + files;
            logger.debug(string, (Throwable)e$iv);
        }
    }

    @Override
    public void flush() {
    }

    public PwaNotificationManagerImpl(@NotNull Project project2, @NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.project = project2;
        this.executor = executor;
        this.provider = new PwaProblemsProvider(this.project);
        Object object = this.project.getMessageBus().syncPublisher(PwaResultsListener.Companion.getTOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.messageBus.syncP\u2026PwaResultsListener.TOPIC)");
        this.publisher = (PwaResultsListener)object;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaNotificationManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaNotificationManagerImpl.logger = logger;
    }

    public static final /* synthetic */ Project access$getProject$p(PwaNotificationManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ PwaProblemsProvider access$getProvider$p(PwaNotificationManagerImpl $this) {
        return $this.provider;
    }

    public static final /* synthetic */ void access$notifyListeners(PwaNotificationManagerImpl $this, List files) {
        $this.notifyListeners(files);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaNotificationManagerImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "convertToNonPersistentProblems", "Lcom/intellij/analysis/pwa/analyser/PwaFileWithProblems;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "persistentProblems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentProblem;", "provider", "Lcom/intellij/analysis/pwa/analyser/PwaProblemsProvider;", "intellij.pwa.core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @RequiresReadLock
        @NotNull
        public final PwaFileWithProblems convertToNonPersistentProblems(@NotNull VirtualFile file, @Nullable List<PwaPersistentProblem> persistentProblems, @NotNull PwaProblemsProvider provider) {
            List list;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Collection collection = persistentProblems;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                return new PwaFileWithProblems(file, CollectionsKt.emptyList());
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (!file.isValid() || document == null) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                int textLength = document.getTextLength();
                Iterable $this$map$iv = persistentProblems;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PwaPersistentProblem pwaPersistentProblem = (PwaPersistentProblem)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    int usedOffset = textLength <= it.getOffset() ? textLength - 1 : it.getOffset();
                    int line = document.getLineNumber(usedOffset);
                    int column = usedOffset - document.getLineStartOffset(line);
                    boolean bl4 = column >= 0;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean bl7 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    PwaProblem pwaProblem = new PwaProblem(provider, it.getMessage(), file, line, column);
                    collection2.add(pwaProblem);
                }
                list = (List)destination$iv$iv;
            }
            List problems2 = list;
            return new PwaFileWithProblems(file, problems2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

