/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.declared.SymbolHashesList;
import com.intellij.analysis.pwa.storage.PwaPersistentProblem;
import com.intellij.analysis.pwa.utils.PwaHashUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00d6\u0001J\u0015\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaFileOwnState;", "", "problems", "", "Lcom/intellij/analysis/pwa/storage/PwaPersistentProblem;", "declaredSymbols", "Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "modCountAtMomentOfAnalysis", "", "providersNameHash", "providerVersionFingerprint", "(Ljava/util/List;Lcom/intellij/analysis/pwa/declared/SymbolHashesList;III)V", "getDeclaredSymbols", "()Lcom/intellij/analysis/pwa/declared/SymbolHashesList;", "getModCountAtMomentOfAnalysis", "()I", "getProblems", "()Ljava/util/List;", "getProviderVersionFingerprint", "getProvidersNameHash", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "merge", "merge$intellij_pwa_core", "toString", "", "intellij.pwa.core"})
public final class PwaFileOwnState {
    @NotNull
    private final List<PwaPersistentProblem> problems;
    @NotNull
    private final SymbolHashesList declaredSymbols;
    private final int modCountAtMomentOfAnalysis;
    private final int providersNameHash;
    private final int providerVersionFingerprint;

    @NotNull
    public final PwaFileOwnState merge$intellij_pwa_core(@NotNull PwaFileOwnState other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean bl = this.modCountAtMomentOfAnalysis == other.modCountAtMomentOfAnalysis;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Mod count differs for states: " + this + ", " + other;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int providersNameHash = PwaHashUtils.combineHash(this.providersNameHash, other.providersNameHash);
        int versionFingerprint = PwaHashUtils.combineHash(this.providerVersionFingerprint, other.providerVersionFingerprint);
        SymbolHashesList mergedDeclaredDependencies = this.declaredSymbols.merge$intellij_pwa_core(other.declaredSymbols);
        return new PwaFileOwnState(CollectionsKt.plus((Collection)this.problems, (Iterable)other.problems), mergedDeclaredDependencies, this.modCountAtMomentOfAnalysis, providersNameHash, versionFingerprint);
    }

    @NotNull
    public final List<PwaPersistentProblem> getProblems() {
        return this.problems;
    }

    @NotNull
    public final SymbolHashesList getDeclaredSymbols() {
        return this.declaredSymbols;
    }

    public final int getModCountAtMomentOfAnalysis() {
        return this.modCountAtMomentOfAnalysis;
    }

    public final int getProvidersNameHash() {
        return this.providersNameHash;
    }

    public final int getProviderVersionFingerprint() {
        return this.providerVersionFingerprint;
    }

    public PwaFileOwnState(@NotNull List<PwaPersistentProblem> problems2, @NotNull SymbolHashesList declaredSymbols2, int modCountAtMomentOfAnalysis, int providersNameHash, int providerVersionFingerprint) {
        Intrinsics.checkNotNullParameter(problems2, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)declaredSymbols2, (String)"declaredSymbols");
        this.problems = problems2;
        this.declaredSymbols = declaredSymbols2;
        this.modCountAtMomentOfAnalysis = modCountAtMomentOfAnalysis;
        this.providersNameHash = providersNameHash;
        this.providerVersionFingerprint = providerVersionFingerprint;
    }

    @NotNull
    public final List<PwaPersistentProblem> component1() {
        return this.problems;
    }

    @NotNull
    public final SymbolHashesList component2() {
        return this.declaredSymbols;
    }

    public final int component3() {
        return this.modCountAtMomentOfAnalysis;
    }

    public final int component4() {
        return this.providersNameHash;
    }

    public final int component5() {
        return this.providerVersionFingerprint;
    }

    @NotNull
    public final PwaFileOwnState copy(@NotNull List<PwaPersistentProblem> problems2, @NotNull SymbolHashesList declaredSymbols2, int modCountAtMomentOfAnalysis, int providersNameHash, int providerVersionFingerprint) {
        Intrinsics.checkNotNullParameter(problems2, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)declaredSymbols2, (String)"declaredSymbols");
        return new PwaFileOwnState(problems2, declaredSymbols2, modCountAtMomentOfAnalysis, providersNameHash, providerVersionFingerprint);
    }

    public static /* synthetic */ PwaFileOwnState copy$default(PwaFileOwnState pwaFileOwnState, List list, SymbolHashesList symbolHashesList, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            list = pwaFileOwnState.problems;
        }
        if ((n4 & 2) != 0) {
            symbolHashesList = pwaFileOwnState.declaredSymbols;
        }
        if ((n4 & 4) != 0) {
            n = pwaFileOwnState.modCountAtMomentOfAnalysis;
        }
        if ((n4 & 8) != 0) {
            n2 = pwaFileOwnState.providersNameHash;
        }
        if ((n4 & 0x10) != 0) {
            n3 = pwaFileOwnState.providerVersionFingerprint;
        }
        return pwaFileOwnState.copy(list, symbolHashesList, n, n2, n3);
    }

    @NotNull
    public String toString() {
        return "PwaFileOwnState(problems=" + this.problems + ", declaredSymbols=" + this.declaredSymbols + ", modCountAtMomentOfAnalysis=" + this.modCountAtMomentOfAnalysis + ", providersNameHash=" + this.providersNameHash + ", providerVersionFingerprint=" + this.providerVersionFingerprint + ")";
    }

    public int hashCode() {
        List<PwaPersistentProblem> list = this.problems;
        SymbolHashesList symbolHashesList = this.declaredSymbols;
        return ((((list != null ? ((Object)list).hashCode() : 0) * 31 + (symbolHashesList != null ? ((Object)symbolHashesList).hashCode() : 0)) * 31 + Integer.hashCode(this.modCountAtMomentOfAnalysis)) * 31 + Integer.hashCode(this.providersNameHash)) * 31 + Integer.hashCode(this.providerVersionFingerprint);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof PwaFileOwnState)) break block3;
                PwaFileOwnState pwaFileOwnState = (PwaFileOwnState)object;
                if (!Intrinsics.areEqual(this.problems, pwaFileOwnState.problems) || !Intrinsics.areEqual((Object)this.declaredSymbols, (Object)pwaFileOwnState.declaredSymbols) || this.modCountAtMomentOfAnalysis != pwaFileOwnState.modCountAtMomentOfAnalysis || this.providersNameHash != pwaFileOwnState.providersNameHash || this.providerVersionFingerprint != pwaFileOwnState.providerVersionFingerprint) break block3;
            }
            return true;
        }
        return false;
    }
}

