/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import com.intellij.analysis.pwa.analyser.listeners.PwaResultsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\u0006\u0010\u0014\u001a\u00020\u0010J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0006\u0010\u0016\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d0\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0007\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaErrorStorage;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collector", "Lcom/intellij/analysis/problemsView/ProblemsCollector;", "fileProblems", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/analysis/pwa/analyser/PwaProblem;", "Lkotlin/collections/HashMap;", "lock", "Ljava/lang/Object;", "clear", "", "deleteAll", "files", "", "disable", "dispose", "enable", "getFilesWithErrors", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "limit", "", "getStorageCopy", "", "", "Companion", "intellij.pwa.core"})
public final class PwaErrorStorage
implements Disposable {
    private final Object lock;
    private final HashMap<VirtualFile, Set<PwaProblem>> fileProblems;
    private final ProblemsCollector collector;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disable() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (Set<PwaProblem> problems2 : this.fileProblems.values()) {
                for (PwaProblem problem : problems2) {
                    this.collector.problemDisappeared((Problem)problem);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enable() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (Set<PwaProblem> problems2 : this.fileProblems.values()) {
                for (PwaProblem problem : problems2) {
                    this.collector.problemAppeared((Problem)problem);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, Set<PwaProblem>> getStorageCopy() {
        HashMap copy = new HashMap(this.fileProblems.size());
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            Map map = this.fileProblems;
            boolean bl4 = false;
            for (Map.Entry entry : map.entrySet()) {
                void key;
                Object object2 = entry;
                boolean bl5 = false;
                map = (VirtualFile)object2.getKey();
                object2 = entry;
                bl5 = false;
                Set value = (Set)object2.getValue();
                object2 = value;
                bl5 = false;
                boolean bl6 = !object2.isEmpty();
                bl5 = false;
                boolean bl7 = false;
                if (_Assertions.ENABLED && !bl6) {
                    boolean bl8 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                ((Map)copy).put(key, new HashSet(value));
            }
            Unit unit = Unit.INSTANCE;
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FileIdSet getFilesWithErrors(int limit) {
        IntOpenHashSet copy = new IntOpenHashSet();
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (VirtualFile file : this.fileProblems.keySet()) {
                VirtualFile virtualFile = file;
                if (!(virtualFile instanceof VirtualFileWithId)) {
                    virtualFile = null;
                }
                VirtualFileWithId virtualFileWithId = (VirtualFileWithId)virtualFile;
                if (virtualFileWithId == null) {
                    continue;
                }
                int id = virtualFileWithId.getId();
                copy.add(id);
                if (copy.size() < limit) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        return new FileIdSet((IntSet)copy);
    }

    public static /* synthetic */ FileIdSet getFilesWithErrors$default(PwaErrorStorage pwaErrorStorage, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 50;
        }
        return pwaErrorStorage.getFilesWithErrors(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteAll(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (VirtualFile virtualFile : files) {
                Set<PwaProblem> fileProblems = this.fileProblems.remove(virtualFile);
                if (fileProblems == null) continue;
                for (PwaProblem fileProblem : fileProblems) {
                    this.collector.problemDisappeared((Problem)fileProblem);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            for (Set<PwaProblem> fileProblems : this.fileProblems.values()) {
                for (PwaProblem fileProblem : fileProblems) {
                    this.collector.problemDisappeared((Problem)fileProblem);
                }
            }
            this.fileProblems.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public void dispose() {
    }

    public PwaErrorStorage(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.lock = new Object();
        this.fileProblems = new HashMap();
        Project $this$service$iv = project2;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(ProblemsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        this.collector = (ProblemsCollector)object;
        project2.getMessageBus().connect((Disposable)this).subscribe(PwaResultsListener.Companion.getTOPIC(), (Object)new PwaResultsListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void filesUpdated(@NotNull Project project2, @NotNull List<PwaFileWithProblems> updated) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter(updated, (String)"updated");
                Object object = lock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    for (PwaFileWithProblems fileWithProblems : updated) {
                        String string;
                        Logger logger;
                        Collection problemsToDelete;
                        VirtualFile file = fileWithProblems.getFile();
                        if (fileWithProblems.getProblems().isEmpty() && (problemsToDelete = (Set)fileProblems.remove(file)) != null) {
                            for (PwaProblem problem : problemsToDelete) {
                                collector.problemDisappeared((Problem)problem);
                                Logger $this$debug$iv = logger;
                                Exception e$iv = null;
                                boolean $i$f$debug = false;
                                if (!$this$debug$iv.isDebugEnabled()) continue;
                                logger = $this$debug$iv;
                                boolean bl4 = false;
                                string = "Problem updated: " + problem;
                                logger.debug(string, (Throwable)e$iv);
                            }
                        }
                        problemsToDelete = fileWithProblems.getProblems();
                        boolean problem = false;
                        if (!(!problemsToDelete.isEmpty())) continue;
                        Object v = fileProblems.computeIfAbsent(file, filesUpdated.1.existingProblems.1.INSTANCE);
                        Intrinsics.checkNotNullExpressionValue(v, (String)"fileProblems.computeIfAbsent(file) { HashSet() }");
                        Set existingProblems2 = (Set)v;
                        HashSet<PwaProblem> updatedOrAppeared = new HashSet<PwaProblem>();
                        for (PwaProblem problem2 : fileWithProblems.getProblems()) {
                            boolean $i$f$debug;
                            Exception e$iv;
                            Logger $this$debug$iv;
                            boolean existedEarlier;
                            updatedOrAppeared.add(problem2);
                            boolean bl5 = existedEarlier = !existingProblems2.add(problem2);
                            if (existedEarlier) {
                                collector.problemUpdated((Problem)problem2);
                                $this$debug$iv = logger;
                                e$iv = null;
                                $i$f$debug = false;
                                if (!$this$debug$iv.isDebugEnabled()) continue;
                                logger = $this$debug$iv;
                                boolean bl6 = false;
                                string = "Problem updated: " + problem2;
                                logger.debug(string, (Throwable)e$iv);
                                continue;
                            }
                            collector.problemAppeared((Problem)problem2);
                            $this$debug$iv = logger;
                            e$iv = null;
                            $i$f$debug = false;
                            if (!$this$debug$iv.isDebugEnabled()) continue;
                            logger = $this$debug$iv;
                            boolean bl7 = false;
                            string = "Problem appeared: " + problem2;
                            logger.debug(string, (Throwable)e$iv);
                        }
                        Iterator iterator = existingProblems2.iterator();
                        while (iterator.hasNext()) {
                            PwaProblem existingProblem = (PwaProblem)iterator.next();
                            if (updatedOrAppeared.contains(existingProblem)) continue;
                            iterator.remove();
                            collector.problemDisappeared((Problem)existingProblem);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaErrorStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaErrorStorage.logger = logger;
    }

    @JvmStatic
    @NotNull
    public static final PwaErrorStorage getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u001b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaErrorStorage$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "getInstance", "Lcom/intellij/analysis/pwa/analyser/PwaErrorStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.pwa.core"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        @JvmStatic
        @NotNull
        public final PwaErrorStorage getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Project $this$service$iv = project2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(PwaErrorStorage.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (PwaErrorStorage)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

