/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.analyser;

import com.intellij.analysis.pwa.analyser.PwaAvailabilityEstimator$mayEnablePwa$;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.support.PwaSupportProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/analysis/pwa/analyser/PwaAvailabilityEstimator;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "mayEnablePwa", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldEnablePwa", "intellij.pwa.core"})
public final class PwaAvailabilityEstimator {
    private static final Logger logger;
    @NotNull
    public static final PwaAvailabilityEstimator INSTANCE;

    public final boolean shouldEnablePwa(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean mayUsePwa = false;
        boolean $i$f$measureNanoTime = false;
        boolean bl = false;
        long start$iv = System.nanoTime();
        boolean bl2 = false;
        mayUsePwa = INSTANCE.mayEnablePwa(project2);
        long time = System.nanoTime() - start$iv;
        logger.info("PWA may be used: " + mayUsePwa + ", estimate time: " + Duration.ofNanos(time));
        return mayUsePwa;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean mayEnablePwa(Project project2) {
        void fileToAnalyseCount;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex index = projectFileIndex;
        Runtime runtime = Runtime.getRuntime();
        if (runtime.maxMemory() < (long)2000) {
            return false;
        }
        if (runtime.availableProcessors() < 4) {
            return false;
        }
        List list = PwaSupportProvider.Companion.getEP().extensions().map(new Function(project2){
            final /* synthetic */ Project $project;

            public final PwaFileFilter apply(PwaSupportProvider it) {
                return it.createFilter(this.$project);
            }
            {
                this.$project = project2;
            }
        }).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"PwaSupportProvider.EP.ex\u2026lect(Collectors.toList())");
        List filters2 = list;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable(index, filters2, (Ref.IntRef)fileToAnalyseCount){
            final /* synthetic */ ProjectFileIndex $index$inlined;
            final /* synthetic */ List $filters$inlined;
            final /* synthetic */ Ref.IntRef $fileToAnalyseCount$inlined;
            {
                this.$index$inlined = projectFileIndex;
                this.$filters$inlined = list;
                this.$fileToAnalyseCount$inlined = intRef;
            }

            public final T compute() {
                boolean bl = false;
                return (T)Boolean.valueOf(this.$index$inlined.iterateContent(new ContentIterator(this){
                    final /* synthetic */ mayEnablePwa$$inlined$runReadAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final boolean processFile(@NotNull VirtualFile it) {
                        boolean bl;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Iterable $this$any$iv = this.this$0.$filters$inlined;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    PwaFileFilter filter = (PwaFileFilter)element$iv;
                                    boolean bl2 = false;
                                    if (!filter.fastShouldAnalyse(it)) continue;
                                    bl = true;
                                    break block4;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            int n = this.this$0.$fileToAnalyseCount$inlined.element;
                            this.this$0.$fileToAnalyseCount$inlined.element = n + 1;
                        }
                        return this.this$0.$fileToAnalyseCount$inlined.element < 3000;
                    }
                }));
            }
        });
    }

    private PwaAvailabilityEstimator() {
    }

    static {
        PwaAvailabilityEstimator pwaAvailabilityEstimator;
        INSTANCE = pwaAvailabilityEstimator = new PwaAvailabilityEstimator();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PwaAvailabilityEstimator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        PwaAvailabilityEstimator.logger = logger;
    }
}

