/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions.debug;

import com.intellij.analysis.pwa.PwaInternalSettings;
import com.intellij.analysis.pwa.view.toolwindow.PwaProblemsToolWindowFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaToolWindowAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createTabComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "getTabName", "", "isEnabled", "", "update", "intellij.pwa.core"})
public abstract class PwaToolWindowAction
extends AnAction {
    @NotNull
    public abstract JComponent createTabComponent(@NotNull Project var1, @NotNull Document var2, @NotNull PsiFile var3);

    @NotNull
    public abstract String getTabName(@NotNull PsiFile var1);

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(this.isEnabled(e));
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"e.getData(CommonDataKeys.PSI_FILE) ?: return");
        PsiFile file = psiFile;
        Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
        if (document == null) {
            return;
        }
        ToolWindow toolWindow = PwaProblemsToolWindowFactory.Companion.findToolWindow(project3);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        JComponent component = this.createTabComponent(project3, document, file);
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, this.getTabName(file), true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"ContentFactory.SERVICE.g\u2026, getTabName(file), true)");
        Content content2 = content;
        content2.setCloseable(true);
        contentManager2.addContent(content2);
        contentManager2.setSelectedContent(content2);
        toolWindow.show();
    }

    private final boolean isEnabled(AnActionEvent e) {
        if (e.getProject() == null) {
            return false;
        }
        if (!PwaInternalSettings.INSTANCE.debugToolsEnabled()) {
            return false;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"e.getData(CommonDataKeys.PSI_FILE) ?: return false");
        PsiFile file = psiFile;
        return FileDocumentManager.getInstance().getDocument(file.getVirtualFile()) != null;
    }
}

