/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions.debug;

import com.intellij.analysis.pwa.analyser.PwaService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaFindDependantFilesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "nameHash", "", "(Lcom/intellij/openapi/project/Project;I)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.pwa.core"})
public final class PwaFindDependantFilesAction
extends AnAction {
    private final Project project;
    private final int nameHash;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setText("Find files using this dependency");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Set dependantFiles = (Set)PwaService.Companion.getInstance(this.project).findDependantFiles(this.nameHash).blockingGet(5, TimeUnit.SECONDS);
        if (dependantFiles == null) {
            return;
        }
        JBList fileList = new JBList((ListModel)new CollectionListModel(CollectionsKt.toMutableList((Collection)dependantFiles)));
        JBScrollPane pane = new JBScrollPane((Component)fileList);
        fileList.setCellRenderer((ListCellRenderer)new FileListRenderer());
        ComponentsKt.dialog$default((String)"Dependant files", (JComponent)((JComponent)pane), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)2044, null).show();
    }

    public PwaFindDependantFilesAction(@NotNull Project project2, int nameHash) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.nameHash = nameHash;
    }
}

