/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions.debug;

import com.intellij.analysis.pwa.actions.debug.AnalyseFileAndConvertProblems;
import com.intellij.analysis.pwa.actions.debug.PwaCheckErrorsConsistencyAction;
import com.intellij.analysis.pwa.analyser.FileIdSet;
import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.analyser.PwaFileWithProblems;
import com.intellij.analysis.pwa.analyser.PwaProblem;
import com.intellij.analysis.pwa.analyser.PwaProblemsProvider;
import com.intellij.analysis.pwa.analyser.core.PwaProjectScanner;
import com.intellij.analysis.pwa.analyser.core.PwaProviderInfo;
import com.intellij.analysis.pwa.support.PwaFileFilter;
import com.intellij.analysis.pwa.support.PwaFileFilterKt;
import com.intellij.analysis.pwa.support.PwaSupportProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.readOnlyHandler.FileListRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.pwa.core"})
public final class PwaCheckErrorsConsistencyAction
extends AnAction {
    private static final int CHUNK_SIZE = 100;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        PwaErrorStorage storage = PwaErrorStorage.Companion.getInstance(project3);
        Map<VirtualFile, Set<PwaProblem>> storageFileToProblems = storage.getStorageCopy();
        String string = "Checking file problems consistency";
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project3, (String)title$iv, cancellable$iv, project3, (String)title$iv, cancellable$iv, project3, storageFileToProblems){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Map $storageFileToProblems$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$project$inlined = project2;
                this.$storageFileToProblems$inlined = map;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                indicator2.setText("Scanning files");
                List<VirtualFile> diffFiles = PwaCheckErrorsConsistencyAction.Companion.findErrorInconsistency(this.$project$inlined, indicator2, this.$storageFileToProblems$inlined);
                JBList fileList = new JBList((ListModel)new CollectionListModel(CollectionsKt.toMutableList((Collection)diffFiles)));
                JBScrollPane pane = new JBScrollPane((Component)fileList);
                fileList.setCellRenderer((ListCellRenderer)new FileListRenderer());
                ModalityState modalityState$iv = null;
                boolean $i$f$invokeLater = false;
                Application application = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(pane){
                    final /* synthetic */ JBScrollPane $pane$inlined;
                    {
                        this.$pane$inlined = jBScrollPane;
                    }

                    public final void run() {
                        boolean bl = false;
                        ComponentsKt.dialog$default((String)"Inconsistent files", (JComponent)((JComponent)this.$pane$inlined), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)2044, null).show();
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application.invokeLater(runnable, modalityState);
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002JB\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00170\u00162\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00170\u0016H\u0002J6\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00170\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/analysis/pwa/actions/debug/PwaCheckErrorsConsistencyAction$Companion;", "", "()V", "CHUNK_SIZE", "", "analyseFromScratch", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lcom/intellij/analysis/pwa/analyser/PwaProblem;", "Lkotlin/collections/HashMap;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "projectFiles", "Lcom/intellij/analysis/pwa/analyser/FileIdSet;", "providers", "", "Lcom/intellij/analysis/pwa/analyser/core/PwaProviderInfo;", "findDiff", "storageFileToProblems", "", "", "actualFileToProblems", "findErrorInconsistency", "intellij.pwa.core"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VirtualFile> findErrorInconsistency(@NotNull Project project2, @NotNull ProgressIndicator indicator, @NotNull Map<VirtualFile, ? extends Set<PwaProblem>> storageFileToProblems) {
            Collection<PwaFileFilter> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter(storageFileToProblems, (String)"storageFileToProblems");
            List<PwaProviderInfo> list = PwaSupportProvider.Companion.getEP().extensions().map(new Function(project2){
                final /* synthetic */ Project $project;

                public final PwaProviderInfo apply(PwaSupportProvider it) {
                    return new PwaProviderInfo(it.createFilter(this.$project), it.createStateExtractor(this.$project), it.getId(), it.getVersion());
                }
                {
                    this.$project = project2;
                }
            }).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"PwaSupportProvider.EP.ex\u2026lect(Collectors.toList())");
            List<PwaProviderInfo> providers2 = list;
            Iterable iterable = providers2;
            boolean bl = false;
            Project project3 = project2;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PwaProviderInfo pwaProviderInfo = (PwaProviderInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                PwaFileFilter pwaFileFilter = it.getFilter();
                collection.add(pwaFileFilter);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            boolean bl3 = bl;
            Project project4 = project3;
            PwaProjectScanner scanner = new PwaProjectScanner(project4, bl3, list2);
            FileIdSet projectFiles = new FileIdSet(scanner.findFilesForAnalysis().getFilesForAnalysis());
            HashMap<VirtualFile, Set<PwaProblem>> actualFileToProblems = this.analyseFromScratch(indicator, project2, projectFiles, providers2);
            return this.findDiff(storageFileToProblems, (Map<VirtualFile, ? extends Set<PwaProblem>>)actualFileToProblems);
        }

        private final HashMap<VirtualFile, Set<PwaProblem>> analyseFromScratch(ProgressIndicator indicator, Project project2, FileIdSet projectFiles, List<PwaProviderInfo> providers2) {
            indicator.setText("Analysing files from scratch");
            ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.getAppExecutorService()");
            ExecutorService executorService2 = executorService;
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"PsiManager.getInstance(project)");
            PsiManager psiManager2 = psiManager;
            HashMap<VirtualFile, Set<PwaProblem>> actualFileToProblems = new HashMap<VirtualFile, Set<PwaProblem>>();
            PwaProblemsProvider problemsProvider = new PwaProblemsProvider(project2);
            indicator.setIndeterminate(false);
            int processed = 0;
            for (List chunk : CollectionsKt.chunked((Iterable)((Iterable)projectFiles.getStorage()), (int)100)) {
                indicator.setFraction((double)processed / (double)projectFiles.getSize());
                indicator.setText2(processed + " / " + projectFiles.getSize());
                ArrayList filesWithProblemsFutures = new ArrayList(100);
                for (Integer fileId : chunk) {
                    VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                    Integer n = fileId;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"fileId");
                    VirtualFile file = virtualFileManager.findFileById(n.intValue());
                    boolean $i$f$runReadAction = false;
                    ApplicationManager.getApplication().runReadAction(new Computable(psiManager2, file, providers2, filesWithProblemsFutures, executorService2, problemsProvider){
                        final /* synthetic */ PsiManager $psiManager$inlined;
                        final /* synthetic */ VirtualFile $file$inlined;
                        final /* synthetic */ List $providers$inlined;
                        final /* synthetic */ ArrayList $filesWithProblemsFutures$inlined;
                        final /* synthetic */ ExecutorService $executorService$inlined;
                        final /* synthetic */ PwaProblemsProvider $problemsProvider$inlined;
                        {
                            this.$psiManager$inlined = psiManager;
                            this.$file$inlined = virtualFile;
                            this.$providers$inlined = list;
                            this.$filesWithProblemsFutures$inlined = arrayList;
                            this.$executorService$inlined = executorService;
                            this.$problemsProvider$inlined = pwaProblemsProvider;
                        }

                        public final T compute() {
                            boolean bl = false;
                            PsiFile psiFile = this.$psiManager$inlined.findFile(this.$file$inlined);
                            if (psiFile == null) {
                            } else {
                                boolean bl2;
                                PsiFile psiFile2;
                                block6: {
                                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"psiManager.findFile(file) ?: return@runReadAction");
                                    psiFile2 = psiFile;
                                    Iterable $this$any$iv = this.$providers$inlined;
                                    boolean $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            PwaProviderInfo it = (PwaProviderInfo)element$iv;
                                            boolean bl3 = false;
                                            PwaFileFilter pwaFileFilter = it.getFilter();
                                            VirtualFile virtualFile = this.$file$inlined;
                                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                                            if (!PwaFileFilterKt.shouldAnalyseWithFastCheck(pwaFileFilter, virtualFile, psiFile2)) continue;
                                            bl2 = true;
                                            break block6;
                                        }
                                        bl2 = false;
                                    }
                                }
                                if (bl2) {
                                    VirtualFile virtualFile = this.$file$inlined;
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
                                    this.$filesWithProblemsFutures$inlined.add(this.$executorService$inlined.submit(new AnalyseFileAndConvertProblems(virtualFile, psiFile2, this.$providers$inlined, this.$problemsProvider$inlined)));
                                }
                            }
                            return (T)Unit.INSTANCE;
                        }
                    });
                }
                for (Future fileWithProblemsFuture : filesWithProblemsFutures) {
                    PwaFileWithProblems fileWithProblems;
                    if ((PwaFileWithProblems)fileWithProblemsFuture.get() == null) {
                        continue;
                    }
                    Collection collection = fileWithProblems.getProblems();
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        actualFileToProblems.computeIfAbsent(fileWithProblems.getFile(), analyseFromScratch.2.INSTANCE).addAll((Collection<PwaProblem>)fileWithProblems.getProblems());
                    }
                    ++processed;
                }
            }
            return actualFileToProblems;
        }

        private final List<VirtualFile> findDiff(Map<VirtualFile, ? extends Set<PwaProblem>> storageFileToProblems, Map<VirtualFile, ? extends Set<PwaProblem>> actualFileToProblems) {
            ArrayList<VirtualFile> diffFiles = new ArrayList<VirtualFile>();
            Map<VirtualFile, ? extends Set<PwaProblem>> map = storageFileToProblems;
            boolean bl = false;
            for (Map.Entry<VirtualFile, ? extends Set<PwaProblem>> storageFileToProblem : map.entrySet()) {
                VirtualFile file = storageFileToProblem.getKey();
                Set<PwaProblem> actualProblems = actualFileToProblems.get(file);
                if (actualProblems == null) {
                    diffFiles.add(file);
                    continue;
                }
                if (!(Intrinsics.areEqual(storageFileToProblem.getValue(), actualProblems) ^ true)) continue;
                diffFiles.add(file);
            }
            return diffFiles;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

