/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.pwa.actions;

import com.intellij.analysis.pwa.analyser.PwaErrorStorage;
import com.intellij.analysis.pwa.settings.PwaSettings;
import com.intellij.analysis.pwa.utils.PwaBundle;
import com.intellij.analysis.pwa.view.PwaTooltipService;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/analysis/pwa/actions/PwaToggleAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "()V", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getButtonBackgroundColor", "Lcom/intellij/ui/JBColor;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "PwaActionButton", "intellij.pwa.core"})
public final class PwaToggleAction
extends ToggleAction
implements CustomComponentAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(!PowerSaveMode.isEnabled());
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        Object object = e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (!(object instanceof PwaActionButton)) {
            object = null;
        }
        PwaActionButton component = (PwaActionButton)((Object)object);
        Project $this$service$iv = project3;
        boolean $i$f$service = false;
        Object object2 = $this$service$iv.getService(PwaSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        PwaSettings settings = (PwaSettings)((Object)object2);
        boolean enabled = settings.isEnabled();
        if (component != null) {
            component.setProject(project3);
            component.setBackground(enabled ? (Color)this.getButtonBackgroundColor() : null);
        }
        String text = enabled ? PwaBundle.Companion.message("action.disable.project.wide.analysis.text", new Object[0]) : PwaBundle.Companion.message("action.enable.project.wide.analysis.text", new Object[0]);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setText(text);
        Icon icon = enabled ? AllIcons.Toolwindows.ProjectWideAnalysisOn : AllIcons.Toolwindows.ProjectWideAnalysisOff;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"if (enabled) {\n      All\u2026jectWideAnalysisOff\n    }");
        Icon icon2 = icon;
        Presentation presentation3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
        presentation3.setIcon(icon2);
    }

    private final JBColor getButtonBackgroundColor() {
        JBColor jBColor = JBColor.namedColor((String)"ProblemsView.projectAnalysisButtonBackground", (int)861513833, (int)860462164);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"JBColor.namedColor(\"Prob\u2026, 0x3359A869, 0x33499C54)");
        return jBColor;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project3 = e.getProject();
        if (project3 == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"e.project ?: return false");
        Project $this$service$iv = project2 = project3;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(PwaSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        PwaSettings settings = (PwaSettings)((Object)object);
        return settings.isEnabled();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project3 = e.getProject();
        if (project3 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"e.project ?: return");
        Project $this$service$iv = project2 = project3;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(PwaSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        PwaSettings settings = (PwaSettings)((Object)object);
        settings.setEnabled(project2, state);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PwaActionButton button = new PwaActionButton((AnAction)this, presentation, place);
        button.setProject(project2);
        return (JComponent)((Object)button);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/analysis/pwa/actions/PwaToggleAction$PwaActionButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/lang/String;)V", "value", "Lcom/intellij/openapi/project/Project;", "project", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "(Lcom/intellij/openapi/project/Project;)V", "intellij.pwa.core"})
    private static final class PwaActionButton
    extends ActionButton {
        @Nullable
        private Project project;

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        public final void setProject(@Nullable Project value) {
            if (Intrinsics.areEqual((Object)this.project, (Object)value)) {
                return;
            }
            this.project = value;
            if (value != null) {
                Disposer.register((Disposable)PwaErrorStorage.Companion.getInstance(value), (Disposable)new Disposable(this){
                    final /* synthetic */ PwaActionButton this$0;

                    public final void dispose() {
                        PwaActionButton.access$setProject$lp(this.this$0, null);
                    }
                    {
                        this.this$0 = pwaActionButton;
                    }
                });
            }
        }

        public PwaActionButton(@NotNull AnAction action, @Nullable Presentation presentation, @Nullable String place) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            super(action, presentation, place, (Dimension)new JBDimension(24, 26));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project prj = this.getProject();
                    if (e.getButton() == 1 && prj != null) {
                        Project $this$service$iv = prj;
                        boolean $i$f$service = false;
                        Object object = $this$service$iv.getService(PwaTooltipService.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                        PwaTooltipService tooltipService = (PwaTooltipService)object;
                        Component component = e.getComponent();
                        if (component == null) {
                            throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
                        }
                        tooltipService.showTooltip((JComponent)component);
                    }
                }
            });
        }

        public static final /* synthetic */ Project access$getProject$lp(PwaActionButton $this) {
            return $this.project;
        }

        public static final /* synthetic */ void access$setProject$lp(PwaActionButton $this, Project project2) {
            $this.project = project2;
        }
    }
}

