/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.nodes;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.DefaultUserResponse;
import com.intellij.jam.view.JamDeleteProvider;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistenceNodeDescriptor<P extends CommonModelElement>
extends JamNodeDescriptor<P> {
    protected PersistenceNodeDescriptor(P element, NodeDescriptor parentDescriptor, Object parameters) {
        super(parentDescriptor.getProject(), parentDescriptor, parameters, element);
    }

    protected PersistenceNodeDescriptor(P element, Project project, Object parameters) {
        super(project, null, parameters, element);
    }

    public DeleteProvider getDeleteProvider() {
        DefaultUserResponse response = new DefaultUserResponse(this.myProject);
        return new JamDeleteProvider((CommonModelElement)this.getJamElement(), (JamUserResponse)response);
    }

    public P updateElement() {
        CommonModelElement element = (CommonModelElement)this.getJamElement();
        if (!element.isValid()) {
            return null;
        }
        return (P)((CommonModelElement)this.getJamElement());
    }

    public String getNewTooltip() {
        return null;
    }

    @Nullable
    @NlsSafe
    public String getNewNodeText() {
        return null;
    }

    public boolean isValid() {
        return ((CommonModelElement)this.getJamElement()).isValid();
    }

    protected void doUpdate() {
        super.doUpdate();
        String textExt = this.getNewNodeTextExt();
        if (textExt != null) {
            this.addColoredFragment(" (" + textExt + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getNewNodeTextExt() {
        return null;
    }

    public Object getData(@NotNull String dataId) {
        Navigatable navigatable;
        if (dataId == null) {
            PersistenceNodeDescriptor.$$$reportNull$$$0(0);
        }
        if (PersistenceDataKeys.MODEL_ELEMENT_CONTEXT.is(dataId)) {
            return this.getJamElement();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && (navigatable = this.getNavigatable()) != null) {
            return navigatable;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            CommonModelElement element = (CommonModelElement)this.getJamElement();
            return element.isValid() ? element.getIdentifyingPsiElement() : null;
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            return this.getParentElementOfType(Module.class);
        }
        return super.getData(dataId);
    }

    @Nullable
    public <T> T getParentElementOfType(Class<T> elementClass) {
        for (PersistenceNodeDescriptor cur = this; cur != null; cur = cur.getParentDescriptor()) {
            Object element;
            Object object = element = cur instanceof JamNodeDescriptor ? ((JamNodeDescriptor)cur).getJamElement() : cur.getElement();
            if (element == null || !ReflectionUtil.isAssignable(elementClass, element.getClass())) continue;
            return (T)element;
        }
        return null;
    }

    @Nullable
    protected Navigatable getNavigatable() {
        PsiElement[] psiElements = JamCommonUtil.getTargetPsiElements((CommonModelElement)((CommonModelElement)this.getJamElement()));
        if (psiElements.length == 0) {
            return null;
        }
        PsiElement element = psiElements[0];
        if (element instanceof Navigatable) {
            return (Navigatable)element;
        }
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return PsiNavigationSupport.getInstance().createNavigatable(element.getProject(), vFile, element.getTextOffset());
    }

    public boolean expandOnDoubleClick() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/jpa/view/nodes/PersistenceNodeDescriptor", "getData"));
    }
}

