/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistencePackageAsVirtualFileImpl<F extends Facet<?>>
extends FrameworkElementAsVirtualFileImpl<F>
implements PersistencePackagePointer {
    @NonNls
    public static final String PERSISTENCE_UNIT_TYPE = "PersistenceModel";
    @NonNls
    private static final String ANONYMOUS_PREFIX = "noname-";

    PersistencePackageAsVirtualFileImpl(FacetPointer<F> facetPointer, String elementName) {
        super(facetPointer, PERSISTENCE_UNIT_TYPE, elementName);
    }

    @Nullable
    public PersistencePackage findElement() {
        PersistenceFacet facet = this.getPersistenceFacet();
        if (facet != null) {
            String elementName = this.getElementName();
            List units = facet.getPersistenceUnits();
            for (PersistencePackage unit : units) {
                if (!Objects.equals(PersistencePackageAsVirtualFileImpl.getElementName(unit), elementName)) continue;
                return unit;
            }
        }
        return null;
    }

    public PersistenceFacet getPersistenceFacet() {
        return (PersistenceFacet)this.getFacetPointer().getFacet();
    }

    @NotNull
    public String getPresentableName() {
        String string = JpaMessages.message((String)"persistence.unit.type", (Object[])new Object[0]) + " '" + this.getElementName() + "'";
        if (string == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Icon getIcon() {
        PersistencePackage unit = this.findElement();
        Icon icon = unit == null ? null : ElementPresentationManager.getIcon((Object)unit);
        return icon == null ? JavaeeIcons.PERSISTENCE_UNIT_ICON : icon;
    }

    @Nullable
    public static PersistencePackageAsVirtualFileImpl findFile(PersistencePackage unit, PersistenceFacet facet) {
        String path = PersistencePackageAsVirtualFileImpl.getPath(unit, facet);
        FrameworkVirtualFileSystem instance = FrameworkVirtualFileSystem.getJ2EEInstance();
        FrameworkElementAsVirtualFileImpl file = (FrameworkElementAsVirtualFileImpl)instance.findFileByPath(path);
        return (PersistencePackageAsVirtualFileImpl)file;
    }

    public static String getPath(PersistencePackage unit, PersistenceFacet facet) {
        String name = PersistencePackageAsVirtualFileImpl.getElementName(unit);
        return FrameworkVirtualFileSystem.getPath((Project)facet.getModule().getProject(), (String)FacetPointersManager.constructId((Facet)((Facet)facet)), (String)PERSISTENCE_UNIT_TYPE, (String)name);
    }

    @NotNull
    public static String getElementName(@NotNull PersistencePackage unit) {
        if (unit == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(1);
        }
        Object unitName = (String)unit.getName().getValue();
        XmlTag tag = unit.getXmlTag();
        PsiFile containingFile = unit.getContainingFile();
        if (StringUtil.isEmpty((String)unitName) && tag != null && containingFile != null) {
            unitName = ANONYMOUS_PREFIX + containingFile.getName() + "@" + tag.getTextOffset();
        }
        String string = StringUtil.notNullize((String)unitName);
        if (string == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/view/editor/PersistencePackageAsVirtualFileImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/view/editor/PersistencePackageAsVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

