/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view;

import com.intellij.facet.Facet;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.jam.view.tree.JamTreeStructure;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.ui.FrameworkToolWindowViewBase;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.nodes.PersistenceFacetNodeDescriptor;
import com.intellij.jpa.view.nodes.PersistenceUnitNodeDescriptor;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeUtil;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class JpaView
extends FrameworkToolWindowViewBase
implements Disposable {
    static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Jpa View", (String)"JpaView");

    public JpaView(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            JpaView.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            JpaView.$$$reportNull$$$0(1);
        }
        super(project, new FrameworkToolWindowViewBase.FrameworkViewTreeStructureProvider(){

            public SimpleTreeStructure createTreeStructure(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new JamTreeStructure((SimpleNode)new JpaProjectJamNodeDescriptor(project), project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/view/JpaView$1", "createTreeStructure"));
            }
        }, parentDisposable);
        this.initComponents();
        PopupHandler.installPopupMenu((JComponent)this.myTree, (String)"JpaViewPopupMenu", (String)"J2EEViewPopup");
        ProjectWideFacetListenersRegistry.getInstance((Project)this.myProject).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(0);
                }
                JpaView.this.updateTree();
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(1);
                }
                JpaView.this.updateTree();
            }

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    2.$$$reportNull$$$0(2);
                }
                JpaView.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "com/intellij/jpa/view/JpaView$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parentDisposable);
    }

    protected void addTitleActions(List<AnAction> actions) {
        final AnAction baseAction = ActionManager.getInstance().getAction("Jpa.OpenConsole");
        AnAction consoleTitleAction = new AnAction(){
            {
                ActionUtil.copyFrom((AnAction)this, (String)"Jpa.OpenConsole");
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                Project project = e.getProject();
                boolean isEnabled = !JpaView.this.myTree.isSelectionEmpty() || project != null && PersistenceCommonUtil.getAllPersistenceFacets((Project)project).stream().anyMatch(it -> !it.getPersistenceUnits().isEmpty());
                e.getPresentation().setEnabledAndVisible(isEnabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Object[] paths;
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (!ArrayUtil.isEmpty((Object[])(paths = JpaView.this.myTree.getSelectionPaths()))) {
                    this.openConsolesForSelectedTreePaths((TreePath[])paths, e);
                } else {
                    this.tryOpenConsoleWithAnyUnit(JpaView.this.myProject, e);
                }
            }

            private void openConsolesForSelectedTreePaths(TreePath[] paths, @NotNull AnActionEvent originalEvent) {
                JBIterable iterable;
                if (originalEvent == null) {
                    3.$$$reportNull$$$0(2);
                }
                if ((iterable = JBIterable.of((Object[])paths).map(path -> {
                    PersistenceFacetNodeDescriptor facetND = (PersistenceFacetNodeDescriptor)((Object)((Object)TreeUtil.findObjectInPath((TreePath)path, PersistenceFacetNodeDescriptor.class)));
                    PersistenceUnitNodeDescriptor unitND = (PersistenceUnitNodeDescriptor)((Object)((Object)TreeUtil.findObjectInPath((TreePath)path, PersistenceUnitNodeDescriptor.class)));
                    PersistenceFacet facet = facetND == null ? null : (PersistenceFacet)facetND.getJamElement();
                    PersistencePackage unit = unitND == null ? null : (PersistencePackage)unitND.getJamElement();
                    return facet == null || unit == null ? null : Pair.create((Object)facet, (Object)unit);
                }).filter(Conditions.notNull()).unique()).isEmpty()) {
                    this.tryOpenConsoleWithAnyUnit(JpaView.this.myProject, originalEvent);
                    return;
                }
                iterable.forEach(pair -> baseAction.actionPerformed(JpaUtil.createEventWithContext(originalEvent, (PersistenceFacet)pair.first, (PersistencePackage)pair.second)));
            }

            private void tryOpenConsoleWithAnyUnit(@NotNull Project project, AnActionEvent originalEvent) {
                List facets;
                Optional<PersistenceFacet> anyNonEmptyFacet;
                if (project == null) {
                    3.$$$reportNull$$$0(3);
                }
                if ((anyNonEmptyFacet = (facets = PersistenceCommonUtil.getAllPersistenceFacets((Project)project)).stream().filter(it -> !it.getPersistenceUnits().isEmpty()).findFirst()).isEmpty()) {
                    this.showHint(JpaHighlightingMessages.message("hint.failed.to.open.console.no.facet.or.unit.found", new Object[0]));
                } else {
                    PersistenceFacet facet = anyNonEmptyFacet.get();
                    PersistencePackage persistencePackage = (PersistencePackage)facet.getPersistenceUnits().get(0);
                    baseAction.actionPerformed(JpaUtil.createEventWithContext(originalEvent, facet, persistencePackage));
                    this.showHint(JpaHighlightingMessages.message("hint.open.console.with.0.unit.and.1.facet", persistencePackage.getName().getValue(), facet.getModule().getName()));
                }
            }

            private void showHint(@Nls String message) {
                NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).setImportant(false).notify(JpaView.this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "originalEvent";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jpa/view/JpaView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "openConsolesForSelectedTreePaths";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "tryOpenConsoleWithAnyUnit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        consoleTitleAction.getTemplatePresentation().setIcon(DatabaseIcons.ConsoleRun);
        actions.add(consoleTitleAction);
        super.addTitleActions(actions);
    }

    public Object getData(@NotNull String dataId) {
        DeleteProvider provider;
        Object data;
        if (dataId == null) {
            JpaView.$$$reportNull$$$0(2);
        }
        if ((data = super.getData(dataId)) != null) {
            return data;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.persistence.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (provider = JamCommonUtil.createDeleteProvider((Set)JpaView.getSelectedElements((JTree)this.myTree, JamNodeDescriptor.class))) != null) {
            return provider;
        }
        Set set = JpaView.getSelectedElements((JTree)this.myTree);
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) || CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            boolean isPsi = LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId);
            DataKey singleKey = isPsi ? CommonDataKeys.PSI_ELEMENT : CommonDataKeys.NAVIGATABLE;
            SmartList result = new SmartList();
            for (Object node : set) {
                if (!(node instanceof JamNodeDescriptor) || !((JamNodeDescriptor)node).isValid()) continue;
                Object val = ((JamNodeDescriptor)node).getDataForElement(singleKey.getName());
                ContainerUtil.addIfNotNull((Collection)result, (Object)val);
            }
            if (result.isEmpty()) {
                return null;
            }
            return result.toArray(isPsi ? new PsiElement[result.size()] : new Navigatable[result.size()]);
        }
        Object firstNode = ContainerUtil.getFirstItem((Collection)set);
        if (firstNode instanceof JamNodeDescriptor && ((JamNodeDescriptor)firstNode).isValid()) {
            return ((JamNodeDescriptor)firstNode).getDataForElement(dataId);
        }
        return null;
    }

    public void dispose() {
        this.removeAll();
    }

    public static void select(@NotNull Project project, boolean requestFocus, Object ... pathSteps) {
        if (project == null) {
            JpaView.$$$reportNull$$$0(3);
        }
        JpaView.select((String)"Persistence", (Project)project, (boolean)requestFocus, (Object[])pathSteps);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/view/JpaView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class JpaProjectJamNodeDescriptor
    extends JamNodeDescriptor<Project> {
        private final Project myProject;

        private JpaProjectJamNodeDescriptor(@NotNull Project project) {
            if (project == null) {
                JpaProjectJamNodeDescriptor.$$$reportNull$$$0(0);
            }
            super(project, null, (Object)new J2EEModuleParameters(true), (Object)project);
            this.myProject = project;
        }

        public JamNodeDescriptor<?> @NotNull [] getChildren() {
            JpaProjectJamNodeDescriptor parentDescriptor = this;
            JamTreeParameters parameters = (JamTreeParameters)this.getParameters();
            JamNodeDescriptor[] jamNodeDescriptorArray = (JamNodeDescriptor[])ContainerUtil.map2Array((Collection)PersistenceCommonUtil.getAllPersistenceFacets((Project)this.myProject), JamNodeDescriptor.class, facet -> new PersistenceFacetNodeDescriptor((PersistenceFacet)facet, (NodeDescriptor)parentDescriptor, parameters));
            if (jamNodeDescriptorArray == null) {
                JpaProjectJamNodeDescriptor.$$$reportNull$$$0(1);
            }
            return jamNodeDescriptorArray;
        }

        protected String getNewNodeText() {
            return this.myProject.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/view/JpaView$JpaProjectJamNodeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/view/JpaView$JpaProjectJamNodeDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

