/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OrmCompletionUtil {
    public static boolean needSpecialSymbolsEscaping(PsiElement psiElement) {
        return psiElement.getLanguage().getID().equals("kotlin");
    }

    public static Collection<LookupElement> escapeIfNeeded(Collection<LookupElement> lookupElements, boolean needEscape) {
        if (!needEscape) {
            return lookupElements;
        }
        return ContainerUtil.map(lookupElements, it -> OrmCompletionUtil.substituteSpecialSymbols(it));
    }

    private static LookupElement substituteSpecialSymbols(LookupElement baseElement) {
        if (!(baseElement instanceof LookupElementBuilder)) {
            return baseElement;
        }
        return ((LookupElementBuilder)baseElement).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)OrmCompletionUtil.escapeSpecialSymbols(item.getLookupString()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/util/OrmCompletionUtil$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static String escapeSpecialSymbols(String value) {
        return StringUtil.escapeChar((String)value, (char)'$');
    }
}

