/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.util;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.inspections.JpaMissingIdInspection;
import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.CreateMethodRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.CreateBeanPropertyRequest;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

public class JpaCodeGenerationUtil {
    public static void createAnnotatedProperty(String name, PsiType type, boolean fieldAccess, boolean generated, UClass uClass, Project project, Editor editor) {
        PsiFile containingFile = uClass.getJavaPsi().getContainingFile();
        JvmElementActionFactories.createMethodActions((JvmClass)uClass.getJavaPsi(), (CreateMethodRequest)new CreateBeanPropertyRequest(project, name, PropertyKind.SETTER, type)).stream().filter(it -> it.getText().contains("property")).findFirst().ifPresent(action -> JpaCodeGenerationUtil.invokeAction(action, project, editor, containingFile));
        Object[] members = fieldAccess ? uClass.getFields() : uClass.getMethods();
        Optional declaration = ((StreamEx)StreamEx.of((Object[])members).filter(element -> {
            PsiMember javaPsi = (PsiMember)element.getJavaPsi();
            return javaPsi != null && JpaCodeGenerationUtil.createMemberName(fieldAccess, name).equals(javaPsi.getName());
        })).findFirst();
        if (declaration.isEmpty()) {
            Logger.getInstance(JpaMissingIdInspection.class).warn("Unable to add annotations for generated declaration because declaring PsiMember was not found");
            return;
        }
        PsiMember psiElement = (PsiMember)UElementKt.getAsJavaPsiElement((UElement)((UElement)declaration.get()), PsiMember.class);
        if (psiElement == null) {
            return;
        }
        if (generated) {
            JpaCodeGenerationUtil.annotateMember(psiElement, project, editor, containingFile, JpaAnnotationConstants.GENERATED_VALUE_ANNO.fqn((PsiElement)psiElement));
        }
        JpaCodeGenerationUtil.annotateMember(psiElement, project, editor, containingFile, JpaAnnotationConstants.ID_ANNO.fqn((PsiElement)psiElement));
    }

    public static void annotateMember(PsiMember psiMember, Project project, Editor editor, PsiFile containingFile, String annotationFqn) {
        JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((PsiJvmMember)psiMember), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)annotationFqn, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0])).stream().findFirst().ifPresent(action -> JpaCodeGenerationUtil.invokeAction(action, project, editor, containingFile));
    }

    private static void invokeAction(IntentionAction action, Project project, Editor editor, PsiFile file) {
        WriteCommandAction.runWriteCommandAction((Project)project, (String)JpaHighlightingMessages.message("quick.fix.name.add.id.attribute", new Object[0]), null, () -> {
            Editor actualEditor;
            action.invoke(project, editor, file);
            Editor editor2 = actualEditor = editor != null ? editor : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (actualEditor == null) {
                return;
            }
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)actualEditor);
            if (templateState != null) {
                templateState.gotoEnd(false);
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private static String createMemberName(boolean isField, String propertyName) {
        if (isField) {
            return propertyName;
        }
        return PropertyUtilBase.getAccessorName((String)propertyName, (PropertyKind)PropertyKind.GETTER);
    }
}

