/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.psi.impl;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.model.ScopeQlModel;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlArrayItemExpression;
import com.intellij.jpa.ql.psi.QlClause;
import com.intellij.jpa.ql.psi.QlCompositeElement;
import com.intellij.jpa.ql.psi.QlConstructorExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlGroupByClause;
import com.intellij.jpa.ql.psi.QlHqlWithClause;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlInVariableExpression;
import com.intellij.jpa.ql.psi.QlJoinExpression;
import com.intellij.jpa.ql.psi.QlKeyValueExpression;
import com.intellij.jpa.ql.psi.QlOrderByClause;
import com.intellij.jpa.ql.psi.QlPsiElementFactory;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.QlTableExpression;
import com.intellij.jpa.ql.psi.QlTreatExpression;
import com.intellij.jpa.ql.psi.impl.QlCompositeElementImpl;
import com.intellij.jpa.ql.psi.impl.QlPsiImplUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QlReferenceImpl
extends PsiPolyVariantReferenceBase<QlReferenceExpression> {
    private static final Logger LOG = Logger.getInstance(QlReferenceImpl.class);
    @NotNull
    private static final ResolveCache.PolyVariantResolver<PsiPolyVariantReferenceBase> MY_RESOLVER = (ref, incompleteCode) -> {
        try {
            return ((QlReferenceImpl)ref).resolveInner();
        }
        catch (StackOverflowError e) {
            LOG.error("EA-96451", (Throwable)e, new String[]{"Query:\n" + ref.getElement().getContainingFile().getText()});
            return ResolveResult.EMPTY_ARRAY;
        }
    };
    private static final Key<Boolean> SYNTHETIC_ATTR = Key.create((String)"SYNTHETIC_ATTR");
    private static final Set<String> ourFunctionsWithParens = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("key", "value", "entry", "cast", "extract", "elements", "indices", "length", "locate", "abs", "sqrt", "mod", "size", "index", "minelement", "maxelement", "minindex", "maxindex", "concat", "substring", "trim", "lower", "upper", "coalesce", "nullif", "column", "table", "function", "func", "operator", "sql"));
    private static final double ALIAS_PRIORITY = 5.0;
    private static final double ATTRIBUTE_PRIORITY = 4.0;
    private static final double SYNTHETIC_ATTRIBUTE_PRIORITY = 3.5;
    private static final double CLASS_PRIORITY = 3.0;
    private static final double KEYWORD_PRIORITY = 2.0;
    private static final double FUNCTION_PRIORITY = 1.5;
    private static final double PACKAGE_PRIORITY = 1.0;

    public QlReferenceImpl(@NotNull QlReferenceExpression element) {
        if (element == null) {
            QlReferenceImpl.$$$reportNull$$$0(0);
        }
        super((PsiElement)element, TextRange.from((int)element.getIdentifier().getStartOffsetInParent(), (int)element.getIdentifier().getTextLength()));
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            QlReferenceImpl.$$$reportNull$$$0(1);
        }
        ((QlReferenceExpression)this.myElement).getIdentifier().replace(Objects.requireNonNull(QlPsiElementFactory.createIdentifier(newElementName, ((QlReferenceExpression)this.myElement).getProject())));
        return this.myElement;
    }

    private boolean processResolveVariants(@NotNull QlModel model, @NotNull PsiScopeProcessor processor) {
        if (model == null) {
            QlReferenceImpl.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            QlReferenceImpl.$$$reportNull$$$0(3);
        }
        Project project = ((QlReferenceExpression)this.myElement).getProject();
        ResolveState state = ResolveState.initial();
        QlExpression qualifier = ((QlReferenceExpression)this.myElement).getQualifier();
        QlHqlWithClause with = (QlHqlWithClause)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, QlHqlWithClause.class);
        if (qualifier != null) {
            if (qualifier instanceof QlReferenceExpression) {
                return QlReferenceImpl.processQualifierExpression(project, (QlReferenceExpression)qualifier, processor, state, this.myElement);
            }
            if (qualifier instanceof QlArrayItemExpression) {
                QlExpression expression = ((QlArrayItemExpression)qualifier).getLeft();
                int count = 1;
                while (expression instanceof QlArrayItemExpression) {
                    expression = ((QlArrayItemExpression)expression).getLeft();
                    ++count;
                }
                if (expression instanceof QlReferenceExpression) {
                    QlElement element = QlReferenceImpl.resolveModelElement((QlReferenceExpression)expression);
                    if (!(element instanceof QlAttribute)) {
                        return true;
                    }
                    QlAttribute attribute = (QlAttribute)element;
                    PsiType psiType = attribute.getPsiType();
                    JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)psiType);
                    while (--count > 0 && typeInfo.containerType != null) {
                        typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)typeInfo.getValueType());
                    }
                    return typeInfo.containerType == null || QlReferenceImpl.processPsiTypeVariants(project, typeInfo.getValueType(), model, processor, state);
                }
                return true;
            }
            if (qualifier instanceof QlKeyValueExpression) {
                PsiType targetType;
                IElementType type = QlCompositeElementImpl.getFirstElementType(qualifier);
                QlElement element = QlReferenceImpl.resolveModelElement(((QlKeyValueExpression)qualifier).getReferenceExpression());
                if (!(element instanceof QlAttribute)) {
                    return true;
                }
                QlAttribute attribute = (QlAttribute)element;
                PsiType psiType = attribute.getPsiType();
                JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)psiType);
                if (type == QlTypes.QL_KEY) {
                    targetType = typeInfo.getKeyType();
                } else if (type == QlTypes.QL_VALUE) {
                    targetType = typeInfo.getValueType();
                } else {
                    return true;
                }
                return QlReferenceImpl.processPsiTypeVariants(project, targetType, model, processor, state);
            }
            return true;
        }
        if (model instanceof ScopeQlModel) {
            return QlReferenceImpl.processObjectAttributes(project, ((ScopeQlModel)model).getScopeEntity(), processor, state);
        }
        if (with != null) {
            QlIdentifier identifier;
            String text;
            QlExpression refExpression;
            PsiElement withParent = with.getParent();
            if (withParent instanceof QlJoinExpression && (refExpression = ((QlJoinExpression)withParent).getJoinArgument()) instanceof QlAliasDefinition && ((text = (identifier = ((QlAliasDefinition)refExpression).getIdentifier()).getText()) == null || !((QlReferenceExpression)this.myElement).getIdentifier().getText().equals(text))) {
                return true;
            }
            return this.processUnqualifiedResolve(project, processor, model, state);
        }
        return this.processUnqualifiedResolve(project, processor, model, state);
    }

    @Nullable
    public static QlElement resolveModelElement(QlReferenceExpression refExpression) {
        Object o = QlReferenceImpl.resolveQualifier(refExpression);
        return o instanceof QlElement ? (QlElement)o : null;
    }

    @Nullable
    private static Object resolveQualifier(QlReferenceExpression refExpression) {
        if (refExpression == null) {
            return null;
        }
        Object refTarget = refExpression.resolve();
        if (refTarget instanceof QlAliasDefinition) {
            QlExpression aliasedExpression = ((QlAliasDefinition)refTarget).getExpression();
            if (aliasedExpression instanceof QlReferenceExpression) {
                refTarget = ((QlReferenceExpression)aliasedExpression).resolve();
            } else if (aliasedExpression instanceof QlInVariableExpression) {
                QlReferenceExpression refExpression2 = ((QlInVariableExpression)aliasedExpression).getReferenceExpression();
                refTarget = refExpression2 == null ? null : refExpression2.resolve();
            }
        }
        return refTarget;
    }

    private static boolean processPsiTypeVariants(Project project, PsiType targetType, QlModel model, PsiScopeProcessor processor, ResolveState state) {
        for (QlEntity object : model.getEntities()) {
            PsiType type = object.getPsiType();
            if (type == null || !type.equals(targetType) || QlReferenceImpl.processObjectAttributes(project, object, processor, state)) continue;
            return false;
        }
        return true;
    }

    public static boolean processQualifierExpression(Project project, QlReferenceExpression qualifier, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        block20: {
            QlExpression aliasedExpression;
            block25: {
                String name;
                Object qualifierTarget;
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                Object object = qualifierTarget = qualifier == null ? null : qualifier.resolve();
                                if (qualifierTarget == qualifier) break block20;
                                if (!(qualifierTarget instanceof QlEntity)) break block21;
                                if (!QlReferenceImpl.processObjectAttributes(project, (QlEntity)qualifierTarget, processor, state)) {
                                    return false;
                                }
                                if (!QlReferenceImpl.processSpecialAttributes(project, (QlEntity)qualifierTarget, processor, state)) {
                                    return false;
                                }
                                PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)((QlEntity)qualifierTarget).getPsiType());
                                if (psiClass != null && !QlReferenceImpl.processPsiClassMembers(psiClass, processor, state)) {
                                    return false;
                                }
                                break block20;
                            }
                            if (!(qualifierTarget instanceof QlAttribute)) break block22;
                            QlAttribute attribute = (QlAttribute)qualifierTarget;
                            PsiElement parent = qualifier.getParent();
                            QlEntity entity = attribute.getOtherEntity();
                            boolean container = attribute.isToMany();
                            if ((!container || parent instanceof QlAliasDefinition || parent instanceof QlInVariableExpression) && !QlReferenceImpl.processObjectAttributes(project, entity, processor, state)) {
                                return false;
                            }
                            if (!QlReferenceImpl.processSpecialAttributes(project, (QlAttribute)qualifierTarget, processor, state)) {
                                return false;
                            }
                            break block20;
                        }
                        if (!(qualifierTarget instanceof PsiPackage)) break block23;
                        if (!((PsiElement)qualifierTarget).processDeclarations(processor, state, place, place)) {
                            return false;
                        }
                        break block20;
                    }
                    if (!(qualifierTarget instanceof PsiClass)) break block24;
                    PsiClass psiClass = (PsiClass)qualifierTarget;
                    if (psiClass.isEnum()) {
                        for (PsiField field : psiClass.getFields()) {
                            if (!(field instanceof PsiEnumConstant) || processor.execute((PsiElement)field, state)) continue;
                            return false;
                        }
                    } else if (!QlReferenceImpl.processPsiClassMembers(psiClass, processor, state)) {
                        return false;
                    }
                    break block20;
                }
                if (!(qualifierTarget instanceof QlAliasDefinition) || (aliasedExpression = ((QlAliasDefinition)qualifierTarget).getExpression()).equals(qualifier) || PsiTreeUtil.findCommonParent((PsiElement)aliasedExpression, (PsiElement)qualifier) instanceof QlClause && aliasedExpression.getTextOffset() >= qualifier.getTextOffset()) break block20;
                if (aliasedExpression instanceof QlReferenceExpression) {
                    return QlReferenceImpl.processQualifierExpression(project, (QlReferenceExpression)aliasedExpression, processor, state, place);
                }
                if (aliasedExpression instanceof QlInVariableExpression) {
                    return QlReferenceImpl.processQualifierExpression(project, ((QlInVariableExpression)aliasedExpression).getReferenceExpression(), processor, state, place);
                }
                if (aliasedExpression instanceof QlTreatExpression) {
                    return QlReferenceImpl.processQualifierExpression(project, ((QlTreatExpression)aliasedExpression).getReferenceExpression(), processor, state, place);
                }
                if (!(aliasedExpression instanceof QlTableExpression)) break block25;
                QlStringLiteral literal = ((QlTableExpression)aliasedExpression).getStringLiteral();
                if (literal == null) {
                    return true;
                }
                QlModel model = QlReferenceImpl.getPersistenceModel(aliasedExpression);
                if (!model.processInDbTable(name = StringUtil.unquoteString((String)literal.getText()), processor, state, place)) {
                    return false;
                }
                break block20;
            }
            if (!(aliasedExpression instanceof QlQueryExpression)) break block20;
            QlSelectClause clause = ((QlQueryExpression)aliasedExpression).getSelectClause();
            if (clause == null) {
                return true;
            }
            List<QlExpression> list = clause.getExpressionList();
            for (QlExpression expression : list) {
                if (expression instanceof QlReferenceExpression) {
                    PsiElement attributeTarget;
                    Object resolve = ((QlReferenceExpression)expression).resolve();
                    if (resolve instanceof QlAttribute && !processor.execute(attributeTarget = PomService.convertToPsi((Project)project, (PomTarget)((QlAttribute)resolve)), state)) {
                        return false;
                    }
                    if (!QlReferenceImpl.processQualifierExpression(project, (QlReferenceExpression)expression, processor, state, place)) {
                        return false;
                    }
                }
                if (processor.execute((PsiElement)expression, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processPsiClassMembers(PsiClass psiClass, PsiScopeProcessor processor, ResolveState state) {
        for (PsiClass psiClass2 : psiClass.getAllInnerClasses()) {
            if (!psiClass2.isEnum() && (!psiClass2.hasModifierProperty("public") || !psiClass2.hasModifierProperty("static")) || processor.execute((PsiElement)psiClass2, state)) continue;
            return false;
        }
        for (PsiClass psiClass3 : psiClass.getAllFields()) {
            if (!psiClass3.hasModifierProperty("public") || !psiClass3.hasModifierProperty("static") || !psiClass3.hasModifierProperty("final") || processor.execute((PsiElement)psiClass3, state)) continue;
            return false;
        }
        return true;
    }

    private static boolean processSpecialAttributes(Project project, QlElement o, PsiScopeProcessor processor, ResolveState state) {
        ResolveState newState = state.put(SYNTHETIC_ATTR, (Object)Boolean.TRUE);
        for (QlAttribute qlAttribute : o.getSpecialAttributes()) {
            PsiElement attributeTarget = PomService.convertToPsi((Project)project, (PomTarget)qlAttribute);
            if (processor.execute(attributeTarget, newState)) continue;
            return false;
        }
        return true;
    }

    private static boolean processObjectAttributes(Project project, @Nullable QlEntity element, PsiScopeProcessor processor, ResolveState state) {
        if (element == null) {
            return true;
        }
        for (QlAttribute attribute : element.getAttributes()) {
            PsiElement attributeTarget = PomService.convertToPsi((Project)project, (PomTarget)attribute);
            if (processor.execute(attributeTarget, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processUnqualifiedResolve(Project project, PsiScopeProcessor processor, QlModel model, ResolveState state) {
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{QlStatement.class, QlFile.class});
        if (!PsiTreeUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, (PsiElement)scope, (ResolveState)state)) {
            return false;
        }
        PsiElement parent = ((QlReferenceExpression)this.myElement).getParent();
        if (!(parent instanceof QlGroupByClause) && !(parent instanceof QlOrderByClause)) {
            for (QlEntity object : model.getEntities()) {
                PsiElement element = PomService.convertToPsi((Project)project, (PomTarget)object);
                if (processor.execute(element, state)) continue;
                return false;
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiPackage rootPackage = javaPsiFacade.findPackage("");
            return rootPackage == null || rootPackage.processDeclarations(processor, state, this.myElement, this.myElement);
        }
        return true;
    }

    @NotNull
    public static QlModel getPersistenceModel(@NotNull QlCompositeElement element) {
        PsiFile psiFile2;
        if (element == null) {
            QlReferenceImpl.$$$reportNull$$$0(4);
        }
        QlModel model = (psiFile2 = element.getContainingFile()) instanceof QlFile ? ((QlFile)psiFile2).getQlModel() : null;
        QlModel qlModel = model == null ? QlModel.EMPTY_MODEL : model;
        if (qlModel == null) {
            QlReferenceImpl.$$$reportNull$$$0(5);
        }
        return qlModel;
    }

    private ResolveResult @NotNull [] resolveInner() {
        QlModel model = QlReferenceImpl.getPersistenceModel((QlCompositeElement)this.myElement);
        if (model instanceof ScopeQlModel && ((ScopeQlModel)model).isEmptyModel()) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(this.myElement)};
            if (resolveResultArray == null) {
                QlReferenceImpl.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }
        PsiElement parent = ((QlReferenceExpression)this.myElement).getParent();
        String identifierText = ((QlReferenceExpression)this.myElement).getIdentifier().getText();
        LinkedHashSet result = new LinkedHashSet();
        this.processResolveVariants(model, QlReferenceImpl.createResolveProcessor(model, identifierText, result, !(parent instanceof QlAliasDefinition)));
        if (parent instanceof QlConstructorExpression && !result.isEmpty()) {
            PsiClass psiClass = QlPsiImplUtil.getPsiClassInner(((ResolveResult)result.iterator().next()).getElement());
            PsiMethod method = QlPsiImplUtil.resolveConstructor(parent.getProject(), psiClass, ((QlConstructorExpression)parent).getParameterTypes());
            if (method != null) {
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{method});
                if (resolveResultArray == null) {
                    QlReferenceImpl.$$$reportNull$$$0(7);
                }
                return resolveResultArray;
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            QlReferenceImpl.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    public static PsiScopeProcessor createResolveProcessor(final QlModel model, final String identifierText, final Collection<? super ResolveResult> result, final boolean notInAliasDef) {
        return new PsiScopeProcessor(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean execute(@NotNull PsiElement psiElement, @NotNull ResolveState state) {
                String name;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                QlElement qlElement = null;
                boolean caseSensitive = true;
                if (psiElement instanceof PomTargetPsiElement) {
                    PomTarget target = ((PomTargetPsiElement)psiElement).getTarget();
                    if (!(target instanceof QlElement)) return true;
                    qlElement = (QlElement)target;
                    name = ((QlElement)target).getPersistenceElementName();
                } else if (psiElement instanceof QlAliasDefinition && notInAliasDef) {
                    name = ((QlAliasDefinition)psiElement).getIdentifier().getText();
                    caseSensitive = false;
                } else {
                    if (!(psiElement instanceof PsiNamedElement)) return true;
                    name = ((PsiNamedElement)psiElement).getName();
                }
                if (!Comparing.equal((String)identifierText, (String)name, (boolean)caseSensitive)) return true;
                if (psiElement instanceof PsiClass) {
                    qlElement = model.findEntityByName(((PsiClass)psiElement).getQualifiedName());
                }
                if (qlElement != null) {
                    result.add(new QlResolveResult(qlElement));
                    return true;
                } else {
                    result.add(new PsiElementResolveResult(psiElement));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/ql/psi/impl/QlReferenceImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public Object @NotNull [] getVariants() {
        ArrayList variants = new ArrayList();
        QlModel model = QlReferenceImpl.getPersistenceModel((QlCompositeElement)this.myElement);
        this.processResolveVariants(model, QlReferenceImpl.getCompletionProcessor(variants));
        Object[] objectArray = ArrayUtil.toObjectArray(variants);
        if (objectArray == null) {
            QlReferenceImpl.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    public static PsiScopeProcessor getCompletionProcessor(final Collection<? super LookupElement> variants) {
        return new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement psiElement, @NotNull ResolveState state) {
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                boolean isSynthetic = Boolean.TRUE.equals(state.get(SYNTHETIC_ATTR));
                if (psiElement instanceof PomTargetPsiElement) {
                    PomTarget target = ((PomTargetPsiElement)psiElement).getTarget();
                    if (target instanceof QlElement) {
                        QlElement qlElement = (QlElement)target;
                        String name = qlElement.getPersistenceElementName();
                        Icon icon = qlElement.getIcon();
                        double priority = isSynthetic ? 3.5 : (target instanceof QlAttribute ? 4.0 : 3.0);
                        PsiType type = qlElement.getPsiType();
                        LookupElement item = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)StringUtil.notNullize((String)name, (String)"unnamed")).withIcon(icon).withTypeText(type == null ? null : type.getPresentableText()), (double)priority);
                        item = qlElement instanceof QlAttribute ? item : TailTypeDecorator.withTail((LookupElement)item, (TailType)TailType.SPACE);
                        variants.add(item);
                    }
                } else if (psiElement instanceof PsiNamedElement) {
                    double priority = psiElement instanceof PsiPackage ? 1.0 : (psiElement instanceof QlAliasDefinition ? 5.0 : 3.0);
                    Icon icon = QlReferenceImpl.getIcon(psiElement);
                    variants.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)psiElement)).withIcon(icon), (double)priority));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/ql/psi/impl/QlReferenceImpl$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static Icon getIcon(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            QlReferenceImpl.$$$reportNull$$$0(10);
        }
        return psiElement instanceof PsiPresentableMetaData ? ((PsiPresentableMetaData)psiElement).getIcon() : psiElement.getIcon(0);
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)((QlReferenceExpression)this.myElement).getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, false, false);
        if (resolveResultArray == null) {
            QlReferenceImpl.$$$reportNull$$$0(11);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length > 0 ? results[0].getElement() : null;
    }

    public static LookupElement createKeywordLookupItem(String keyword) {
        LookupElementBuilder builder = LookupElementBuilder.create((String)StringUtil.toLowerCase((String)keyword)).withCaseSensitivity(false).bold();
        if (ourFunctionsWithParens.contains(keyword)) {
            return TailTypeDecorator.withTail((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)builder.withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS).withTailText("()"), (double)1.5), (TailType)TailType.SPACE);
        }
        return TailTypeDecorator.withTail((LookupElement)PrioritizedLookupElement.withPriority((LookupElement)builder.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (context.getStartOffset() == 0) {
                    return;
                }
                char ch = context.getDocument().getCharsSequence().charAt(context.getStartOffset() - 1);
                if (ch == '.') {
                    context.getDocument().insertString(context.getStartOffset(), (CharSequence)"fake ");
                } else if (StringUtil.isJavaIdentifierPart((char)ch)) {
                    context.getDocument().insertString(context.getStartOffset(), (CharSequence)" ");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/jpa/ql/psi/impl/QlReferenceImpl$3";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }), (double)2.0), (TailType)TailType.SPACE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/ql/psi/impl/QlReferenceImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/ql/psi/impl/QlReferenceImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processResolveVariants";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceModel";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QlResolveResult
    implements ResolveResult {
        private final QlElement myPersistentElement;

        public QlResolveResult(QlElement persistentElement) {
            this.myPersistentElement = persistentElement;
        }

        public QlElement getPersistentElement() {
            return this.myPersistentElement;
        }

        public PsiElement getElement() {
            return this.myPersistentElement.getPsiElement();
        }

        public boolean isValidResult() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QlResolveResult result = (QlResolveResult)o;
            return this.myPersistentElement.equals(result.myPersistentElement);
        }

        public int hashCode() {
            return this.myPersistentElement.hashCode();
        }
    }
}

