/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.model;

import com.intellij.jpa.ql.model.Named;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public abstract class QlAttribute
extends QlElement
implements Named {
    public boolean isElementCollection() {
        return false;
    }

    public static boolean isRelationshipEnd(Object o) {
        if (o instanceof QlAttribute) {
            QlAttribute qlAttribute = (QlAttribute)o;
            return qlAttribute.getComponentTarget(ComponentType.SINGLE) == ComponentTarget.ENTITY || qlAttribute.getComponentTarget(ComponentType.VALUE) == ComponentTarget.ENTITY;
        }
        return false;
    }

    @Nullable
    public abstract ComponentTarget getComponentTarget(ComponentType var1);

    @Nullable
    public abstract QlElement getComponentValue(ComponentType var1);

    @Override
    @Nullable
    public PsiType getPsiType() {
        PsiElement element = this.getPsiElement();
        if (element != null) {
            PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
            if (field != null) {
                return field.getType();
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method != null) {
                return method.getReturnType();
            }
        }
        return null;
    }

    public String toString() {
        return this.getPersistenceElementName();
    }

    @Nullable
    public QlEntity getTargetEntity() {
        return null;
    }

    public boolean isEmbeddable() {
        return this.getComponentTarget(ComponentType.SINGLE) == ComponentTarget.EMBEDDABLE;
    }

    public boolean isToMany() {
        return this.getComponentTarget(ComponentType.VALUE) == ComponentTarget.ENTITY;
    }

    public static boolean isElementCollection(Object o) {
        return o instanceof QlAttribute && ((QlAttribute)o).isElementCollection();
    }

    public QlEntity getOtherEntity() {
        QlElement single = this.getComponentValue(ComponentType.SINGLE);
        if (single instanceof QlEntity) {
            return (QlEntity)single;
        }
        QlElement value = this.getComponentValue(ComponentType.VALUE);
        if (value instanceof QlEntity) {
            return (QlEntity)value;
        }
        return null;
    }

    public boolean isEnumAsString() {
        return false;
    }

    public static enum ComponentTarget {
        VALUE,
        EMBEDDABLE,
        ENTITY;

    }

    public static enum ComponentType {
        SINGLE,
        VALUE,
        KEY;

    }
}

