/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.editor;

import com.intellij.jpa.ql.editor.QlSyntaxHighlighter;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlDateTimeLiteral;
import com.intellij.jpa.ql.psi.QlFunctionCallExpression;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class QlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, final @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            QlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            QlAnnotator.$$$reportNull$$$0(1);
        }
        psiElement.accept((PsiElementVisitor)new QlVisitor(){

            @Override
            public void visitAliasDefinition(@NotNull QlAliasDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                QlAnnotator.setHighlighting(o.getIdentifier(), holder, QlSyntaxHighlighter.ID_VARIABLE);
            }

            @Override
            public void visitFunctionCallExpression(@NotNull QlFunctionCallExpression o) {
                PsiElement nameToken;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((nameToken = o.getFirstChild()) != null) {
                    QlAnnotator.setHighlighting(nameToken, holder, QlSyntaxHighlighter.FUNCTION);
                }
            }

            @Override
            public void visitDateTimeLiteral(@NotNull QlDateTimeLiteral o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                QlAnnotator.setHighlighting(o, holder, QlSyntaxHighlighter.DATETIME);
            }

            @Override
            public void visitReferenceExpression(@NotNull QlReferenceExpression o) {
                Object target;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((target = o.resolve()) == null) {
                    return;
                }
                QlIdentifier ident = o.getIdentifier();
                TextAttributesKey attrs = null;
                if (target instanceof QlAliasDefinition) {
                    attrs = QlSyntaxHighlighter.ID_VARIABLE;
                } else if (target instanceof QlEntity) {
                    attrs = QlSyntaxHighlighter.ENTITY;
                } else if (target instanceof QlAttribute) {
                    attrs = QlSyntaxHighlighter.ATTRIBUTE;
                }
                if (attrs != null) {
                    QlAnnotator.setHighlighting(ident, holder, attrs);
                }
            }

            @Override
            public void visitInputParameter(@NotNull QlInputParameter o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                QlAnnotator.setHighlighting(o, holder, QlSyntaxHighlighter.PARAMETER);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/jpa/ql/editor/QlAnnotator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAliasDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionCallExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDateTimeLiteral";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitInputParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, TextAttributesKey key) {
        if (element == null) {
            QlAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            QlAnnotator.$$$reportNull$$$0(3);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/ql/editor/QlAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setHighlighting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

