/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.annotations;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.jpa.ql.JpaQlBundle;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.model.ScopeQlModel;
import com.intellij.jpa.ql.psi.QlAggregateExpression;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlAndExpression;
import com.intellij.jpa.ql.psi.QlArrayItemExpression;
import com.intellij.jpa.ql.psi.QlBetweenExpression;
import com.intellij.jpa.ql.psi.QlBinaryExpression;
import com.intellij.jpa.ql.psi.QlCaseExpression;
import com.intellij.jpa.ql.psi.QlCollectionExpression;
import com.intellij.jpa.ql.psi.QlComparisonExpression;
import com.intellij.jpa.ql.psi.QlConcatFunctionExpression;
import com.intellij.jpa.ql.psi.QlConstructorExpression;
import com.intellij.jpa.ql.psi.QlDerivedCollectionMemberDeclaration;
import com.intellij.jpa.ql.psi.QlElementExpression;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlFromClause;
import com.intellij.jpa.ql.psi.QlInExpression;
import com.intellij.jpa.ql.psi.QlInVariableExpression;
import com.intellij.jpa.ql.psi.QlIndicesExpression;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlIsEmptyExpression;
import com.intellij.jpa.ql.psi.QlIsNullExpression;
import com.intellij.jpa.ql.psi.QlKeyValueExpression;
import com.intellij.jpa.ql.psi.QlLikeExpression;
import com.intellij.jpa.ql.psi.QlMemberOfExpression;
import com.intellij.jpa.ql.psi.QlMulDivExpression;
import com.intellij.jpa.ql.psi.QlNotExpression;
import com.intellij.jpa.ql.psi.QlNumericFunctionExpression;
import com.intellij.jpa.ql.psi.QlNumericLiteral;
import com.intellij.jpa.ql.psi.QlObjectSelectExpression;
import com.intellij.jpa.ql.psi.QlOrExpression;
import com.intellij.jpa.ql.psi.QlOrderByClause;
import com.intellij.jpa.ql.psi.QlPlusMinusExpression;
import com.intellij.jpa.ql.psi.QlQueryExpression;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlRowConstructorExpression;
import com.intellij.jpa.ql.psi.QlSelectClause;
import com.intellij.jpa.ql.psi.QlSelectStatement;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlStringLiteral;
import com.intellij.jpa.ql.psi.QlUnaryArithmeticExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.jpa.ql.psi.QlWhenClause;
import com.intellij.jpa.ql.psi.QlWhereClause;
import com.intellij.jpa.ql.psi.impl.QlCompositeElementImpl;
import com.intellij.jpa.ql.types.QlClassType;
import com.intellij.jpa.ql.types.QlCollectionType;
import com.intellij.jpa.ql.types.QlIndexedCollectionType;
import com.intellij.jpa.ql.types.QlType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QlAnnotationVisitor
extends QlVisitor {
    @NotNull
    private final QlProblemDescriptorCreator myCreator;
    private final Predicate<? super TextRange> isEditable;

    public QlAnnotationVisitor(@NotNull QlProblemDescriptorCreator creator, @NotNull Predicate<? super TextRange> isEditable) {
        if (creator == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(0);
        }
        if (isEditable == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(1);
        }
        this.myCreator = creator;
        this.isEditable = isEditable;
    }

    protected final void addError(@NotNull TextRange range, @NotNull @Nls String errorMessage) {
        if (range == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(2);
        }
        if (errorMessage == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(3);
        }
        if (this.isEditable.test((TextRange)range)) {
            this.myCreator.create(range.getStartOffset(), range.getEndOffset(), errorMessage, HighlightSeverity.ERROR, null, null);
        }
    }

    private void addError(@NotNull PsiElement element, @Nls String errorMessage, Object ... args) {
        if (element == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(4);
        }
        this.addError(element.getTextRange(), MessageFormat.format(errorMessage, args));
    }

    private boolean checkType(@Nullable QlExpression expression, @NotNull QlType type) {
        PsiClass typeTargetClass;
        PsiClass tTargetClass;
        if (type == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            return false;
        }
        QlType t = expression.getType();
        if (t instanceof QlClassType && type instanceof QlClassType && (tTargetClass = ((QlClassType)t).getTargetClass()).equals(typeTargetClass = ((QlClassType)type).getTargetClass()) && tTargetClass.isEnum()) {
            return true;
        }
        if (t instanceof QlClassType && type == QlType.ENTITY || t == QlType.ENTITY && type instanceof QlClassType) {
            return true;
        }
        if (t != null && !t.equals(type)) {
            QlExpression expr = expression;
            while (expr instanceof QlCollectionExpression) {
                expr = ((QlCollectionExpression)expr).getExpression();
            }
            if (expr instanceof QlQueryExpression && t instanceof QlIndexedCollectionType && type.equals(((QlIndexedCollectionType)t).getComponentType())) {
                return true;
            }
            if (QlAnnotationVisitor.isHibernate(expr) && (type == QlType.NUMBER && t == QlType.DATETIME || t == QlType.NUMBER && type == QlType.DATETIME)) {
                return true;
            }
            this.addError(expression.getTextRange(), JpaQlBundle.message("type.mismatch.0.type.expected", type.getName()));
            return false;
        }
        return true;
    }

    private boolean checkCollectionType(@Nullable QlExpression expression) {
        if (expression == null) {
            return false;
        }
        QlType t = expression.getType();
        if (t != null && !(t instanceof QlCollectionType)) {
            this.addError(expression.getTextRange(), JpaQlBundle.message("type.mismatch.0.type.expected", QlType.COLLECTION.getName()));
            return false;
        }
        return true;
    }

    private static boolean checkEnumType(QlExpression lOperand, QlType lType, QlType rType) {
        if (lType instanceof QlClassType && ((QlClassType)lType).getTargetClass().isEnum()) {
            boolean enumAsString;
            Object o = lOperand instanceof QlReferenceExpression ? ((QlReferenceExpression)lOperand).resolve() : null;
            boolean bl = enumAsString = o instanceof QlAttribute && ((QlAttribute)o).isEnumAsString();
            if (enumAsString && rType == QlType.STRING || !enumAsString && rType == QlType.NUMBER) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitBetweenExpression(@NotNull QlBetweenExpression o) {
        QlExpression upper;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(6);
        }
        if ((upper = o.getUpperBound()) == null) {
            return;
        }
        QlExpression operand = o.getOperand();
        QlType type = operand.getType();
        if (type == null) {
            return;
        }
        if (type != QlType.NUMBER && type != QlType.DATETIME && type != QlType.STRING) {
            this.addError(operand, JpaQlBundle.message("type.mismatch.number.date.or.string.expected", new Object[0]), new Object[0]);
            return;
        }
        this.checkType(o.getLowerBound(), type);
        this.checkType(upper, type);
    }

    @Override
    public void visitObjectSelectExpression(@NotNull QlObjectSelectExpression o) {
        QlReferenceExpression expression;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(7);
        }
        if ((expression = o.getReferenceExpression()) != null && expression.getQualifier() != null) {
            this.addError(expression, JpaQlBundle.message("identification.variable.expected", new Object[0]), new Object[0]);
        }
    }

    @Override
    public void visitKeyValueExpression(@NotNull QlKeyValueExpression o) {
        IElementType firstElementType;
        QlReferenceExpression mapExpression;
        QlType mapType;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(8);
        }
        if ((mapType = (mapExpression = o.getReferenceExpression()).getType()) == null) {
            return;
        }
        if (!(mapType instanceof QlIndexedCollectionType)) {
            this.addError(mapExpression, JpaQlBundle.message("type.mismatch.map.type.expected", new Object[0]), new Object[0]);
        }
        if ((firstElementType = QlAnnotationVisitor.getFirstElementType(o)) == QlTypes.QL_ENTRY && !(o.getParent() instanceof QlSelectClause)) {
            this.addError(o, JpaQlBundle.message("entry.reference.is.allowed.only.in.select.clause", new Object[0]), new Object[0]);
        }
    }

    @Override
    public void visitDerivedCollectionMemberDeclaration(@NotNull QlDerivedCollectionMemberDeclaration o) {
        QlReferenceExpression referenceExpression;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(9);
        }
        if ((referenceExpression = o.getReferenceExpression()) == null) {
            return;
        }
        Object target = referenceExpression.resolve();
        if (!QlAttribute.isRelationshipEnd(target)) {
            this.addError(referenceExpression, JpaQlBundle.message("relationship.expected", new Object[0]), new Object[0]);
        }
    }

    @Override
    public void visitLikeExpression(@NotNull QlLikeExpression o) {
        List<QlExpression> list;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(10);
        }
        if ((list = o.getExpressionList()).size() >= 2) {
            this.checkType(list.get(0), QlType.STRING);
            if (!this.checkType(list.get(1), QlType.STRING)) {
                return;
            }
            if (list.size() == 3) {
                this.checkConstantOrParameterExpression(list.get(2), QlType.STRING);
            }
        }
    }

    @Override
    public void visitNumericFunctionExpression(@NotNull QlNumericFunctionExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(11);
        }
        IElementType type = QlAnnotationVisitor.getFirstElementType(o);
        List<QlExpression> list = o.getExpressionList();
        if (type == QlTypes.QL_ABS || type == QlTypes.QL_SQRT) {
            if (list.size() == 1) {
                this.checkType(list.get(0), QlType.NUMBER);
            }
        } else if (type == QlTypes.QL_MOD) {
            if (list.size() == 2) {
                this.checkType(list.get(0), QlType.NUMBER);
                this.checkType(list.get(1), QlType.NUMBER);
            }
        } else if (type == QlTypes.QL_LENGTH) {
            if (list.size() == 1) {
                this.checkType(list.get(0), QlType.STRING);
            }
        } else if (type == QlTypes.QL_LOCATE) {
            if (list.size() >= 2) {
                this.checkType(list.get(0), QlType.STRING);
                this.checkType(list.get(1), QlType.STRING);
                QlExpression third = list.size() == 3 ? list.get(2) : null;
                this.checkType(third, QlType.NUMBER);
            }
        } else if (list.size() == 1) {
            this.checkCollectionType(list.get(0));
        }
    }

    @Override
    public void visitAggregateExpression(@NotNull QlAggregateExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(12);
        }
        QlExpression expression = o.getExpression();
        IElementType type = QlAnnotationVisitor.getFirstElementType(o);
        if (type == QlTypes.QL_SUM && expression != null && !expression.getText().equals("*")) {
            this.checkType(expression, QlType.NUMBER);
        }
    }

    private static IElementType getFirstElementType(QlExpression o) {
        return QlCompositeElementImpl.getFirstElementType(o);
    }

    @Override
    public void visitConstructorExpression(@NotNull QlConstructorExpression constructorCall) {
        if (constructorCall == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(13);
        }
        List<PsiType> parameterTypes = constructorCall.getParameterTypes();
        for (PsiType type : parameterTypes) {
            if (type != null) continue;
            return;
        }
        QlReferenceExpression refExpression = constructorCall.getReferenceExpression();
        if (refExpression != null && refExpression.resolve() instanceof PsiMethod) {
            return;
        }
        PsiMethod psiMethod = constructorCall.resolveConstructor();
        if (psiMethod == null && refExpression != null) {
            PsiPolyVariantReference reference = refExpression.getReference();
            TextRange range = new TextRange(reference.getRangeInElement().getEndOffset() + reference.getElement().getTextRange().getStartOffset(), constructorCall.getTextRange().getEndOffset());
            String name = refExpression.getText() + QlAnnotationVisitor.buildArgTypesList(parameterTypes);
            this.addError(range, JavaErrorBundle.message((String)"cannot.resolve.constructor", (Object[])new Object[]{name}));
        }
    }

    private static String buildArgTypesList(List<PsiType> list) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            PsiType argType = list.get(i);
            builder.append(JavaHighlightUtil.formatType((PsiType)argType));
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void visitOrderByClause(@NotNull QlOrderByClause o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(14);
        }
        for (PsiElement element : o.getChildren()) {
            if (!(element instanceof QlReferenceExpression)) continue;
            this.checkOrderByItem((QlReferenceExpression)element);
        }
    }

    public void checkOrderByItem(@NotNull QlReferenceExpression expression) {
        QlModel model;
        if (expression == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(15);
        }
        if ((model = ((QlFile)expression.getContainingFile()).getQlModel()) instanceof ScopeQlModel) {
            ScopeQlModel scopeModel = (ScopeQlModel)model;
            if (!scopeModel.isEmptyModel() && !(expression.resolve() instanceof QlAttribute)) {
                this.addError(expression, JpaQlBundle.message("orderable.attribute.expected", new Object[0]), new Object[0]);
            }
        } else {
            Object target;
            QlExpression aliasedExpression;
            Object pathStart;
            QlExpression _q1 = expression.getQualifier();
            QlReferenceExpression q1 = null;
            while (_q1 instanceof QlReferenceExpression) {
                q1 = (QlReferenceExpression)_q1;
                _q1 = q1.getQualifier();
            }
            Object object = pathStart = q1 == null ? null : q1.resolve();
            if (pathStart != null && !(pathStart instanceof QlAliasDefinition) && !QlAttribute.isRelationshipEnd(pathStart)) {
                if (pathStart instanceof QlAttribute && ((QlAttribute)pathStart).isEmbeddable()) {
                    return;
                }
                this.addError(expression, JpaQlBundle.message("orderable.attribute.expected", new Object[0]), new Object[0]);
                return;
            }
            Object resolve = expression.resolve();
            QlExpression qlExpression = aliasedExpression = resolve instanceof QlAliasDefinition ? ((QlAliasDefinition)resolve).getExpression() : null;
            Object object2 = aliasedExpression instanceof QlReferenceExpression ? ((QlReferenceExpression)aliasedExpression).resolve() : (target = aliasedExpression instanceof QlAggregateExpression ? aliasedExpression : resolve);
            if (target instanceof QlElement) {
                PsiType psiType = ((QlElement)target).getPsiType();
                if (InheritanceUtil.isInheritor((PsiType)psiType, (String)"java.lang.Comparable") || psiType instanceof PsiPrimitiveType) {
                    return;
                }
                this.addError(expression, JpaQlBundle.message("orderable.attribute.expected", new Object[0]), new Object[0]);
            } else if (target != null && !(target instanceof QlAggregateExpression)) {
                this.addError(expression, JpaQlBundle.message("orderable.attribute.expected", new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public void visitArrayItemExpression(@NotNull QlArrayItemExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(16);
        }
        if (o.getType() == null) {
            return;
        }
        QlExpression right = o.getRight();
        if (right != null) {
            QlIndexedCollectionType type;
            QlExpression left = o.getLeft();
            QlIndexedCollectionType qlIndexedCollectionType = type = left.getType() instanceof QlCollectionType ? (QlIndexedCollectionType)left.getType() : null;
            if (type != null) {
                this.checkType(right, type.getIndexType());
            }
        }
    }

    @Override
    public void visitInputParameter(@NotNull QlInputParameter o) {
        String name;
        PsiElement number;
        boolean positional;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(17);
        }
        boolean bl = positional = (number = o.getNumber()) != null;
        if (positional && StringUtil.isNotEmpty((String)(name = number.getText()))) {
            try {
                int i = Integer.parseInt(name);
                if (i <= 0) {
                    this.addError(o, JpaQlBundle.message("query.parameters.are.numerated.starting.with.1", new Object[0]), new Object[0]);
                } else {
                    int count = ((QlFile)o.getContainingFile()).getQlModel().getParametersCount();
                    if (count >= 0 && i > count) {
                        this.addError(o, count == 0 ? JpaQlBundle.message("query.has.no.parameters", new Object[0]) : (count == 1 ? JpaQlBundle.message("query.has.only.one.parameter", new Object[0]) : JpaQlBundle.message("there.are.only.count.query.parameters", count)), new Object[0]);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.addError(o, JpaQlBundle.message("number.expected", new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public void visitWhenClause(@NotNull QlWhenClause o) {
        PsiElement caseExpression;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(18);
        }
        if ((caseExpression = o.getParent()) instanceof QlCaseExpression) {
            QlType type;
            QlExpression expression = ((QlCaseExpression)caseExpression).getExpression();
            QlType qlType = type = expression == null ? QlType.BOOLEAN : expression.getType();
            if (type != null) {
                this.checkType(o.getExpression(), type);
            }
        }
    }

    @Override
    public void visitStatement(@NotNull QlStatement o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(19);
        }
        final HashMap name2declaration = new HashMap();
        o.accept(new QlRecursiveVisitor(){

            @Override
            public void visitAliasDefinition(@NotNull QlAliasDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                QlAnnotationVisitor.this.processDeclaration(name2declaration, o.getIdentifier(), o.getIdentifier().getText());
            }

            @Override
            public void visitQueryExpression(@NotNull QlQueryExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (o.getParent() instanceof QlSelectStatement) {
                    super.visitQueryExpression(o);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/intellij/jpa/ql/annotations/QlAnnotationVisitor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAliasDefinition";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQueryExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void processDeclaration(@NotNull Map<String, PsiElement> name2declaration, @NotNull PsiElement declaration, String name) {
        if (name2declaration == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(20);
        }
        if (declaration == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(21);
        }
        if (name2declaration.containsKey(name)) {
            PsiElement dcl = name2declaration.get(name);
            assert (dcl != null);
            this.addError(dcl, JpaQlBundle.message("duplicate.identifier", new Object[0]), new Object[0]);
            this.addError(declaration, JpaQlBundle.message("duplicate.identifier", new Object[0]), new Object[0]);
            return;
        }
        name2declaration.put(name, declaration);
    }

    @Override
    public void visitWhereClause(@NotNull QlWhereClause o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(22);
        }
        this.checkType(o.getExpression(), QlType.BOOLEAN);
    }

    @Override
    public void visitIsNullExpression(@NotNull QlIsNullExpression o) {
        QlExpression operand;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(23);
        }
        if ((operand = o.getExpression()).getType() instanceof QlCollectionType) {
            this.addError(operand.getTextRange(), JpaQlBundle.message("type.mismatch.0.type.expected", "single-valued"));
        }
    }

    @Override
    public void visitMemberOfExpression(@NotNull QlMemberOfExpression o) {
        QlExpression right;
        QlType rightType;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(24);
        }
        QlType qlType = rightType = (right = o.getRight()) != null ? right.getType() : null;
        if (rightType instanceof QlIndexedCollectionType) {
            QlType type = ((QlIndexedCollectionType)rightType).getComponentType();
            this.checkType(o.getLeft(), type);
        }
        if (rightType == QlType.NUMBER) {
            return;
        }
        this.checkCollectionType(right);
    }

    @Override
    public void visitInVariableExpression(@NotNull QlInVariableExpression o) {
        QlReferenceExpression referenceExpression;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(25);
        }
        if ((referenceExpression = o.getReferenceExpression()) == null) {
            return;
        }
        Object target = referenceExpression.resolve();
        if (!QlAttribute.isRelationshipEnd(target) && !QlAttribute.isElementCollection(target)) {
            this.addError(referenceExpression, JpaQlBundle.message("relationship.expected", new Object[0]), new Object[0]);
        }
    }

    @Override
    public void visitInExpression(@NotNull QlInExpression o) {
        List<QlExpression> list;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(26);
        }
        if ((list = o.getExpressionList()).size() > 1) {
            QlExpression expression = list.get(0);
            QlType type = expression.getType();
            if (type == null) {
                return;
            }
            for (int i = 1; i < list.size(); ++i) {
                QlExpression e = list.get(i);
                if (e instanceof QlCollectionExpression || e instanceof QlElementExpression || e instanceof QlIndicesExpression || e instanceof QlRowConstructorExpression) continue;
                this.checkType(e, type);
            }
        }
    }

    private void checkConstantOrParameterExpression(QlExpression e, @NotNull QlType type) {
        if (type == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(27);
        }
        if (e instanceof QlNumericLiteral || e instanceof QlStringLiteral || e instanceof QlInputParameter) {
            this.checkType(e, type);
        } else if (e instanceof QlReferenceExpression) {
            QlReferenceExpression referenceExpression = (QlReferenceExpression)e;
            Object o = referenceExpression.resolve();
            if (!(o instanceof QlAliasDefinition)) {
                this.addError(e, JpaQlBundle.message("constant.expected", StringUtil.capitalize((String)type.getName())), new Object[0]);
            } else {
                this.checkType(e, type);
            }
        } else {
            QlType qlType = e.getType();
            if (type.equals(qlType)) {
                return;
            }
            if (qlType instanceof QlCollectionType && type.equals(((QlCollectionType)qlType).getComponentType())) {
                return;
            }
            this.addError(e, JpaQlBundle.message("constant.expected", StringUtil.capitalize((String)type.getName())), new Object[0]);
        }
    }

    @Override
    public void visitNotExpression(@NotNull QlNotExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(28);
        }
        this.checkType(o.getExpression(), QlType.BOOLEAN);
    }

    @Override
    public void visitIsEmptyExpression(@NotNull QlIsEmptyExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(29);
        }
        this.checkCollectionType(o.getExpression());
    }

    @Override
    public void visitConcatFunctionExpression(@NotNull QlConcatFunctionExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(30);
        }
        if (QlAnnotationVisitor.isHibernate(o)) {
            return;
        }
        List<QlExpression> list = o.getExpressionList();
        if (list.size() == 2) {
            this.checkType(list.get(0), QlType.STRING);
            this.checkType(list.get(1), QlType.STRING);
        }
    }

    @Override
    public void visitUnaryArithmeticExpression(@NotNull QlUnaryArithmeticExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(31);
        }
        this.checkType(o.getExpression(), QlType.NUMBER);
    }

    @Override
    public void visitPlusMinusExpression(@NotNull QlPlusMinusExpression o) {
        IElementType operator;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(32);
        }
        if ((operator = o.getOperator()) == QlTypes.QL_OP_CONCAT) {
            if (QlAnnotationVisitor.isHibernate(o)) {
                return;
            }
            this.checkBinaryExpression(o, QlType.STRING);
        } else if (operator == QlTypes.QL_OP_PLUS || operator == QlTypes.QL_OP_MINUS) {
            this.checkBinaryExpression(o, QlType.NUMBER);
        }
    }

    private void checkBinaryExpression(QlBinaryExpression o, QlType type) {
        QlExpression right = o.getRight();
        if (right == null) {
            return;
        }
        this.checkType(o.getLeft(), type);
        this.checkType(right, type);
    }

    @Override
    public void visitMulDivExpression(@NotNull QlMulDivExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(33);
        }
        this.checkBinaryExpression(o, QlType.NUMBER);
    }

    @Override
    public void visitAndExpression(@NotNull QlAndExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(34);
        }
        this.checkBinaryExpression(o, QlType.BOOLEAN);
    }

    @Override
    public void visitOrExpression(@NotNull QlOrExpression o) {
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(35);
        }
        this.checkBinaryExpression(o, QlType.BOOLEAN);
    }

    @Override
    public void visitComparisonExpression(@NotNull QlComparisonExpression o) {
        QlExpression rOperand;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(36);
        }
        if ((rOperand = o.getRight()) != null) {
            QlExpression lOperand = o.getLeft();
            QlType lType = lOperand.getType();
            QlType rType = rOperand.getType();
            if (lType == null || rType == null) {
                return;
            }
            if (lType == QlType.DATETIME && rType == QlType.STRING || lType == QlType.STRING && rType == QlType.DATETIME) {
                return;
            }
            if (lType instanceof QlClassType && rType instanceof QlClassType) {
                return;
            }
            if (lType instanceof QlClassType && rType == QlType.ENTITY || lType == QlType.ENTITY && rType instanceof QlClassType) {
                return;
            }
            if (QlAnnotationVisitor.checkEnumType(lOperand, lType, rType) || QlAnnotationVisitor.checkEnumType(rOperand, rType, lType)) {
                return;
            }
            if (lType instanceof QlClassType && rType == QlType.STRING || lType == QlType.STRING && rType instanceof QlClassType) {
                return;
            }
            if (lType != rType) {
                this.checkType(rOperand, lType);
            }
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull QlReferenceExpression o) {
        PsiElement parent;
        if (o == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(37);
        }
        if (!QlAnnotationVisitor.shouldCheckResolve(o)) {
            return;
        }
        Object result = o.resolve();
        if (result == null) {
            this.addError(QlAnnotationVisitor.getReferenceRange((PsiReference)o.getReference()), JpaQlBundle.message("can.t.resolve.symbol.0", o.getIdentifier().getText()));
        } else if (result instanceof PsiClass && ((parent = o.getParent()) instanceof QlAliasDefinition || parent instanceof QlFromClause) && !QlAnnotationVisitor.isHibernate(o) && !QlAnnotationVisitor.isEntity((PsiClass)result)) {
            this.addError(QlAnnotationVisitor.getReferenceRange((PsiReference)o.getReference()), JpaQlBundle.message("class.0.is.not.an.entity", o.getIdentifier().getText()));
        }
    }

    private static boolean isEntity(@NotNull PsiClass result) {
        if (result == null) {
            QlAnnotationVisitor.$$$reportNull$$$0(38);
        }
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)result)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY) continue;
            return true;
        }
        return false;
    }

    private static boolean isHibernate(PsiElement o) {
        return o.getContainingFile().getLanguage() == JpqlLanguage.HQL;
    }

    private static TextRange getReferenceRange(PsiReference reference) {
        return reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset());
    }

    private static boolean shouldCheckResolve(QlReferenceExpression o) {
        QlExpression qualifier = o.getQualifier();
        if (qualifier != null && !(qualifier instanceof QlKeyValueExpression)) {
            PsiReference r;
            QlExpression referenceExpression;
            PsiElement qualifierResolve;
            PsiReference qualifierReference = qualifier.getReference();
            PsiElement psiElement = qualifierResolve = qualifierReference == null ? null : qualifierReference.resolve();
            if (qualifierResolve == null) {
                return false;
            }
            if (qualifierResolve instanceof QlAliasDefinition && (referenceExpression = ((QlAliasDefinition)qualifierResolve).getExpression()) instanceof QlReferenceExpression && (r = referenceExpression.getReference()) != null && r.resolve() == null) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isEditable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorCall";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2declaration";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/ql/annotations/QlAnnotationVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addError";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBetweenExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectSelectExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitKeyValueExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDerivedCollectionMemberDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLikeExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNumericFunctionExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAggregateExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstructorExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitOrderByClause";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOrderByItem";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayItemExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInputParameter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhenClause";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "visitStatement";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhereClause";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIsNullExpression";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMemberOfExpression";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInVariableExpression";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInExpression";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConstantOrParameterExpression";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNotExpression";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIsEmptyExpression";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConcatFunctionExpression";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryArithmeticExpression";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPlusMinusExpression";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMulDivExpression";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAndExpression";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "visitOrExpression";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComparisonExpression";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "isEntity";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface QlProblemDescriptorCreator {
        public void create(int var1, int var2, @NotNull @Nls String var3, @NotNull HighlightSeverity var4, @Nullable TextAttributes var5, @Nullable List<Annotation.QuickFixInfo> var6);
    }
}

