/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters.providers;

import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.jpa.model.implicit.PersistenceUnitConstants;
import com.intellij.jpa.model.xml.impl.converters.providers.PersistenceConverters;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.persistence.model.PersistencePackage;

public class TopLinkConverters
extends PersistenceConverters {
    private static final Condition<Property> isTopLinkProvider = domElement -> JpaUtil.isTopLink(JpaUtil.findJpaProvider(null, (PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true), false), null);

    public TopLinkConverters() {
        this.registerConverters();
    }

    @Override
    protected Condition<Property> getCondition() {
        return isTopLinkProvider;
    }

    private void registerConverters() {
        this.registerConverter(this.getCondition(), "toplink.jdbc.driver", TopLinkConverters.getPsiClassConverter("java.sql.Driver"));
        this.registerEmptyTopLinkConverter("toplink.jdbc.url");
        this.registerEmptyTopLinkConverter("toplink.jdbc.user");
        this.registerEmptyTopLinkConverter("toplink.jdbc.password");
        for (String property : PersistenceUnitConstants.additionalTopLinkProperties()) {
            this.registerEmptyTopLinkConverter(property);
        }
    }

    private void registerEmptyTopLinkConverter(String name) {
        this.registerEmptyConverter(this.getCondition(), name);
    }
}

