/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters.providers;

import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.model.implicit.PersistenceUnitConstants;
import com.intellij.jpa.model.xml.impl.converters.PersistenceConvertersBase;
import com.intellij.jpa.model.xml.impl.enums.DatabaseActionEnum;
import com.intellij.jpa.model.xml.impl.enums.SchemaGenerationEnum;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.EnumConverter;
import com.intellij.util.xml.ResolvingConverter;
import org.jetbrains.annotations.Nullable;

public class PersistenceConverters
extends PersistenceConvertersBase {
    private static final Condition<Property> persistenceXmlPropertyCondition = domElement -> domElement != null && JpaUtil.findJpaProvider(null, (PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true), false) == null;

    public PersistenceConverters() {
        this.registerGenericConverters();
    }

    private void registerGenericConverters() {
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.LOCK_TIMEOUT, Converter.INTEGER_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.QUERY_TIMEOUT, Converter.INTEGER_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.VALIDATION_PRE_PERSIST, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.VALIDATION_PRE_UPDATE, Converter.INTEGER_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.VALIDATION_PRE_REMOVE, Converter.INTEGER_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.DRIVER_CLASS, PersistenceConverters.getPsiClassConverter("java.sql.Driver"));
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.CONNECTION_URL, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.USERNAME, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.PASSWORD, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.CREATE_SCRIPT_SOURCE, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.DROP_SCRIPT_SOURCE, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.LOAD_SCRIPT_SOURCE, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.DATABASE_ACTION, (Converter<?>)EnumConverter.createEnumConverter(DatabaseActionEnum.class));
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.SCRIPTS_ACTION, (Converter<?>)EnumConverter.createEnumConverter(DatabaseActionEnum.class));
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.CREATE_SOURCE, (Converter<?>)EnumConverter.createEnumConverter(SchemaGenerationEnum.class));
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.DROP_SOURCE, (Converter<?>)EnumConverter.createEnumConverter(SchemaGenerationEnum.class));
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.CREATE_TARGET, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
        this.registerConfigPropertyAlternatives(PersistenceUnitConstants.DROP_TARGET, (Converter<?>)ResolvingConverter.EMPTY_CONVERTER);
    }

    private void registerConfigPropertyAlternatives(JavaeeClass propertyClassName, Converter<?> converter) {
        this.myRegistry.registerGenericValueConverter(Property.class, this.getCondition(), propertyClassName, converter);
    }

    protected Condition<Property> getCondition() {
        return persistenceXmlPropertyCondition;
    }

    @Override
    @Nullable
    public Converter<?> getValueConverter(DomElement domElement) {
        return this.myRegistry.getValueConverter(domElement);
    }

    @Override
    @Nullable
    public Converter<?> getNameConverter(DomElement domElement) {
        return this.myRegistry.getNameConverter(domElement);
    }
}

