/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters.providers;

import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.jpa.model.implicit.PersistenceUnitConstants;
import com.intellij.jpa.model.xml.impl.converters.providers.PersistenceConverters;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.persistence.model.PersistencePackage;

public class EclipseLinkConverters
extends PersistenceConverters {
    private static final Condition<Property> isEclipseLinkProvider = domElement -> JpaUtil.isEclipseLink(JpaUtil.findJpaProvider(null, (PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true), false), null);

    public EclipseLinkConverters() {
        this.registerConverters();
    }

    @Override
    protected Condition<Property> getCondition() {
        return isEclipseLinkProvider;
    }

    private void registerConverters() {
        this.registerConverter(this.getCondition(), "eclipselink.jdbc.driver", EclipseLinkConverters.getPsiClassConverter("java.sql.Driver"));
        this.registerEmptyEclipseLinkConverter("eclipselink.jdbc.url");
        this.registerEmptyEclipseLinkConverter("eclipselink.jdbc.user");
        this.registerEmptyEclipseLinkConverter("eclipselink.jdbc.password");
        for (String property : PersistenceUnitConstants.additionalEclipseLinkProperties()) {
            this.registerEmptyEclipseLinkConverter(property);
        }
    }

    private void registerEmptyEclipseLinkConverter(String name) {
        this.registerEmptyConverter(this.getCondition(), name);
    }
}

