/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.javaee.model.xml.GenericNamedValueConverters;
import com.intellij.javaee.model.xml.persistence.Property;
import com.intellij.jpa.model.xml.impl.converters.ClassWithShortcutsResolvingConverter;
import com.intellij.jpa.model.xml.impl.converters.PersistenceConvertersRegistry;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistenceConvertersBase
extends GenericNamedValueConverters {
    protected final PersistenceConvertersRegistry myRegistry = new PersistenceConvertersRegistry();

    public void registerConverter(Condition<Property> condition, String name, Converter<?> converter) {
        this.myRegistry.registerValueConverter(Property.class, condition, name, converter);
    }

    public void registerEmptyConverter(Condition<Property> condition, String name) {
        this.myRegistry.registerValueConverter(Property.class, condition, name, (Converter)ResolvingConverter.EMPTY_CONVERTER);
    }

    @Nullable
    public Converter<?> getValueConverter(DomElement domElement) {
        return this.myRegistry.getValueConverter(domElement);
    }

    @Nullable
    public Converter<?> getNameConverter(DomElement domElement) {
        return this.myRegistry.getNameConverter(domElement);
    }

    @NotNull
    public <T extends DomElement> Map<String, Converter> getConverters(Class<T> domClass) {
        Map<String, Converter> map = this.myRegistry.getConverters(domClass);
        if (map == null) {
            PersistenceConvertersBase.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Nullable
    public <T extends DomElement> Converter<?> getConverter(Class<T> domClass, @NonNls String name) {
        return this.myRegistry.getConverter(domClass, name);
    }

    protected static Converter<?> getPsiClassConverter(@NlsSafe String baseClassName) {
        return PersistenceConvertersBase.getPsiClassConverter(baseClassName, Collections.emptyMap());
    }

    protected static Converter<?> getPsiClassConverter(final @NlsSafe String baseClassName, final Map<String, String> shortcutMap) {
        return new ClassWithShortcutsResolvingConverter(){

            @Override
            @Nullable
            @NlsSafe
            protected String getBaseClassName(ConvertContext context) {
                return baseClassName;
            }

            @Override
            @NotNull
            protected Map<String, String> getShortcutsMap(ConvertContext context) {
                Map map = shortcutMap;
                if (map == null) {
                    1.$$$reportNull$$$0(0);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistenceConvertersBase$1", "getShortcutsMap"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/PersistenceConvertersBase", "getConverters"));
    }
}

