/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.manipulators;

import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.javaee.model.common.persistence.mapping.CascadeTypeMode;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.javaee.model.common.persistence.mapping.PersistentObject;
import com.intellij.javaee.model.xml.persistence.mapping.FetchType;
import com.intellij.jpa.PersistenceAttributesProvider;
import com.intellij.jpa.model.manipulators.ObjectManipulatorBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.model.manipulators.PersistenceAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class JpaObjectManipulatorBase<T extends PersistentObject>
extends ObjectManipulatorBase<T> {
    public JpaObjectManipulatorBase(T target) {
        super(target);
    }

    public void addCascadeVariants(Collection<String> cascadeVariants) {
        for (CascadeTypeMode typeMode : CascadeTypeMode.values()) {
            cascadeVariants.add(typeMode.getValue());
        }
    }

    public void addFetchVariants(Collection<String> fetchVariants) {
        for (FetchType type : FetchType.values()) {
            fetchVariants.add(type.getDisplayName());
        }
    }

    public List<PersistenceAction> getCreateActions() {
        ArrayList<PersistenceAction> result = new ArrayList<PersistenceAction>();
        for (AttributeType type : PersistenceAttributesProvider.values()) {
            if (!(type instanceof JpaAttributeType) || type == JpaAttributeType.TRANSIENT) continue;
            result.add((PersistenceAction)this.createNewAttributeAction(type));
        }
        return result;
    }

    protected abstract MyJpaAttributeAction createNewAttributeAction(AttributeType var1);

    public static class MyJpaAttributeAction<T extends JpaObjectManipulatorBase<? extends PersistentObject>>
    extends ObjectManipulatorBase.MyAttributeAction<T> {
        public MyJpaAttributeAction(T manipulator, AttributeType attributeType) {
            super(manipulator, attributeType);
        }

        @Override
        public void update(AnActionEvent e) {
            super.update(e);
            if (this.getPresentation().isEnabled()) {
                PersistentObject target = (PersistentObject)((JpaObjectManipulatorBase)this.getManipulator()).getManipulatorTarget();
                boolean enable = this.myAttributeType == JpaAttributeType.BASIC || this.myAttributeType == JpaAttributeType.TRANSIENT || target instanceof PersistentEntityBase;
                this.getPresentation().setEnabled(enable);
            }
        }

        @Override
        protected RelationshipType getRelationshipType() {
            return this.myAttributeType.getRelationshipType();
        }
    }
}

