/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.ManualModelMergerUtil;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.javaee.model.common.persistence.JpaConstants;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.PersistenceAttributesProvider;
import com.intellij.jpa.model.annotations.mapping.AttributeBaseImpl;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.helpers.PersistentObjectModelHelper;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentObjectImpl
extends CommonModelElement.PsiBase
implements com.intellij.javaee.model.common.persistence.mapping.PersistentObject,
PersistentObjectModelHelper,
JamElement {
    public static final JamEnumAttributeMeta.Single<AccessType> ACCESS_VALUE_ATTR_META = JamAttributeMeta.singleEnum((String)"value", AccessType.class);
    public static final JamMemberArchetype<PsiClass, PersistentObjectImpl> PERSISTENT_OBJECT_ARCHETYPE = new JamMemberArchetype(null);
    private final PsiClass myPsiClass;
    private final PsiElementRef<PsiAnnotation> myAnno;
    protected JavaeeType myJavaeeType;
    private final AccessType myAccessType;
    private CachedValue<PropertyMemberType> myDefaultAccessModeValue;

    protected PersistentObjectImpl(PsiAnnotation psiAnnotation) {
        this.myPsiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiClass.class, (boolean)true);
        this.myAnno = PsiElementRef.real((PsiElement)psiAnnotation);
        String qualifiedName = psiAnnotation.getQualifiedName();
        this.myJavaeeType = qualifiedName == null || qualifiedName.startsWith(JavaeeType.JAVAX.pkg) ? JavaeeType.JAVAX : JavaeeType.JAKARTA;
        this.myAccessType = PersistentObjectImpl.calculateAccessType(this.myPsiClass);
    }

    public PersistentObjectImpl(@NotNull PsiClass aClass, @NotNull JavaeeClass anno) {
        if (aClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(0);
        }
        if (anno == null) {
            PersistentObjectImpl.$$$reportNull$$$0(1);
        }
        this.myPsiClass = aClass;
        this.myJavaeeType = anno.typeFromAnnotated((PsiModifierListOwner)aClass);
        this.myAnno = AnnotationChildLink.createRef((PsiModifierListOwner)aClass, (String)anno.fqn(this.myJavaeeType));
        this.myAccessType = PersistentObjectImpl.calculateAccessType(this.myPsiClass);
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    public abstract JamClassMeta<? extends PersistentObjectImpl> getJamMeta();

    protected PsiElementRef<PsiAnnotation> getAnnoRef() {
        return this.myAnno;
    }

    public boolean isValid() {
        try {
            return super.isValid() && Comparing.equal((Object)((Object)((PersistentObjectImpl)this.getJamMeta().getJamElement((PsiModifierListOwner)this.getPsiClass()))), (Object)((Object)this));
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Nullable
    public AccessType getEffectiveAccessType() {
        return (AccessType)ACCESS_VALUE_ATTR_META.getJam(this.getJavaeeAnnotationRef(JpaAnnotationConstants.ACCESS_ANNO), (Enum)this.myAccessType).getValue();
    }

    public GenericValue<PsiClass> getClazz() {
        return AnnotationGenericValue.getInstance((Object)this.getPsiClass(), (PsiAnnotation)((PsiAnnotation)this.getAnnoRef().getPsiElement()), null);
    }

    public List<JamAttributeBase> getAllAttributes() {
        ArrayList<JamAttributeBase> all = new ArrayList<JamAttributeBase>();
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        for (JamMemberMeta meta : PersistenceAttributesProvider.getAllJamMetas()) {
            all.addAll(service.getAnnotatedMembersList(this.myPsiClass, 6, new JamMemberMeta[]{meta}));
        }
        Set annotatedMembers = all.stream().map(base -> base.getPsiMember()).collect(Collectors.toSet());
        for (PsiField field : this.myPsiClass.getFields()) {
            if (annotatedMembers.contains(field) || annotatedMembers.contains(PropertyUtilBase.findGetterForField((PsiField)field)) || field.hasModifierProperty("static") || !JpaUtil.isBasicPersistentAttributeType(field.getType(), false)) continue;
            all.add((JamAttributeBase)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)((Object)new AttributeBaseImpl.BasicAttr((PsiMember)field)), (Object[])new Object[]{field.getContainingFile()})));
        }
        return all;
    }

    @NotNull
    public PersistentObjectModelHelper getObjectModelHelper() {
        PersistentObjectImpl persistentObjectImpl = this;
        if (persistentObjectImpl == null) {
            PersistentObjectImpl.$$$reportNull$$$0(3);
        }
        return persistentObjectImpl;
    }

    @NotNull
    public List<? extends PersistentAttribute> getAttributes() {
        List<JamAttributeBase> list = this.getAllAttributes();
        if (list == null) {
            PersistentObjectImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public PropertyMemberType getDefaultAccessMode() {
        if (this.myDefaultAccessModeValue == null) {
            this.myDefaultAccessModeValue = CachedValuesManager.getManager((Project)this.myPsiClass.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)this.calcDefaultAccessMode(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        }
        return (PropertyMemberType)this.myDefaultAccessModeValue.getValue();
    }

    private PropertyMemberType calcDefaultAccessMode() {
        PersistentObject object;
        AccessType effectiveAccessType = null;
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)this.getPsiElement());
        Iterator iterator = browser.queryPersistentObjectHierarchy((PersistentObject)this).findAll().iterator();
        while (iterator.hasNext() && (effectiveAccessType = (AccessType)ManualModelMergerUtil.findLast((List)((List)ModelMergerUtil.getImplementations((Object)(object = (PersistentObject)iterator.next()), com.intellij.javaee.model.common.persistence.mapping.PersistentObject.class)), o -> o.getEffectiveAccessType(), null)) == null) {
        }
        if (effectiveAccessType != null) {
            return effectiveAccessType == AccessType.FIELD ? PropertyMemberType.FIELD : PropertyMemberType.GETTER;
        }
        PropertyMemberType defaultAccess = (PropertyMemberType)PersistentObjectImpl.getCurrentValueOrDefault(AnnotationGenericValue.nullInstance(), persistencePackageDefaults -> persistencePackageDefaults.getAccess(), this.getPsiClass()).getValue();
        return defaultAccess == null ? PropertyMemberType.GETTER : defaultAccess;
    }

    public boolean isAccessModeFixed() {
        return this.getEffectiveAccessType() != null;
    }

    static <T> GenericValue<T> getCurrentValueOrDefault(GenericValue<T> currentValue, NullableFunction<? super PersistencePackageDefaults, ? extends T> processor, PsiClass psiClass) {
        if (currentValue.getValue() != null) {
            return currentValue;
        }
        if (psiClass == null) {
            return currentValue;
        }
        T value3 = PersistentObjectImpl.getDefaultValue((PsiMember)psiClass, processor);
        if (value3 != null) {
            return ReadOnlyGenericValue.getInstance(value3);
        }
        return currentValue;
    }

    @Nullable
    public static <T> T getDefaultValue(PsiMember psiMember, NullableFunction<? super PersistencePackageDefaults, ? extends T> processor) {
        PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
            PersistencePackageDefaults defaults;
            Object t;
            if (role.getPersistentObject() == null || (t = processor.fun((Object)(defaults = role.getFacet().getPersistenceUnitDefaults(role.getPersistenceUnit())))) == null) continue;
            return (T)t;
        }
        return null;
    }

    @Nullable
    private static AccessType calculateAccessType(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        for (PsiField psiField : aClass.getFields()) {
            if (psiField.hasModifierProperty("static") || psiField.hasModifierProperty("transient") || !PersistentObjectImpl.isJpaAnnotated((PsiMember)psiField)) continue;
            return AccessType.FIELD;
        }
        for (PsiField psiField : aClass.getMethods()) {
            if (!PropertyUtilBase.isSimplePropertyGetter((PsiMethod)psiField) || !PersistentObjectImpl.isJpaAnnotated((PsiMember)psiField)) continue;
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static boolean isJpaAnnotated(PsiMember member) {
        PsiModifierList list = member.getModifierList();
        if (list == null) {
            return false;
        }
        for (PsiAnnotation annotation : list.getAnnotations()) {
            String qName = annotation.getQualifiedName();
            if (qName == null || JpaAnnotationConstants.TRANSIENT_ANNO.isFqn(qName) || !(member instanceof PsiClass) && JpaAnnotationConstants.ACCESS_ANNO.isFqn(qName) || !qName.startsWith(JpaConstants.PERSISTENCE_PACKAGE_PREFIX.javax()) && !qName.startsWith(JpaConstants.PERSISTENCE_PACKAGE_PREFIX.jakarta())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected PsiElementRef<PsiAnnotation> getJavaeeAnnotationRef(@NotNull JavaeeClass javaeeClass) {
        if (javaeeClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(5);
        }
        PsiElementRef<PsiAnnotation> psiElementRef = PersistentObjectImpl.getJavaeeAnnotationRef(javaeeClass, (PsiMember)this.getPsiClass(), this.myJavaeeType);
        if (psiElementRef == null) {
            PersistentObjectImpl.$$$reportNull$$$0(6);
        }
        return psiElementRef;
    }

    public static PsiElementRef<PsiAnnotation> getJavaeeAnnotationRef(@NotNull JavaeeClass javaeeClass, PsiMember psiMember, @NotNull JavaeeType javaeeType) {
        if (javaeeClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(7);
        }
        if (javaeeType == null) {
            PersistentObjectImpl.$$$reportNull$$$0(8);
        }
        return new AnnotationChildLink(javaeeType.equals((Object)JavaeeType.JAVAX) ? javaeeClass.javax() : javaeeClass.jakarta()).createChildRef((PsiElement)psiMember);
    }

    protected boolean isJavax() {
        return this.myJavaeeType.equals((Object)JavaeeType.JAVAX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectModelHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaeeAnnotationRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJavaeeAnnotationRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

