/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.intentions;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.jpa.view.EntityListenerBindingsDialog;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpaEntityListenerBindingsAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JpaEntityListenerBindingsAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JpaEntityListenerBindingsAction.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof PsiJavaFile) || file.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (targetClass == null || !targetClass.isValid() || targetClass.getQualifiedName() == null) {
            return false;
        }
        if (!HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)targetClass).containsRange(offset, offset + 1)) {
            return false;
        }
        PsiDocComment docComment = targetClass.getDocComment();
        if (docComment != null && docComment.getTextRange().containsRange(offset, offset + 1)) {
            return false;
        }
        if (PsiTreeUtil.getChildOfType((PsiElement)targetClass, PsiErrorElement.class) != null) {
            return false;
        }
        String text = JpaEntityListenerBindingsAction.getExplanation(targetClass);
        if (text != null) {
            this.setText(text);
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaMessages.message((String)"intention.persistence.edit.entity.listener.bindings.family", (Object[])new Object[0]);
        if (string == null) {
            JpaEntityListenerBindingsAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    @Nls
    public static String getExplanation(PsiClass psiClass) {
        if (JpaUtil.getFirstPersistenceRoleWithClass(psiClass, EntityListener.class) != null) {
            return JpaMessages.message((String)"intention.persistence.edit.entity.listener.bindings.text", (Object[])new Object[]{psiClass.getName()});
        }
        return null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JpaEntityListenerBindingsAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JpaEntityListenerBindingsAction.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        assert (targetClass != null);
        PersistenceClassRole classRole = JpaUtil.getFirstPersistenceRoleWithClass(targetClass, EntityListener.class);
        EntityListenerBindingsDialog dialog = new EntityListenerBindingsDialog(project, targetClass.getQualifiedName(), classRole.getFacet());
        dialog.show();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/intentions/JpaEntityListenerBindingsAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

