/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.javaee.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.inspections.AbstractUastJpaInspection;
import com.intellij.jpa.model.manipulators.DefaultUserResponse;
import com.intellij.jpa.util.JpaCodeGenerationUtil;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.manipulators.UserResponse;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;

public final class JpaMissingIdInspection
extends AbstractUastJpaInspection {
    @Override
    protected void checkClass(UClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        PersistentObject object = role.getPersistentObject();
        if (object != null && role.getType() == PersistenceClassRoleEnum.ENTITY) {
            JpaMissingIdInspection.checkObjectHasId(aClass, (PersistentEntity)object, role, holder);
        }
    }

    private static void checkObjectHasId(UClass uClass, PersistentEntity object, PersistenceClassRole role, ProblemsHolder holder) {
        PsiElement sourcePsi = UDeclarationKt.getAnchorPsi((UDeclaration)uClass);
        if (sourcePsi == null) {
            return;
        }
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)role.getFacet(), (PersistencePackage)role.getPersistenceUnit(), null);
        CommonProcessors.FindProcessor<PersistentAttribute> idSearcher = new CommonProcessors.FindProcessor<PersistentAttribute>(){

            protected boolean accept(PersistentAttribute persistentAttribute) {
                return persistentAttribute.getAttributeModelHelper().isIdAttribute();
            }
        };
        browser.queryAttributes((PersistentObject)object).forEach((Processor)idSearcher);
        if (idSearcher.isFound()) {
            return;
        }
        holder.registerProblem(sourcePsi, JpaHighlightingMessages.message("persistent.entity.0.should.have.id", object.getName().getValue()), new LocalQuickFix[]{JpaMissingIdInspection.createIdFix(role, uClass)});
    }

    private static LocalQuickFix createIdFix(final PersistenceClassRole role, final UClass uClass) {
        return new IntentionAndQuickFixAction(){

            @NotNull
            public String getName() {
                String string = this.getFamilyName();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            @IntentionFamilyName
            public String getFamilyName() {
                String string = JpaHighlightingMessages.message("quick.fix.name.add.id.attribute", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
                if (project == null) {
                    2.$$$reportNull$$$0(2);
                }
                JpaMissingIdInspection.addIdAttribute(role, uClass);
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/jpa/inspections/JpaMissingIdInspection$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/jpa/inspections/JpaMissingIdInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void addIdAttribute(PersistenceClassRole role, UClass uClass) {
        PersistentObject persistentObject = role.getPersistentObject();
        if (!persistentObject.isValid()) {
            return;
        }
        UserResponse.AttributeInfo attributeInfo = ApplicationManager.getApplication().isUnitTestMode() ? JpaUtil.getTestUserResponse() : new DefaultUserResponse().getAttributeName(role.getPersistentObject(), (PersistentAttributeType)JpaAttributeType.ID, null, role.getFacet().getModelValidator(role.getPersistenceUnit()), JpaHighlightingMessages.message("quick.fix.name.add.id.attribute", new Object[0]), "id");
        if (attributeInfo == null) {
            return;
        }
        Project project = uClass.getJavaPsi().getProject();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        JpaCodeGenerationUtil.createAnnotatedProperty(attributeInfo.name, attributeInfo.type, attributeInfo.fieldAccess, attributeInfo.generated, uClass, project, editor);
    }
}

