/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.importer;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaLibraryCoordinates;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J%\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/jpa/importer/JpaFacetDetector;", "", "()V", "JPA_AUTOCONFIGURED_LIBS", "", "Lcom/intellij/jpa/JpaLibraryCoordinates;", "JPA_AUTOCONFIGURED_LIB_NAMES", "", "", "kotlin.jvm.PlatformType", "JPA_AUTOCONFIGURED_MARKERS", "attachDefaultPersistenceConfig", "", "facet", "Lcom/intellij/jpa/facet/JpaFacet;", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "configureJpaProvider", "", "model", "dependencyContainer", "Lcom/intellij/jpa/importer/JpaFacetDetector$JpaDependencyContainer;", "findJpaImplementation", "Lcom/intellij/jpa/JpaImplementationProvider;", "providers", "", "([Lcom/intellij/jpa/JpaImplementationProvider;Lcom/intellij/jpa/importer/JpaFacetDetector$JpaDependencyContainer;)Lcom/intellij/jpa/JpaImplementationProvider;", "findJpaImplementationByClasspath", "module", "Lcom/intellij/openapi/module/Module;", "javaPsiFacade", "Lcom/intellij/psi/JavaPsiFacade;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasJpaAutoconfiguredLibraries", "isJpaAutoconfiguredLibrary", "externalNamePrefix", "JpaDependencyContainer", "intellij.javaee.jpa.impl"})
public final class JpaFacetDetector {
    private final List<JpaLibraryCoordinates> JPA_AUTOCONFIGURED_LIBS = CollectionsKt.listOf((Object[])new JpaLibraryCoordinates[]{new JpaLibraryCoordinates("org.springframework", "spring-orm"), new JpaLibraryCoordinates("io.micronaut.configuration", "micronaut-hibernate-jpa"), new JpaLibraryCoordinates("io.micronaut.data", "micronaut-data-hibernate-jpa"), new JpaLibraryCoordinates("io.dropwizard", "dropwizard-hibernate"), new JpaLibraryCoordinates("io.quarkus", "quarkus-hibernate-orm"), new JpaLibraryCoordinates("io.helidon.integrations.cdi", "helidon-integrations-cdi-jpa"), new JpaLibraryCoordinates("org.eclipse.persistence", "jakarta.persistence"), new JpaLibraryCoordinates("javax", "javaee-api"), new JpaLibraryCoordinates("javax", "javaee-web-api"), new JpaLibraryCoordinates("javax.persistence", "javax.persistence-api"), new JpaLibraryCoordinates("jakarta.platform", "jakarta.jakartaee-api"), new JpaLibraryCoordinates("jakarta.platform", "jakarta.jakartaee-web-api"), new JpaLibraryCoordinates("jakarta.persistence", "jakarta.persistence-api")});
    private final List<String> JPA_AUTOCONFIGURED_MARKERS = CollectionsKt.listOf((Object[])new String[]{"org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean", "io.micronaut.configuration.hibernate.jpa.condition.EntitiesInPackageCondition", "io.dropwizard.hibernate.HibernateBundle", "io.quarkus.hibernate.orm.runtime.Hibernate", "io.helidon.integrations.cdi.jpa.JtaTransactionSupport"});
    private final Set<String> JPA_AUTOCONFIGURED_LIB_NAMES;

    public final boolean isJpaAutoconfiguredLibrary(@NotNull String externalNamePrefix) {
        Intrinsics.checkNotNullParameter((Object)externalNamePrefix, (String)"externalNamePrefix");
        return this.JPA_AUTOCONFIGURED_LIB_NAMES.contains(externalNamePrefix);
    }

    public final boolean hasJpaAutoconfiguredLibraries(@NotNull JpaDependencyContainer dependencyContainer) {
        Intrinsics.checkNotNullParameter((Object)dependencyContainer, (String)"dependencyContainer");
        for (JpaLibraryCoordinates lib : this.JPA_AUTOCONFIGURED_LIBS) {
            if (!dependencyContainer.hasDependency(lib)) continue;
            return true;
        }
        return false;
    }

    public final void configureJpaProvider(@NotNull JpaFacet facet, @NotNull ModuleRootModel rootModel, @NotNull JpaDependencyContainer dependencyContainer) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)rootModel, (String)"rootModel");
        Intrinsics.checkNotNullParameter((Object)dependencyContainer, (String)"dependencyContainer");
        ExtensionPointName extensionPointName = JpaImplementationProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"JpaImplementationProvider.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"JpaImplementationProvider.EP_NAME.extensionList");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JpaImplementationProvider[] jpaImplementationProviderArray = thisCollection$iv.toArray(new JpaImplementationProvider[0]);
        if (jpaImplementationProviderArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        JpaImplementationProvider[] providers = jpaImplementationProviderArray;
        JpaFacetConfiguration jpaFacetConfiguration = (JpaFacetConfiguration)facet.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)jpaFacetConfiguration, (String)"facet.configuration");
        JpaFacetConfiguration configuration = jpaFacetConfiguration;
        if (configuration.getDefaultJPAProviderName() == null) {
            ConfigFileInfoSet configFileInfoSet = configuration.getDescriptorsConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configFileInfoSet, (String)"configuration.descriptorsConfiguration");
            ConfigFileInfo[] configFileInfoArray = configFileInfoSet.getConfigFileInfos();
            Intrinsics.checkNotNullExpressionValue((Object)configFileInfoArray, (String)"configuration.descriptor\u2026iguration.configFileInfos");
            ConfigFileInfo[] $i$f$toTypedArray2 = configFileInfoArray;
            boolean bl = false;
            if ($i$f$toTypedArray2.length == 0) {
                JpaImplementationProvider suitableProvider = this.findJpaImplementation(providers, dependencyContainer);
                if (suitableProvider != null) {
                    configuration.setDefaultJPAProviderName(suitableProvider.getProviderName());
                }
                ApplicationManager.getApplication().invokeAndWait(new Runnable(this, facet, rootModel){
                    final /* synthetic */ JpaFacetDetector this$0;
                    final /* synthetic */ JpaFacet $facet;
                    final /* synthetic */ ModuleRootModel $rootModel;

                    public final void run() {
                        JpaFacetDetector.access$attachDefaultPersistenceConfig(this.this$0, this.$facet, this.$rootModel);
                        FacetManager.getInstance((Module)this.$facet.getModule()).facetConfigurationChanged((Facet)this.$facet);
                    }
                    {
                        this.this$0 = jpaFacetDetector;
                        this.$facet = jpaFacet;
                        this.$rootModel = moduleRootModel;
                    }
                });
            }
        }
    }

    private final JpaImplementationProvider findJpaImplementation(JpaImplementationProvider[] providers, JpaDependencyContainer dependencyContainer) {
        JpaImplementationProvider suitableProvider = null;
        block0: for (JpaImplementationProvider provider : providers) {
            Iterator iterator = provider.getAutoDetectionCoordinates().iterator();
            while (iterator.hasNext()) {
                JpaLibraryCoordinates providerLib;
                JpaLibraryCoordinates jpaLibraryCoordinates = providerLib = (JpaLibraryCoordinates)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)jpaLibraryCoordinates, (String)"providerLib");
                if (!dependencyContainer.hasDependency(jpaLibraryCoordinates)) continue;
                if (suitableProvider != null) {
                    return null;
                }
                suitableProvider = provider;
                continue block0;
            }
        }
        return suitableProvider;
    }

    public final boolean configureJpaProvider(@NotNull JpaFacet facet, @NotNull ModuleRootModel model) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Module module = model.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"model.module");
        Module module2 = module;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module2.getProject());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.module\u2026AndLibrariesScope(module)");
        GlobalSearchScope scope = globalSearchScope;
        for (String marker : this.JPA_AUTOCONFIGURED_MARKERS) {
            if (javaPsiFacade.findClass(marker, scope) == null) continue;
            JavaPsiFacade javaPsiFacade2 = javaPsiFacade;
            Intrinsics.checkNotNullExpressionValue((Object)javaPsiFacade2, (String)"javaPsiFacade");
            JpaImplementationProvider provider = this.findJpaImplementationByClasspath(module2, javaPsiFacade2, scope);
            if (provider != null) {
                JpaFacetConfiguration jpaFacetConfiguration = (JpaFacetConfiguration)facet.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)jpaFacetConfiguration, (String)"facet.configuration");
                jpaFacetConfiguration.setDefaultJPAProviderName(provider.getProviderName());
                FacetManager.getInstance((Module)facet.getModule()).facetConfigurationChanged((Facet)facet);
                this.attachDefaultPersistenceConfig(facet, model);
            }
            return true;
        }
        return false;
    }

    private final JpaImplementationProvider findJpaImplementationByClasspath(Module module, JavaPsiFacade javaPsiFacade, GlobalSearchScope scope) {
        ExtensionPointName extensionPointName = JpaImplementationProvider.EP_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"JpaImplementationProvider.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"JpaImplementationProvider.EP_NAME.extensionList");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JpaImplementationProvider[] jpaImplementationProviderArray = thisCollection$iv.toArray(new JpaImplementationProvider[0]);
        if (jpaImplementationProviderArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        JpaImplementationProvider[] providers = jpaImplementationProviderArray;
        JpaImplementationProvider suitableProvider = null;
        for (JpaImplementationProvider provider : providers) {
            String providerClassName = provider.getProviderClassName(module);
            if (javaPsiFacade.findClass(providerClassName, scope) == null) continue;
            suitableProvider = provider;
            break;
        }
        return suitableProvider;
    }

    private final void attachDefaultPersistenceConfig(JpaFacet facet, ModuleRootModel rootModel) {
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Stream.concat(rootModel.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE).stream(), rootModel.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE).stream()).flatMap(new Function(fileSystem){
            final /* synthetic */ LocalFileSystem $fileSystem;

            public final Stream<? extends VirtualFile> apply(VirtualFile root) {
                Object object;
                block3: {
                    block2: {
                        VirtualFile virtualFile = root;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
                        String string = virtualFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"root.url");
                        String contentRootUrl = string;
                        StringBuilder stringBuilder = new StringBuilder().append(contentRootUrl).append("/");
                        ConfigFileMetaData configFileMetaData = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA;
                        Intrinsics.checkNotNullExpressionValue((Object)configFileMetaData, (String)"JavaeePersistenceDescrip\u2026PERSISTENCE_XML_META_DATA");
                        StringBuilder stringBuilder2 = stringBuilder.append(configFileMetaData.getDirectoryPath()).append("/");
                        ConfigFileMetaData configFileMetaData2 = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA;
                        Intrinsics.checkNotNullExpressionValue((Object)configFileMetaData2, (String)"JavaeePersistenceDescrip\u2026PERSISTENCE_XML_META_DATA");
                        String descriptorUrl = stringBuilder2.append(configFileMetaData2.getFileName()).toString();
                        File file = new File(VfsUtilCore.urlToPath((String)descriptorUrl));
                        VirtualFile existingFile = this.$fileSystem.refreshAndFindFileByIoFile(file);
                        object = existingFile;
                        if (object == null) break block2;
                        VirtualFile virtualFile2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile2;
                        boolean bl3 = false;
                        object = Stream.of(existingFile);
                        if (object != null) break block3;
                    }
                    object = Stream.empty();
                }
                return object;
            }
            {
                this.$fileSystem = localFileSystem;
            }
        }).findFirst().ifPresent(new Consumer(facet){
            final /* synthetic */ JpaFacet $facet;

            public final void accept(@NotNull VirtualFile existingFile) {
                Intrinsics.checkNotNullParameter((Object)existingFile, (String)"existingFile");
                ConfigFileMetaData metaData = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA;
                ConfigFileInfo fileInfo = new ConfigFileInfo(metaData, existingFile.getUrl());
                JpaFacetConfiguration jpaFacetConfiguration = (JpaFacetConfiguration)this.$facet.getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)jpaFacetConfiguration, (String)"facet.configuration");
                jpaFacetConfiguration.getDescriptorsConfiguration().addConfigFile(fileInfo);
            }
            {
                this.$facet = jpaFacet;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public JpaFacetDetector() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.JPA_AUTOCONFIGURED_LIBS;
        JpaFacetDetector jpaFacetDetector = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JpaLibraryCoordinates jpaLibraryCoordinates = (JpaLibraryCoordinates)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getExternalSystemPrefix();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        jpaFacetDetector.JPA_AUTOCONFIGURED_LIB_NAMES = CollectionsKt.toSet((Iterable)collection);
    }

    public static final /* synthetic */ void access$attachDefaultPersistenceConfig(JpaFacetDetector $this, JpaFacet facet, ModuleRootModel rootModel) {
        $this.attachDefaultPersistenceConfig(facet, rootModel);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jpa/importer/JpaFacetDetector$JpaDependencyContainer;", "", "hasDependency", "", "lib", "Lcom/intellij/jpa/JpaLibraryCoordinates;", "intellij.javaee.jpa.impl"})
    public static interface JpaDependencyContainer {
        public boolean hasDependency(@NotNull JpaLibraryCoordinates var1);
    }
}

