/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.importer;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.jpa.JpaLibraryCoordinates;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.importer.JpaFacetDetector;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J6\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J4\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\fH\u0002J.\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\u001b2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jpa/importer/JpaExternalSystemDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryDependencyData;", "Lcom/intellij/openapi/module/Module;", "()V", "detector", "Lcom/intellij/jpa/importer/JpaFacetDetector;", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "isFacetDetectionDisabled", "", "setupJpaFacet", "module", "externalSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "toExternalNamesIndex", "", "", "intellij.javaee.jpa.impl"})
public final class JpaExternalSystemDataService
extends AbstractProjectDataService<LibraryDependencyData, Module> {
    private final JpaFacetDetector detector = new JpaFacetDetector();

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ProjectKeys.LIBRARY_DEPENDENCY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public void importData(@NotNull Collection<? extends DataNode<LibraryDependencyData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        if (this.isFacetDetectionDisabled(project)) {
            return;
        }
        Map<String, DataNode<LibraryDependencyData>> libraryNamesIndex = this.toExternalNamesIndex(toImport);
        Object object = libraryNamesIndex;
        boolean bl = false;
        Iterator<Map.Entry<String, DataNode<LibraryDependencyData>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Set paths;
            void namePrefix;
            Map.Entry<String, DataNode<LibraryDependencyData>> entry;
            Map.Entry<String, DataNode<LibraryDependencyData>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            DataNode<LibraryDependencyData> node = entry2.getValue();
            if (!this.detector.isJpaAutoconfiguredLibrary((String)namePrefix)) continue;
            Object object2 = node.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"node.data");
            Intrinsics.checkNotNullExpressionValue((Object)((LibraryData)((LibraryDependencyData)object2).getTarget()).getPaths(LibraryPathType.BINARY), (String)"node.data.target.getPaths(LibraryPathType.BINARY)");
            String path = (String)ContainerUtil.getFirstItem((Collection)paths);
            if (path == null) continue;
            Object object3 = node.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"node.data");
            Module module = modelsProvider.findIdeModule(((LibraryDependencyData)object3).getOwnerModule());
            if (module == null) continue;
            Object object4 = node.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"node.data");
            ProjectSystemId projectSystemId = ((LibraryDependencyData)object4).getOwner();
            Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"node.data.owner");
            this.setupJpaFacet(module, modelsProvider, projectSystemId, toImport);
            break;
        }
    }

    private final void setupJpaFacet(Module module, IdeModifiableModelsProvider modelsProvider, ProjectSystemId externalSystemId, Collection<? extends DataNode<LibraryDependencyData>> toImport) {
        FacetType facetType = JpaFacet.getJpaFacetType();
        ModifiableFacetModel modifiableFacetModel = modelsProvider.getModifiableFacetModel(module);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableFacetModel, (String)"modelsProvider.getModifiableFacetModel(module)");
        ModifiableFacetModel facetModel = modifiableFacetModel;
        FacetType facetType2 = facetType;
        Intrinsics.checkNotNullExpressionValue((Object)facetType2, (String)"facetType");
        if (facetModel.getFacetByType(facetType2.getId()) != null) {
            return;
        }
        JpaFacet jpaFacet = (JpaFacet)facetType.createFacet(module, facetType.getDefaultFacetName(), facetType.createDefaultConfiguration(), null);
        Map<String, DataNode<LibraryDependencyData>> libraryNamesIndex = this.toExternalNamesIndex(toImport);
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"modelsProvider.getModifiableRootModel(module)");
        ModifiableRootModel rootModel = modifiableRootModel;
        JpaFacet jpaFacet2 = jpaFacet;
        Intrinsics.checkNotNullExpressionValue((Object)jpaFacet2, (String)"jpaFacet");
        this.detector.configureJpaProvider(jpaFacet2, (ModuleRootModel)rootModel, new JpaFacetDetector.JpaDependencyContainer(libraryNamesIndex){
            final /* synthetic */ Map $libraryNamesIndex;

            public boolean hasDependency(@NotNull JpaLibraryCoordinates lib) {
                Intrinsics.checkNotNullParameter((Object)lib, (String)"lib");
                Map map = this.$libraryNamesIndex;
                String string = lib.getExternalSystemPrefix();
                boolean bl = false;
                Map map2 = map;
                boolean bl2 = false;
                return map2.containsKey(string);
            }
            {
                this.$libraryNamesIndex = $captured_local_variable$0;
            }
        });
        facetModel.addFacet((Facet)jpaFacet, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)externalSystemId));
    }

    private final Map<String, DataNode<LibraryDependencyData>> toExternalNamesIndex(Collection<? extends DataNode<LibraryDependencyData>> toImport) {
        HashMap index = new HashMap(toImport.size());
        for (DataNode<LibraryDependencyData> dataNode : toImport) {
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.data");
            String string = ((LibraryDependencyData)object).getExternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.data.externalName");
            List coords = StringsKt.split$default((CharSequence)string, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (coords.size() < 2) continue;
            String externalSystemPrefix = JpaLibraryCoordinates.toExternalSystemPrefix((String)((String)coords.get(0)), (String)((String)coords.get(1)));
            Map map = index;
            String string2 = externalSystemPrefix;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"externalSystemPrefix");
            map.put(string2, dataNode);
        }
        return index;
    }

    private final boolean isFacetDetectionDisabled(Project project) {
        FrameworkType frameworkType = FrameworkDetectionUtil.findFrameworkTypeForFacetDetector((FacetType)JpaFacet.getJpaFacetType());
        if (frameworkType == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)frameworkType, (String)"FrameworkDetectionUtil.f\u2026etType()) ?: return false");
        FrameworkType frameworkType2 = frameworkType;
        return DetectionExcludesConfiguration.getInstance((Project)project).isExcludedFromDetection(frameworkType2);
    }
}

