/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.jam.JamChief;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaInspectionUtil;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NotNull;

public class RemoveQuickFix
implements LocalQuickFix {
    private final Object myTarget;

    public RemoveQuickFix(Object target) {
        this.myTarget = target;
    }

    @NotNull
    public String getName() {
        String string = JpaHighlightingMessages.message("text.remove.0", JavaeeUtil.getJavaeeObjectDescription((Object)this.myTarget, (Function)FunctionUtil.id()));
        if (string == null) {
            RemoveQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JpaHighlightingMessages.message("intention.family.remove.attribute", new Object[0]);
        if (string == null) {
            RemoveQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation target;
        if (project == null) {
            RemoveQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveQuickFix.$$$reportNull$$$0(3);
        }
        if (this.myTarget instanceof AnnotationGenericValue) {
            target = ((AnnotationGenericValue)this.myTarget).getIdentifyingAnnotation();
        } else if (this.myTarget instanceof DomElement) {
            target = ((DomElement)this.myTarget).getXmlElement();
        } else if (this.myTarget instanceof JamChief) {
            target = ((JamChief)this.myTarget).getPsiElement();
        } else if (this.myTarget instanceof PsiElement) {
            target = (PsiElement)this.myTarget;
        } else {
            return;
        }
        if (target == null || !target.isValid()) {
            return;
        }
        if (descriptor.getStartElement().getContainingFile() != target.getContainingFile()) {
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{target.getContainingFile()}).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).withGlobalUndo().run(() -> RemoveQuickFix.lambda$applyFix$0((PsiElement)target));
        } else {
            try {
                target.delete();
            }
            catch (IncorrectOperationException e) {
                JpaInspectionUtil.LOG.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void lambda$applyFix$0(PsiElement target) throws RuntimeException {
        target.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/RemoveQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/RemoveQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

