/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.jpa.view.JpaView;
import com.intellij.jpa.view.JpaViewPathUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import icons.JavaUltimateIcons;
import java.util.Arrays;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jpa/highlighting/OpenJpaViewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "psiElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/SmartPsiElementPointer;)V", "elementAttribute", "Lcom/intellij/persistence/model/PersistentAttribute;", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/persistence/model/PersistentAttribute;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javaee.jpa.impl"})
public final class OpenJpaViewAction
extends AnAction {
    private final SmartPsiElementPointer<? extends PsiElement> psiElementPointer;
    private final PersistentAttribute elementAttribute;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = this.psiElementPointer.getElement();
        if (psiElement == null) {
            return;
        }
        PsiElement psiElement2 = psiElement;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData(CommonDataKeys.PROJECT) ?: return");
        Project project2 = project;
        if (this.elementAttribute != null) {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread((Object)JpaViewPathUtils.getContainingClassTreePath(psiElement2));
            spreadBuilder.add((Object)this.elementAttribute);
            JpaView.select(project2, true, spreadBuilder.toArray(new Object[spreadBuilder.size()]));
        } else {
            Object[] objectArray = JpaViewPathUtils.getContainingClassTreePath(psiElement2);
            JpaView.select(project2, true, Arrays.copyOf(objectArray, objectArray.length));
        }
    }

    public OpenJpaViewAction(@NotNull SmartPsiElementPointer<? extends PsiElement> psiElementPointer, @Nullable PersistentAttribute elementAttribute) {
        Intrinsics.checkNotNullParameter(psiElementPointer, (String)"psiElementPointer");
        super((Supplier)1.INSTANCE, JavaUltimateIcons.Javaee.JpaFacet);
        this.psiElementPointer = psiElementPointer;
        this.elementAttribute = elementAttribute;
    }

    public OpenJpaViewAction(@NotNull SmartPsiElementPointer<? extends PsiElement> psiElementPointer) {
        Intrinsics.checkNotNullParameter(psiElementPointer, (String)"psiElementPointer");
        this(psiElementPointer, null);
    }
}

