/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.database.psi.DbTable;
import com.intellij.javaee.model.common.persistence.mapping.Entity;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.highlighting.JpaLineMarkerActionsKt;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.text.NameUtilCore;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/highlighting/OpenInDatabaseViewAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "facet", "Lcom/intellij/persistence/facet/PersistenceFacet;", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/persistence/facet/PersistenceFacet;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findTableCandidates", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/ResolveResult;", "psiClass", "Lcom/intellij/psi/PsiClass;", "suggestTableAndSchema", "Lcom/intellij/jpa/highlighting/OpenInDatabaseViewAction$TableCandidateInfo;", "entity", "Lcom/intellij/javaee/model/common/persistence/mapping/Entity;", "update", "TableCandidateInfo", "intellij.javaee.jpa.impl"})
public final class OpenInDatabaseViewAction
extends AnAction {
    private final SmartPsiElementPointer<PsiElement> elementPointer;
    private final PersistenceFacet facet;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = this.elementPointer.getElement();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return;
        }
        PsiClass psiClass2 = psiClass;
        PersistenceClassRole role = JpaLineMarkerActionsKt.findPersistenceRole(psiClass2, PersistenceClassRoleEnum.ENTITY);
        boolean isEnabled = role != null && JpaUtil.isDataSourceSetUp(this.facet, role);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(isEnabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsiElement psiElement = this.elementPointer.getElement();
            if (!(psiElement instanceof PsiClass)) {
                psiElement = null;
            }
            PsiClass psiClass = (PsiClass)psiElement;
            if (psiClass == null) {
                return;
            }
            PsiClass psiClass2 = psiClass;
            ResolveResult resolveResult = (ResolveResult)SequencesKt.firstOrNull(this.findTableCandidates(psiClass2));
            PsiElement $this$castSafelyTo$iv = resolveResult != null ? resolveResult.getElement() : null;
            boolean $i$f$castSafelyTo = false;
            PsiElement psiElement2 = $this$castSafelyTo$iv;
            if (!(psiElement2 instanceof Navigatable)) {
                psiElement2 = null;
            }
            Navigatable navigatable = (Navigatable)psiElement2;
            if (navigatable == null) break block3;
            navigatable.navigate(true);
        }
    }

    private final Sequence<ResolveResult> findTableCandidates(PsiClass psiClass) {
        Entity entity;
        TableCandidateInfo tableCandidateInfo;
        PersistenceClassRole persistenceClassRole = JpaLineMarkerActionsKt.findPersistenceRole(psiClass, PersistenceClassRoleEnum.ENTITY);
        Object object = persistenceClassRole != null ? persistenceClassRole.getPersistentObject() : null;
        if (!(object instanceof Entity)) {
            object = null;
        }
        if ((tableCandidateInfo = this.suggestTableAndSchema(psiClass, entity = (Entity)object)).getTableNameCandidates().isEmpty()) {
            return SequencesKt.emptySequence();
        }
        Collection<DbTable> collection = ORMReferencesUtil.getTableVariants(PersistenceUtil.getDataSources((PsiClass)psiClass), tableCandidateInfo.getSchemaCandidate());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"ORMReferencesUtil\n      \u2026dateInfo.schemaCandidate)");
        Collection<DbTable> tableVariants = collection;
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)tableCandidateInfo.getTableNameCandidates()), (Function1)((Function1)new Function1<String, Sequence<? extends ResolveResult>>(tableVariants){
            final /* synthetic */ Collection $tableVariants;

            @NotNull
            public final Sequence<ResolveResult> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object[] objectArray = ORMReferencesUtil.getDbElementResolveResults(this.$tableVariants, it);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ORMReferencesUtil.getDbE\u2026esults(tableVariants, it)");
                return ArraysKt.asSequence((Object[])objectArray);
            }
            {
                this.$tableVariants = collection;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final TableCandidateInfo suggestTableAndSchema(PsiClass psiClass, Entity entity) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String[] originalClassName;
        Entity entity2 = entity;
        String defaultTableName = entity2 != null && (entity2 = entity2.getTable()) != null && (entity2 = entity2.getTableName()) != null ? entity2.getStringValue() : null;
        String[] stringArray = originalClassName = psiClass.getName();
        boolean bl = false;
        String[] stringArray2 = stringArray;
        if (stringArray == null) {
            stringArray2 = "";
        }
        String[] stringArray3 = NameUtilCore.nameToWords((String)stringArray2);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"NameUtilCore.nameToWords\u2026ginalClassName.orEmpty())");
        stringArray = stringArray3;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var11_10 = $this$filterTo$iv$iv;
        int n = ((void)var11_10).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var11_10[i];
            boolean bl2 = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            CharSequence charSequence = (CharSequence)v3;
            boolean bl3 = false;
            if (!(charSequence.length() > 0 && Character.isLetterOrDigit(StringsKt.first((CharSequence)((CharSequence)it))))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String classNameSnakeCase = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        Entity entity3 = entity;
        String schemaName = entity3 != null && (entity3 = entity3.getTable()) != null && (entity3 = entity3.getSchema()) != null ? (String)entity3.getValue() : null;
        return new TableCandidateInfo(SetsKt.setOfNotNull((Object[])new String[]{defaultTableName, originalClassName, classNameSnakeCase}), schemaName);
    }

    public OpenInDatabaseViewAction(@NotNull SmartPsiElementPointer<PsiElement> elementPointer, @NotNull PersistenceFacet facet) {
        Intrinsics.checkNotNullParameter(elementPointer, (String)"elementPointer");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        super((Supplier)1.INSTANCE, DatabaseIcons.Table);
        this.elementPointer = elementPointer;
        this.facet = facet;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jpa/highlighting/OpenInDatabaseViewAction$TableCandidateInfo;", "", "tableNameCandidates", "", "", "schemaCandidate", "(Ljava/util/Set;Ljava/lang/String;)V", "getSchemaCandidate", "()Ljava/lang/String;", "getTableNameCandidates", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javaee.jpa.impl"})
    private static final class TableCandidateInfo {
        @NotNull
        private final Set<String> tableNameCandidates;
        @Nullable
        private final String schemaCandidate;

        @NotNull
        public final Set<String> getTableNameCandidates() {
            return this.tableNameCandidates;
        }

        @Nullable
        public final String getSchemaCandidate() {
            return this.schemaCandidate;
        }

        public TableCandidateInfo(@NotNull Set<String> tableNameCandidates, @Nullable String schemaCandidate) {
            Intrinsics.checkNotNullParameter(tableNameCandidates, (String)"tableNameCandidates");
            this.tableNameCandidates = tableNameCandidates;
            this.schemaCandidate = schemaCandidate;
        }

        @NotNull
        public final Set<String> component1() {
            return this.tableNameCandidates;
        }

        @Nullable
        public final String component2() {
            return this.schemaCandidate;
        }

        @NotNull
        public final TableCandidateInfo copy(@NotNull Set<String> tableNameCandidates, @Nullable String schemaCandidate) {
            Intrinsics.checkNotNullParameter(tableNameCandidates, (String)"tableNameCandidates");
            return new TableCandidateInfo(tableNameCandidates, schemaCandidate);
        }

        public static /* synthetic */ TableCandidateInfo copy$default(TableCandidateInfo tableCandidateInfo, Set set, String string, int n, Object object) {
            if ((n & 1) != 0) {
                set = tableCandidateInfo.tableNameCandidates;
            }
            if ((n & 2) != 0) {
                string = tableCandidateInfo.schemaCandidate;
            }
            return tableCandidateInfo.copy(set, string);
        }

        @NotNull
        public String toString() {
            return "TableCandidateInfo(tableNameCandidates=" + this.tableNameCandidates + ", schemaCandidate=" + this.schemaCandidate + ")";
        }

        public int hashCode() {
            Set<String> set = this.tableNameCandidates;
            String string = this.schemaCandidate;
            return (set != null ? ((Object)set).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TableCandidateInfo)) break block3;
                    TableCandidateInfo tableCandidateInfo = (TableCandidateInfo)object;
                    if (!Intrinsics.areEqual(this.tableNameCandidates, tableCandidateInfo.tableNameCandidates) || !Intrinsics.areEqual((Object)this.schemaCandidate, (Object)tableCandidateInfo.schemaCandidate)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

