/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.jpa.AttributeNodeNameReference;
import com.intellij.jpa.EntityGraphNameReference;
import com.intellij.jpa.JpaEntityGraphUtils;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.SubgraphNameReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jpa/highlighting/JpaEntityGraphsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkUnresolvedGraphReference", "", "uExpression", "Lorg/jetbrains/uast/UExpression;", "psiLanguageInjectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "reportUnresolvedReference", "psiReference", "Lcom/intellij/psi/PsiReference;", "intellij.javaee.jpa.impl"})
public final class JpaEntityGraphsInspection
extends LocalInspectionTool {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module != null) {
            boolean bl;
            block3: {
                FacetManager facetManager = FacetManager.getInstance((Module)module);
                Intrinsics.checkNotNullExpressionValue((Object)facetManager, (String)"FacetManager.getInstance(module)");
                Facet[] facetArray = facetManager.getAllFacets();
                Intrinsics.checkNotNullExpressionValue((Object)facetArray, (String)"FacetManager.getInstance(module).allFacets");
                Facet[] $this$any$iv = facetArray;
                boolean $i$f$any = false;
                Facet[] facetArray2 = $this$any$iv;
                int n = facetArray2.length;
                for (int i = 0; i < n; ++i) {
                    Facet element$iv;
                    Facet it = element$iv = facetArray2[i];
                    boolean bl2 = false;
                    if (!(it instanceof PersistenceFacet)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                psiElementVisitor = new PsiElementVisitor(this, holder){
                    final /* synthetic */ JpaEntityGraphsInspection this$0;
                    final /* synthetic */ ProblemsHolder $holder;

                    public void visitElement(@NotNull PsiElement element) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            if (!(element instanceof PsiLanguageInjectionHost)) {
                                return;
                            }
                            PsiElement $this$toUElementOfType$iv = element;
                            boolean $i$f$toUElementOfType = false;
                            UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
                            if (uExpression == null) break block1;
                            UExpression uExpression2 = uExpression;
                            boolean bl = false;
                            boolean bl2 = false;
                            UExpression $this$run = uExpression2;
                            boolean bl3 = false;
                            JpaEntityGraphsInspection.access$checkUnresolvedGraphReference(this.this$0, $this$run, (PsiLanguageInjectionHost)element, this.$holder);
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$holder = $captured_local_variable$1;
                    }
                };
                return psiElementVisitor;
            }
        }
        PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
        psiElementVisitor = psiElementVisitor2;
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"PsiElementVisitor.EMPTY_VISITOR");
        return psiElementVisitor;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkUnresolvedGraphReference(UExpression uExpression, PsiLanguageInjectionHost psiLanguageInjectionHost, ProblemsHolder holder) {
        block5: {
            Object v1;
            PsiReference[] psiReferenceArray;
            block4: {
                void $this$singleOrNull$iv;
                if (!JpaEntityGraphUtils.GRAPH_RELATED_PATTERNS.accepts((Object)uExpression, UastPatterns.withRequestedPsi((PsiElement)((PsiElement)psiLanguageInjectionHost)))) {
                    return;
                }
                PsiReference[] psiReferenceArray2 = psiLanguageInjectionHost.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray2, (String)"psiLanguageInjectionHost.references");
                psiReferenceArray = psiReferenceArray2;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                void var8_10 = $this$singleOrNull$iv;
                int n = ((void)var8_10).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = var8_10[i];
                    boolean bl = false;
                    if (!(it instanceof EntityGraphNameReference || it instanceof AttributeNodeNameReference || it instanceof SubgraphNameReference)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block4;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            if (v1 == null) break block5;
            psiReferenceArray = v1;
            boolean bl = false;
            boolean bl2 = false;
            PsiReference[] $this$run = psiReferenceArray;
            boolean bl3 = false;
            if ($this$run.resolve() == null) {
                this.reportUnresolvedReference((PsiReference)$this$run, psiLanguageInjectionHost, holder);
            }
        }
    }

    private final void reportUnresolvedReference(PsiReference psiReference, PsiLanguageInjectionHost psiLanguageInjectionHost, ProblemsHolder holder) {
        String string;
        PsiReference psiReference2 = psiReference;
        if (psiReference2 instanceof EntityGraphNameReference) {
            string = JpaMessages.message((String)"inspection.javaee.persistence.graph.name.unresolved.message", (Object[])new Object[]{((EntityGraphNameReference)psiReference).getValue()});
        } else if (psiReference2 instanceof AttributeNodeNameReference) {
            string = JpaMessages.message((String)"inspection.javaee.persistence.attribute.node.unresolved.message", (Object[])new Object[]{((AttributeNodeNameReference)psiReference).getValue()});
        } else if (psiReference2 instanceof SubgraphNameReference) {
            string = JpaMessages.message((String)"inspection.javaee.persistence.subgraph.name.unresolved.message", (Object[])new Object[]{((SubgraphNameReference)psiReference).getValue()});
        } else {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"when (psiReference) {\n  \u2026     else -> return\n    }");
        String message = string;
        TextRange textRange = psiReference.getRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"psiReference.rangeInElement");
        TextRange referenceRange = textRange;
        TextRange textRange2 = referenceRange.isEmpty() && referenceRange.getStartOffset() == 1 && Intrinsics.areEqual((Object)"\"\"", (Object)psiLanguageInjectionHost.getText()) ? TextRange.create((int)0, (int)2) : referenceRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"if (referenceRange.isEmp\u2026se\n        referenceRange");
        TextRange effectiveRange = textRange2;
        holder.registerProblem((PsiElement)psiLanguageInjectionHost, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, effectiveRange, new LocalQuickFix[0]);
    }

    public static final /* synthetic */ void access$checkUnresolvedGraphReference(JpaEntityGraphsInspection $this, UExpression uExpression, PsiLanguageInjectionHost psiLanguageInjectionHost, ProblemsHolder holder) {
        $this.checkUnresolvedGraphReference(uExpression, psiLanguageInjectionHost, holder);
    }
}

