/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.daemon.GutterName;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaEntityLineMarkerActionsProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaRelationshipMemberReferencesUtil;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.highlighting.AssignDatasourceAction;
import com.intellij.jpa.highlighting.AssignStrategyAction;
import com.intellij.jpa.highlighting.FindUsagesOfAttributeAction;
import com.intellij.jpa.highlighting.NavigateToTargetAction;
import com.intellij.jpa.highlighting.OpenInDatabaseViewAction;
import com.intellij.jpa.highlighting.OpenJpaViewAction;
import com.intellij.jpa.highlighting.RunQueryInJpaConsoleAction;
import com.intellij.jpa.highlighting.ShowDiagramAction;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import icons.JavaUltimateIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastUtils;

public final class JpaClassLineMarkerProvider
extends LineMarkerProviderDescriptor {
    private static final ExtensionPointName<JpaEntityLineMarkerActionsProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.javaee.jpa.entityLineMarkerActionsProvider");

    @NotNull
    @GutterName
    public String getName() {
        String string = JpaMessages.message((String)"jpa.gutter.name", (Object[])new Object[0]);
        if (string == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Javaee.PersistenceEntity;
        if (icon == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        if (elements == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(4);
        }
        for (PsiElement psiElement : elements) {
            ProgressManager.checkCanceled();
            JpaClassLineMarkerProvider.annotate(psiElement, result);
        }
    }

    public static void annotate(PsiElement element, Collection<? super LineMarkerInfo<?>> result) {
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)element);
        if (uParent == null) {
            return;
        }
        PsiElement psiParent = uParent.getJavaPsi();
        if (psiParent == null) {
            return;
        }
        if (uParent instanceof UClass) {
            PersistenceClassRole[] roles = JpaClassLineMarkerProvider.getPersistenceRolesFor(((UClass)uParent).getJavaPsi());
            if (roles.length != 0) {
                result.addAll(JpaClassLineMarkerProvider.createClassLineMarkerInfo((UClass)uParent, roles));
            }
        } else if (uParent instanceof UParameter) {
            UMethod parentMethod = (UMethod)UastUtils.getParentOfType((UElement)uParent, UMethod.class);
            if (parentMethod == null || !parentMethod.isConstructor()) {
                return;
            }
            List<PersistentAttribute> attributes = JpaClassLineMarkerProvider.collectAttributesFromAccessingMethods(element);
            if (attributes.isEmpty()) {
                attributes = JpaClassLineMarkerProvider.collectAttributesFromCorrespondingFields((UParameter)uParent);
            }
            if (!attributes.isEmpty()) {
                ContainerUtil.addIfNotNull(result, JpaClassLineMarkerProvider.createAttributeLineMarkerInfo(uParent, attributes, false));
            }
        } else if (uParent instanceof UField || uParent instanceof UMethod) {
            UClass containingClass = UastUtils.getContainingUClass((UElement)uParent);
            if (containingClass == null) {
                return;
            }
            PsiClass containingPsiClass = containingClass.getJavaPsi();
            if (JpaClassLineMarkerProvider.getPersistenceRolesFor(containingPsiClass).length == 0) {
                return;
            }
            List<PersistentAttribute> attributes = JpaClassLineMarkerProvider.getPersistentAttributesFor((PsiMember)psiParent);
            if (attributes.isEmpty() && PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) == null) {
                attributes = JpaClassLineMarkerProvider.collectAttributesFromAccessingMethods(element);
                ContainerUtil.addIfNotNull(result, JpaClassLineMarkerProvider.createAttributeLineMarkerInfo(uParent, attributes, false));
                return;
            }
            ContainerUtil.addIfNotNull(result, JpaClassLineMarkerProvider.createAttributeLineMarkerInfo(uParent, attributes, false));
        }
    }

    public static PersistenceClassRole[] getPersistenceRolesFor(PsiClass psiClass) {
        return (PersistenceClassRole[])CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static List<PersistentAttribute> collectAttributesFromCorrespondingFields(UParameter uParameter) {
        return JpaUtil.getCorrespondingFieldsFor(uParameter).stream().findAny().map(field -> JpaClassLineMarkerProvider.getPersistentAttributesFor(field)).orElseGet(ContainerUtil::emptyList);
    }

    private static List<PersistentAttribute> collectAttributesFromAccessingMethods(PsiElement element) {
        return JpaUtil.getAccessingMethodsFor(element).stream().flatMap(method -> JpaClassLineMarkerProvider.getPersistentAttributesFor(method).stream()).collect(Collectors.toList());
    }

    private static List<PersistentAttribute> getPersistentAttributesFor(PsiMember member) {
        return PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member);
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<?> createAttributeLineMarkerInfo(UElement element, List<? extends PersistentAttribute> attributes, boolean shouldBeAnnotated) {
        UElement uAnchor;
        if (shouldBeAnnotated && !JpaUtil.hasJpaAnnotation(element)) {
            return null;
        }
        UElement uElement = uAnchor = element instanceof UDeclaration ? ((UDeclaration)element).getUastAnchor() : element;
        if (uAnchor == null) {
            return null;
        }
        PsiElement sourcePsi = uAnchor.getSourcePsi();
        PsiElement javaPsi = element.getJavaPsi();
        if (sourcePsi == null || javaPsi == null) {
            return null;
        }
        Collection<CommonModelElement> targets = JpaRelationshipMemberReferencesUtil.collectAttributeTargets(element, attributes);
        PersistentAttribute attribute = (PersistentAttribute)ContainerUtil.getFirstItem(attributes);
        if (attribute == null) {
            return null;
        }
        Icon icon = ElementPresentationManager.getIcon((Object)attribute);
        return JpaClassLineMarkerProvider.createAttributeMaker(sourcePsi, javaPsi, targets, JpaClassLineMarkerProvider.mapAttributeIcon(icon), attribute);
    }

    private static Collection<LineMarkerInfo<?>> createClassLineMarkerInfo(UClass uClass, PersistenceClassRole[] roles) {
        UElement anchor = uClass.getUastAnchor();
        if (anchor == null) {
            return Collections.emptyList();
        }
        PsiElement sourcePsi = anchor.getSourcePsi();
        if (sourcePsi == null) {
            return Collections.emptyList();
        }
        PersistenceClassRole role = (PersistenceClassRole)ArrayUtil.getFirstElement((Object[])roles);
        if (role == null) {
            return Collections.emptyList();
        }
        Collection<? extends CommonModelElement> targets = JpaClassLineMarkerProvider.collectClassTargets(roles);
        if (targets.isEmpty()) {
            return Collections.singletonList(JpaClassLineMarkerProvider.createEntityMarker(sourcePsi, uClass, role));
        }
        return Collections.singletonList(JpaClassLineMarkerProvider.createAttributeMaker(sourcePsi, (PsiElement)uClass.getJavaPsi(), targets, JpaClassLineMarkerProvider.mapClassIcon(role.getIcon()), null));
    }

    private static Icon mapClassIcon(Icon icon) {
        if (icon == AllIcons.Javaee.PersistenceEntity) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceEntity;
        }
        if (icon == JavaUltimateIcons.Javaee.PersistenceMappedSuperclass) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceMappedSuperclass;
        }
        if (icon == JavaUltimateIcons.Javaee.PersistenceEmbeddable) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceEmbeddable;
        }
        return icon;
    }

    @NotNull
    private static LineMarkerInfo<PsiElement> createEntityMarker(PsiElement sourcePsi, UClass uClass, PersistenceClassRole role) {
        final SmartPsiElementPointer classPointer = UtilsKt.createSmartPointer((PsiElement)uClass.getJavaPsi());
        final JpaFacet facet = JpaUtil.getJpaFacet(ModuleUtilCore.findModuleForFile((PsiFile)sourcePsi.getContainingFile()));
        return new LineMarkerInfo<PsiElement>(sourcePsi, sourcePsi.getTextRange(), JpaClassLineMarkerProvider.mapClassIcon(role.getIcon()), element -> null, null, GutterIconRenderer.Alignment.RIGHT, JpaMessages.messagePointer((String)"jpa.composite.entity.gutter.name", (Object[])new Object[0])){

            public GutterIconRenderer createGutterRenderer() {
                return JpaClassLineMarkerProvider.createPopupRenderer(this, () -> JpaClassLineMarkerProvider.createEntityActions(facet, (SmartPsiElementPointer<PsiElement>)classPointer));
            }
        };
    }

    private static RelatedItemLineMarkerInfo<?> createAttributeMaker(@NotNull PsiElement anchor, @NotNull PsiElement javaPsi, final Collection<? extends CommonModelElement> targets, Icon icon, final PersistentAttribute attribute) {
        if (anchor == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (javaPsi == null) {
            JpaClassLineMarkerProvider.$$$reportNull$$$0(6);
        }
        final SmartPsiElementPointer attributeElementPointer = UtilsKt.createSmartPointer((PsiElement)javaPsi);
        final SmartPsiElementPointer anchorElementPointer = UtilsKt.createSmartPointer((PsiElement)javaPsi);
        return new RelatedItemLineMarkerInfo<PsiElement>(anchor, anchor.getTextRange(), icon, element -> null, null, GutterIconRenderer.Alignment.RIGHT, () -> targets.stream().flatMap(it -> GotoRelatedItem.createItems(Arrays.asList(JamCommonUtil.getTargetPsiElements((CommonModelElement)it))).stream()).collect(Collectors.toList())){

            public GutterIconRenderer createGutterRenderer() {
                return JpaClassLineMarkerProvider.createPopupRenderer((LineMarkerInfo<PsiElement>)this, () -> JpaClassLineMarkerProvider.createAttributeActions((SmartPsiElementPointer<PsiElement>)attributeElementPointer, (SmartPsiElementPointer<PsiElement>)anchorElementPointer, targets, attribute));
            }
        };
    }

    private static Icon mapAttributeIcon(Icon icon) {
        if (icon == JavaUltimateIcons.Javaee.PersistenceId) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceId;
        }
        if (icon == JavaUltimateIcons.Javaee.PersistenceIdRelationship) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceIdRelationship;
        }
        if (icon == JavaUltimateIcons.Javaee.PersistenceRelationship) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceRelationship;
        }
        if (icon == JavaUltimateIcons.Javaee.PersistenceAttribute) {
            return JavaUltimateIcons.Javaee.Gutter.PersistenceAttribute;
        }
        return icon;
    }

    private static ActionGroup createEntityActions(JpaFacet facet, SmartPsiElementPointer<PsiElement> elementPointer) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OpenJpaViewAction(elementPointer));
        if (facet != null) {
            AnAction assignNamingStrategyOriginal;
            group.add((AnAction)new OpenInDatabaseViewAction(elementPointer, (PersistenceFacet)facet));
            group.add((AnAction)new RunQueryInJpaConsoleAction(elementPointer, (PersistenceFacet)facet));
            AnAction erDiagramAction = actionManager.getAction("OpenPersistenceERDiagramAction");
            if (erDiagramAction != null) {
                group.add((AnAction)new ShowDiagramAction(erDiagramAction, elementPointer, (PersistenceFacet)facet));
            }
            group.add((AnAction)new Separator());
            AnAction assignDataSourceOriginal = actionManager.getAction("Jpa.AssignDataSources");
            if (assignDataSourceOriginal != null) {
                group.add((AnAction)new AssignDatasourceAction(assignDataSourceOriginal, elementPointer, (PersistenceFacet)facet));
            }
            if ((assignNamingStrategyOriginal = actionManager.getAction("Hibernate.SessionFactorySettings")) != null) {
                group.add((AnAction)new AssignStrategyAction(assignNamingStrategyOriginal, elementPointer, (PersistenceFacet)facet));
            }
        }
        EP_NAME.forEachExtensionSafe(provider -> group.addAll(provider.getEntityActions(elementPointer, facet)));
        return group;
    }

    private static ActionGroup createAttributeActions(SmartPsiElementPointer<PsiElement> attributePointer, SmartPsiElementPointer<PsiElement> anchorPointer, Collection<? extends CommonModelElement> targets, PersistentAttribute attribute) {
        DefaultActionGroup group = new DefaultActionGroup();
        for (CommonModelElement commonModelElement : targets) {
            PsiElement psiElement = commonModelElement.getIdentifyingPsiElement();
            if (!(psiElement instanceof Navigatable)) continue;
            group.add((AnAction)new NavigateToTargetAction((SmartPsiElementPointer<PsiElement>)UtilsKt.createSmartPointer((PsiElement)psiElement)));
        }
        if (group.getChildrenCount() > 0) {
            group.add((AnAction)new Separator());
        }
        group.add((AnAction)new OpenJpaViewAction(attributePointer, attribute));
        group.add((AnAction)new FindUsagesOfAttributeAction(attributePointer, anchorPointer));
        EP_NAME.forEachExtensionSafe(provider -> group.addAll(provider.getAttributeActions(attributePointer, anchorPointer, attribute)));
        return group;
    }

    private static Collection<? extends CommonModelElement> collectClassTargets(PersistenceClassRole[] roles) {
        HashSet<CommonModelElement> result = new HashSet<CommonModelElement>();
        for (PersistenceClassRole role : roles) {
            Object element = role.getPersistentObject() != null ? role.getPersistentObject() : role.getEntityListener();
            DomElement domElement = (DomElement)ModelMergerUtil.getImplementation((Object)element, DomElement.class);
            if (domElement == null) continue;
            result.add((CommonModelElement)domElement);
        }
        return result;
    }

    private static GutterIconRenderer createPopupRenderer(LineMarkerInfo<PsiElement> info, final Supplier<ActionGroup> popupFactory) {
        return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(info){

            public AnAction getClickAction() {
                return null;
            }

            public boolean isNavigateAction() {
                return true;
            }

            public ActionGroup getPopupMenuActions() {
                return (ActionGroup)popupFactory.get();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaClassLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeMaker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

