/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.javaee.model.common.persistence.mapping.AttributeType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.highlighting.JpaModelValidatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentAttributeType;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.RelationshipType;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nls;

public class HibernateModelValidator
extends JpaModelValidatorBase {
    public HibernateModelValidator(PersistenceModelBrowser browser) {
        super(browser);
    }

    @Nls
    public String getAttributeTypeProblem(JavaTypeInfo typeInfo, PersistentAttributeType attributeType, boolean isLob) {
        if (typeInfo.baseType instanceof PsiClassType && ((PsiClassType)typeInfo.baseType).resolve() == null) {
            return JpaHighlightingMessages.message("unable.to.resolve", typeInfo.baseType.getPresentableText());
        }
        if (isLob) {
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)typeInfo.baseType);
            if (psiClass != null) {
                PsiClass serializableClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.io.Serializable", ProjectScope.getAllScope((Project)psiClass.getProject()));
                if (!(psiClass.isInterface() || serializableClass == null || psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)serializableClass) || psiClass.isInheritor(serializableClass, true))) {
                    return JpaHighlightingMessages.message("attribute.should.be.interface.or.serializable", attributeType.getTypeName());
                }
            }
            if (this.doesAttributeReferenceMappedClasses(typeInfo)) {
                return JpaHighlightingMessages.message("attribute.should.not.reference.mapped.classes", attributeType.getTypeName());
            }
        }
        return this.getAttributeTypeProblem(attributeType, typeInfo, isLob);
    }

    @Override
    @Nls
    public String getRelationshipProblem(PersistentRelationshipAttribute source, PersistentRelationshipAttribute target) {
        RelationshipType targetType;
        RelationshipType sourceType = source.getAttributeModelHelper().getRelationshipType();
        if (sourceType.corresponds(targetType = target.getAttributeModelHelper().getRelationshipType())) {
            return null;
        }
        if (sourceType == RelationshipType.ONE_TO_ONE && targetType == RelationshipType.MANY_TO_ONE && HibernateModelValidator.isUnique(target) || targetType == RelationshipType.ONE_TO_ONE && sourceType == RelationshipType.MANY_TO_ONE && HibernateModelValidator.isUnique(source)) {
            return null;
        }
        String targetAttributeTypeName = AttributeType.getAttributeType((PersistentAttribute)target).getTypeName();
        String sourceAttributeTypeName = AttributeType.getAttributeType((PersistentAttribute)source).getTypeName();
        return JpaHighlightingMessages.message("attribute.opposite.type.incorrect", sourceAttributeTypeName, targetAttributeTypeName, target.getName().getValue());
    }

    private static boolean isUnique(PersistentRelationshipAttribute target) {
        XmlTag tag = target.getXmlTag();
        XmlAttribute unique = tag == null ? null : tag.getAttribute("unique");
        return unique != null && "true".equals(unique.getValue());
    }
}

