/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.highlighting.JpaLineMarkerActionsKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.awt.RelativePoint;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jpa/highlighting/FindUsagesOfAttributeAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "javaPsiPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "anchorPointer", "(Lcom/intellij/psi/SmartPsiElementPointer;Lcom/intellij/psi/SmartPsiElementPointer;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javaee.jpa.impl"})
public final class FindUsagesOfAttributeAction
extends AnAction {
    private final SmartPsiElementPointer<PsiElement> javaPsiPointer;
    private final SmartPsiElementPointer<PsiElement> anchorPointer;

    public void actionPerformed(@NotNull AnActionEvent e) {
        RelativePoint relativePoint;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiElement anchor = this.anchorPointer.getElement();
        if (editor != null && anchor != null) {
            editor.getCaretModel().moveToOffset(anchor.getTextOffset());
            relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        } else {
            relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        }
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"if (editor != null && an\u2026upLocation(e.dataContext)");
        RelativePoint bestPositionForPopup = relativePoint;
        PsiElement psiElement = JpaLineMarkerActionsKt.substituteUsagesTarget(this.javaPsiPointer);
        if (psiElement == null) {
            return;
        }
        PsiElement substituteUsagesTarget = psiElement;
        ShowUsagesAction.startFindUsages((PsiElement)substituteUsagesTarget, (RelativePoint)bestPositionForPopup, (Editor)editor);
    }

    public FindUsagesOfAttributeAction(final @NotNull SmartPsiElementPointer<PsiElement> javaPsiPointer, @NotNull SmartPsiElementPointer<PsiElement> anchorPointer) {
        Intrinsics.checkNotNullParameter(javaPsiPointer, (String)"javaPsiPointer");
        Intrinsics.checkNotNullParameter(anchorPointer, (String)"anchorPointer");
        super(new Supplier(){

            public final String get() {
                PsiElement $this$castSafelyTo$iv = JpaLineMarkerActionsKt.substituteUsagesTarget((SmartPsiElementPointer<PsiElement>)javaPsiPointer);
                boolean $i$f$castSafelyTo = false;
                PsiElement psiElement = $this$castSafelyTo$iv;
                if (!(psiElement instanceof PsiNamedElement)) {
                    psiElement = null;
                }
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
                String name = psiNamedElement != null ? psiNamedElement.getName() : null;
                return name != null ? JpaMessages.message((String)"action.Jpa.FindUsagesOf0", (Object[])new Object[]{name}) : JpaMessages.message((String)"action.Jpa.FindUsages", (Object[])new Object[0]);
            }
        }, AllIcons.Actions.Find);
        this.javaPsiPointer = javaPsiPointer;
        this.anchorPointer = anchorPointer;
    }
}

