/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.generation.ui.DatabaseRelationshipData;
import com.intellij.jpa.generation.ui.DatabaseRelationshipRolePanel;
import com.intellij.jpa.generation.ui.DatabaseSchemaImportDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxCellEditor;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseRelationshipDialog
extends DialogWrapper {
    private final Project myProject;
    private final PsiNameHelper myPsiNameHelper;
    private final DatabaseRelationshipData myData;
    private final DatabaseSchemaImportDialog myDatabaseSchemaImportDialog;
    private final DatabaseRelationshipRolePanel mySource;
    private final DatabaseRelationshipRolePanel myTarget;
    private TableView<DatabaseRelationshipData.Join> myTableView;
    private DasTable myJoinTableSaved;
    private final ArrayList<DatabaseRelationshipData.Join> myJoins;
    private JPanel myPanel;
    private JComboBox<DasTable> myCbJoinTable;
    private JPanel mySourcePanel;
    private JPanel myTargetPanel;
    private JPanel myTablePanel;
    private JCheckBox myJoinTableCheckBox;

    public DatabaseRelationshipDialog(Project project, @Nls String title, DatabaseRelationshipData data, DatabaseSchemaImportDialog databaseSchemaImportDialog) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myJoins = new ArrayList();
        this.myProject = project;
        this.myPsiNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        this.myData = data;
        this.myDatabaseSchemaImportDialog = databaseSchemaImportDialog;
        this.myJoinTableSaved = (DasTable)DasUtil.getTables((DasDataSource)databaseSchemaImportDialog.getDatasource()).first();
        this.mySource = new MyDatabaseRelationshipRolePanel(this.myData.getSource());
        this.myTarget = new MyDatabaseRelationshipRolePanel(this.myData.getTarget());
        this.mySource.setOpposite(this.myTarget);
        this.myTarget.setOpposite(this.mySource);
        this.mySource.setTableEditable(false);
        this.initControls();
        this.setTitle(title);
        this.init();
        this.updateControls();
    }

    protected String getHelpId() {
        return "reference.importDatabaseSchema.addRelationship";
    }

    protected ValidationInfo doValidate() {
        String message = this.getDialogErrorText();
        if (message != null) {
            return new ValidationInfo(message);
        }
        return null;
    }

    protected void doOKAction() {
        this.commit();
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTarget.getPreferredFocusedComponent();
    }

    private void updateControls() {
        boolean joinTableRequired;
        this.mySource.updateControls();
        this.myTarget.updateControls();
        boolean wasEnabled = this.myCbJoinTable.isEnabled();
        boolean bl = joinTableRequired = this.mySource.getContainerType() != null && this.myTarget.getContainerType() != null;
        if (joinTableRequired) {
            this.myJoinTableCheckBox.setSelected(true);
        }
        this.myJoinTableCheckBox.setEnabled(!joinTableRequired);
        boolean joinTableEnabled = this.myJoinTableCheckBox.isSelected();
        if (wasEnabled) {
            this.myJoinTableSaved = (DasTable)this.myCbJoinTable.getSelectedItem();
        }
        if (joinTableEnabled != wasEnabled) {
            this.myCbJoinTable.setEnabled(joinTableEnabled);
            if (wasEnabled) {
                this.myCbJoinTable.setSelectedItem(null);
            } else if (this.myCbJoinTable.getItemCount() > 0) {
                if (this.myJoinTableSaved == null) {
                    this.myJoinTableSaved = this.myCbJoinTable.getItemAt(0);
                }
                this.myCbJoinTable.setSelectedItem(this.myJoinTableSaved);
            }
            int selection = this.myTableView.getSelectedRow();
            this.myTableView.setModelAndUpdateColumns(new ListTableModel(this.createColumnInfos(), this.myJoins, 0));
            TableUtil.selectRows((JTable)this.myTableView.getComponent(), (int[])new int[]{selection});
        }
        boolean updateRows = false;
        for (DatabaseRelationshipData.Join join : this.myJoins) {
            if (join.getSource() != null && join.getSource().getTable() != this.mySource.getTable()) {
                join.setSource(null);
                updateRows = true;
            }
            if (join.getSourceJoin() != null && join.getSourceJoin().getTable() != this.myCbJoinTable.getSelectedItem()) {
                join.setSourceJoin(null);
                updateRows = true;
            }
            if (join.getTargetJoin() != null && join.getTargetJoin().getTable() != this.myCbJoinTable.getSelectedItem()) {
                join.setTargetJoin(null);
                updateRows = true;
            }
            if (join.getTarget() == null || join.getTarget().getTable() == this.myTarget.getTable()) continue;
            join.setTarget(null);
            updateRows = true;
        }
        if (updateRows) {
            int selection = this.myTableView.getSelectedRow();
            ((ListTableModel)this.myTableView.getModel()).fireTableDataChanged();
            TableUtil.selectRows((JTable)this.myTableView.getComponent(), (int[])new int[]{selection});
        }
        String targetEntityName = this.myDatabaseSchemaImportDialog.getEntityName(this.myTarget.getTable());
        ((TitledBorder)this.myTargetPanel.getBorder()).setTitle(JpaMessages.message((String)"border.persistence.relationship.target", (Object[])new Object[]{targetEntityName}));
        this.myTargetPanel.repaint();
    }

    public DatabaseRelationshipData getData() {
        return this.myData;
    }

    private void initControls() {
        this.mySourcePanel.add(this.mySource.getComponent());
        this.myTargetPanel.add(this.myTarget.getComponent());
        ((TitledBorder)this.mySourcePanel.getBorder()).setTitle(JpaMessages.message((String)"border.persistence.relationship.source", (Object[])new Object[]{this.myDatabaseSchemaImportDialog.getEntityName(this.myData.getSource().getTable())}));
        ((TitledBorder)this.myTargetPanel.getBorder()).setTitle(JpaMessages.message((String)"border.persistence.relationship.target", (Object[])new Object[]{this.myDatabaseSchemaImportDialog.getEntityName(this.myData.getTarget().getTable())}));
        SortedComboBoxModel tableModel = new SortedComboBoxModel(DatabaseSchemaImportDialog.TABLE_COMPARATOR);
        for (DasTable tableData : DasUtil.getTables((DasDataSource)this.myDatabaseSchemaImportDialog.getDatasource())) {
            tableModel.add((Object)tableData);
        }
        this.myCbJoinTable.setModel((ComboBoxModel<DasTable>)tableModel);
        this.myCbJoinTable.setRenderer((ListCellRenderer<DasTable>)SimpleListCellRenderer.create((String)"", QNameUtil::getQualifiedName));
        this.myCbJoinTable.setEnabled(false);
        this.myJoinTableSaved = this.myData.getJoinTable();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DatabaseRelationshipDialog.this.updateControls();
            }
        };
        this.myCbJoinTable.addItemListener(itemListener);
        this.myJoinTableCheckBox.addItemListener(itemListener);
        this.myJoins.addAll(this.myData.getJoins());
        this.myTableView = new TableView(new ListTableModel(this.createColumnInfos(), this.myJoins, 0));
        this.myTablePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTableView.getComponent()), "Center");
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(new AnAction(JpaMessages.message((String)"action.text.add.join.column", (Object[])new Object[0]), null, IconUtil.getAddIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DatabaseRelationshipDialog.this.myJoins.add(new DatabaseRelationshipData.Join(null, null, null, null));
                ((ListTableModel)DatabaseRelationshipDialog.this.myTableView.getModel()).fireTableDataChanged();
                TableUtil.selectRows((JTable)DatabaseRelationshipDialog.this.myTableView.getComponent(), (int[])new int[]{DatabaseRelationshipDialog.this.myJoins.size() - 1});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/generation/ui/DatabaseRelationshipDialog$2", "actionPerformed"));
            }
        });
        actionGroup.add(new AnAction(JpaMessages.message((String)"action.text.remove.join.column", (Object[])new Object[0]), null, IconUtil.getRemoveIcon()){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                boolean enabled = DatabaseRelationshipDialog.this.myTableView.getSelectedRow() >= 0;
                e.getPresentation().setEnabled(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                int index = DatabaseRelationshipDialog.this.myTableView.getSelectedRow();
                DatabaseRelationshipDialog.this.myJoins.remove(index);
                ((ListTableModel)DatabaseRelationshipDialog.this.myTableView.getModel()).fireTableDataChanged();
                TableUtil.selectRows((JTable)DatabaseRelationshipDialog.this.myTableView.getComponent(), (int[])new int[]{Math.min(index, DatabaseRelationshipDialog.this.myJoins.size() - 1)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/jpa/generation/ui/DatabaseRelationshipDialog$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)actionGroup, true).getComponent();
        toolbar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), toolbar.getBorder()));
        this.myTablePanel.add((Component)toolbar, "North");
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    @Nls
    public String getDialogErrorText() {
        boolean manyToMany;
        if (!this.myPsiNameHelper.isIdentifier(this.mySource.getAttributeName(), LanguageLevel.HIGHEST)) {
            return JpaMessages.message((String)"db.schema.import.not.identifier", (Object[])new Object[]{this.mySource.getAttributeName()});
        }
        if (this.myTarget.getAttributeName().length() > 0 && !this.myPsiNameHelper.isIdentifier(this.myTarget.getAttributeName(), LanguageLevel.HIGHEST)) {
            return JpaMessages.message((String)"db.schema.import.not.identifier", (Object[])new Object[]{this.myTarget.getAttributeName()});
        }
        boolean bl = manyToMany = this.myCbJoinTable.getSelectedItem() != null;
        if (manyToMany) {
            boolean sourceFound = false;
            boolean targetFound = false;
            for (DatabaseRelationshipData.Join join : this.myJoins) {
                if (join.getSource() != null && join.getSourceJoin() == null || join.getSource() == null && join.getSourceJoin() != null || join.getTarget() != null && join.getTargetJoin() == null || join.getTarget() == null && join.getTargetJoin() != null) {
                    return JpaMessages.message((String)"db.schema.import.joins.not.specified", (Object[])new Object[0]);
                }
                if (join.getSource() != null) {
                    sourceFound = true;
                }
                if (join.getTarget() == null) continue;
                targetFound = true;
            }
            if (!sourceFound || !targetFound) {
                return JpaMessages.message((String)"db.schema.import.joins.not.specified", (Object[])new Object[0]);
            }
        } else {
            for (DatabaseRelationshipData.Join join : this.myJoins) {
                if ((join.getSource() == null || join.getTarget() != null) && (join.getSource() != null || join.getTarget() == null)) continue;
                return JpaMessages.message((String)"db.schema.import.joins.not.specified", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public void commit() {
        this.mySource.commit();
        this.myTarget.commit();
        this.myData.setJoinTable((DasTable)this.myCbJoinTable.getSelectedItem());
        this.myData.getJoins().clear();
        this.myData.getJoins().addAll(this.myJoins);
    }

    private ColumnInfo[] createColumnInfos() {
        ArrayList<MyColumnInfo> list = new ArrayList<MyColumnInfo>();
        list.add(new MyColumnInfo(JpaMessages.message((String)"columninfo.persistence.relationship.source", (Object[])new Object[0]), JoinItem.SOURCE));
        if (this.myCbJoinTable.getSelectedItem() != null) {
            list.add(new MyColumnInfo(JpaMessages.message((String)"columninfo.persistence.relationship.source.join", (Object[])new Object[0]), JoinItem.SOURCE_JOIN));
            list.add(new MyColumnInfo(JpaMessages.message((String)"columninfo.persistence.relationship.target.join", (Object[])new Object[0]), JoinItem.TARGET_JOIN));
        }
        list.add(new MyColumnInfo(JpaMessages.message((String)"columninfo.persistence.relationship.target", (Object[])new Object[0]), JoinItem.TARGET));
        return list.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    private List<String> getColumnNamesList(List<DatabaseRelationshipData.Join> joins, JoinItem joinItem) {
        ArrayList<String> result = new ArrayList<String>();
        for (DatabaseRelationshipData.Join join : joins) {
            DasColumn tableFieldData = joinItem.getItem(join);
            if (tableFieldData == null) continue;
            result.add(tableFieldData.getName());
        }
        return result;
    }

    private static List<String> getTableFieldsComboBox(DasTable table, List<String> excludeList) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(" ");
        for (DasColumn fieldData : DasUtil.getColumns((DasObject)table)) {
            if (excludeList.contains(fieldData.getName())) continue;
            result.add(fieldData.getName());
        }
        Collections.sort(result);
        return result;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourcePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JpaBundle", DatabaseRelationshipDialog.class).getString("border.persistence.relationship.source"), (int)0, (int)0, null, null));
        this.myTargetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JpaBundle", DatabaseRelationshipDialog.class).getString("border.persistence.relationship.target"), (int)0, (int)0, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myCbJoinTable = jComboBox;
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/JpaBundle", DatabaseRelationshipDialog.class).getString("border.persistence.relationship.join.columns"), (int)0, (int)0, null, null));
        this.myJoinTableCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JpaBundle", DatabaseRelationshipDialog.class).getString("label.persistence.relationship.join.table.combobox"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyColumnInfo
    extends ColumnInfo<DatabaseRelationshipData.Join, String> {
        private final JoinItem myType;

        MyColumnInfo(String title, JoinItem joinItem) {
            super(title);
            this.myType = joinItem;
        }

        public String valueOf(DatabaseRelationshipData.Join object) {
            DasColumn tableFieldData = this.myType.getItem(object);
            return tableFieldData == null ? "" : tableFieldData.getName();
        }

        public boolean isCellEditable(DatabaseRelationshipData.Join o) {
            return true;
        }

        public void setValue(DatabaseRelationshipData.Join o, String aValue) {
            DasTable table = this.getMyTable();
            this.myType.setItem(o, (DasColumn)DasUtil.findChild((DasObject)table, DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)aValue));
        }

        public TableCellRenderer getRenderer(DatabaseRelationshipData.Join join) {
            return super.getRenderer((Object)join);
        }

        public TableCellEditor getEditor(DatabaseRelationshipData.Join o) {
            return new ComboBoxCellEditor(){

                protected List<String> getComboBoxItems() {
                    return DatabaseRelationshipDialog.getTableFieldsComboBox(MyColumnInfo.this.getMyTable(), DatabaseRelationshipDialog.this.getColumnNamesList(DatabaseRelationshipDialog.this.myJoins, MyColumnInfo.this.myType));
                }
            };
        }

        private DasTable getMyTable() {
            switch (this.myType) {
                case SOURCE: {
                    return DatabaseRelationshipDialog.this.mySource.getTable();
                }
                case SOURCE_JOIN: {
                    return (DasTable)DatabaseRelationshipDialog.this.myCbJoinTable.getSelectedItem();
                }
                case TARGET_JOIN: {
                    return (DasTable)DatabaseRelationshipDialog.this.myCbJoinTable.getSelectedItem();
                }
                case TARGET: {
                    return DatabaseRelationshipDialog.this.myTarget.getTable();
                }
            }
            assert (false);
            return null;
        }
    }

    private static final class JoinItem
    extends Enum<JoinItem> {
        public static final /* enum */ JoinItem SOURCE = new JoinItem();
        public static final /* enum */ JoinItem SOURCE_JOIN = new JoinItem();
        public static final /* enum */ JoinItem TARGET_JOIN = new JoinItem();
        public static final /* enum */ JoinItem TARGET = new JoinItem();
        private static final /* synthetic */ JoinItem[] $VALUES;

        public static JoinItem[] values() {
            return (JoinItem[])$VALUES.clone();
        }

        public static JoinItem valueOf(String name) {
            return Enum.valueOf(JoinItem.class, name);
        }

        public DasColumn getItem(DatabaseRelationshipData.Join join) {
            switch (this) {
                case SOURCE: {
                    return join.getSource();
                }
                case SOURCE_JOIN: {
                    return join.getSourceJoin();
                }
                case TARGET_JOIN: {
                    return join.getTargetJoin();
                }
                case TARGET: {
                    return join.getTarget();
                }
            }
            assert (false);
            return null;
        }

        public void setItem(DatabaseRelationshipData.Join join, DasColumn data) {
            switch (this) {
                case SOURCE: {
                    join.setSource(data);
                    break;
                }
                case SOURCE_JOIN: {
                    join.setSourceJoin(data);
                    break;
                }
                case TARGET_JOIN: {
                    join.setTargetJoin(data);
                    break;
                }
                case TARGET: {
                    join.setTarget(data);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        static {
            $VALUES = new JoinItem[]{SOURCE, SOURCE_JOIN, TARGET_JOIN, TARGET};
        }
    }

    private class MyDatabaseRelationshipRolePanel
    extends DatabaseRelationshipRolePanel {
        MyDatabaseRelationshipRolePanel(DatabaseRelationshipData.Role role) {
            super(role);
        }

        @Override
        protected void tableOrTypeChanged() {
            DatabaseRelationshipDialog.this.updateControls();
        }

        @Override
        protected List<? extends DasTable> getTables() {
            return DasUtil.getTables((DasDataSource)DatabaseRelationshipDialog.this.myDatabaseSchemaImportDialog.getDatasource()).toList();
        }
    }
}

