/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.javaee.model.common.persistence.JpaAnnotationConstants;
import com.intellij.javaee.model.common.persistence.mapping.EntityListenerMethodType;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class GenerateEntityListenerMethodsHandler
extends GenerateMembersHandlerBase {
    public GenerateEntityListenerMethodsHandler() {
        super(JpaMessages.message((String)"title.choose.entity.listener.method.types", (Object[])new Object[0]));
    }

    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        boolean persistentClass = false;
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)aClass)) {
            if (role.getType() != PersistenceClassRoleEnum.ENTITY && role.getType() != PersistenceClassRoleEnum.MAPPED_SUPERCLASS) continue;
            persistentClass = true;
            break;
        }
        PsiClass copy = (PsiClass)aClass.copy();
        ArrayList result = new ArrayList();
        for (EntityListenerMethodType methodType : EntityListenerMethodType.values()) {
            GenerateEntityListenerMethodsHandler.addEntityListenerMethod(result, copy, methodType, !persistentClass);
        }
        return result.toArray(ClassMember.EMPTY_ARRAY);
    }

    public static void addEntityListenerMethod(ArrayList<? super PsiMethodMember> result, PsiClass aClass, EntityListenerMethodType methodType, boolean separateClass) {
        block3: {
            JavaeeType javaeeType = JavaeeType.discover((PsiElement)aClass, (JavaeeClass)JpaAnnotationConstants.ENTITY_ANNO);
            for (PsiMethod psiMethod : aClass.getMethods()) {
                PsiAnnotation psiAnnotation = psiMethod.getModifierList().findAnnotation(methodType.getMethodAnnotation().fqn(javaeeType));
                if (psiAnnotation == null) continue;
                return;
            }
            PsiMethod psiMethod = GenerateEntityListenerMethodsHandler.generateInterceptorMethod(aClass, methodType, separateClass);
            try {
                result.add((PsiMethodMember)new PsiMethodMember((PsiMethod)aClass.add((PsiElement)psiMethod)));
            }
            catch (IncorrectOperationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)e);
            }
        }
    }

    private static PsiMethod generateInterceptorMethod(PsiClass aClass, EntityListenerMethodType methodType, boolean separateClass) {
        String annotationName = methodType.getMethodAnnotation().fqn((PsiElement)aClass);
        String methodName = StringUtil.decapitalize((String)methodType.getTypeName());
        String methodText = separateClass ? "@" + annotationName + " void " + methodName + "(Object object) { }" : "@" + annotationName + " void " + methodName + "() { }";
        try {
            return JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createMethodFromText(methodText, null);
        }
        catch (IncorrectOperationException e) {
            assert (false) : e;
            return null;
        }
    }

    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        return new GenerationInfo[]{new PsiGenerationInfo((PsiMember)((PsiMethodMember)originalMember).getElement())};
    }
}

