/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableBase;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProviderBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.xml.persistence.Persistence;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.actions.GenerateJpaMappingAction;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.generation.DatabaseSchemaImporter;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.importer.JpaFacetDetector;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileUtil;
import com.intellij.util.descriptors.ConfigFileVersion;
import com.intellij.util.xml.NamedEnumUtil;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpaFrameworkSupportProvider
extends FacetBasedFrameworkSupportProvider<JpaFacet> {
    private static final Logger LOG = Logger.getInstance(JpaFrameworkSupportProvider.class);

    protected JpaFrameworkSupportProvider() {
        super((FacetType)JpaFacetType.getInstance());
    }

    public String getGroupId() {
        return JavaeeUtil.JAVAEE_FRAMEWORK_GROUP;
    }

    @NotNull
    public List<FrameworkVersion> getVersions() {
        ConfigFileMetaData metaData = JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA;
        ArrayList<FrameworkVersion> result = new ArrayList<FrameworkVersion>();
        for (ConfigFileVersion version : metaData.getVersions()) {
            String versionName = version.getName();
            JpaVersion jpaVersion = JpaFrameworkSupportProvider.getJpaVersion(versionName);
            LibraryInfo[] libraries = JpaUtil.getJpaLibraryInfos(jpaVersion);
            result.add(new FrameworkVersion(versionName, jpaVersion.getVersionTitle(), libraries, version.equals(metaData.getDefaultVersion())));
        }
        ArrayList<FrameworkVersion> arrayList = result;
        if (arrayList == null) {
            JpaFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public String getTitle() {
        return JpaMessages.message((String)"framework.title.jpa", (Object[])new Object[0]);
    }

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            JpaFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return "LegacyJavaEE".equals(builder.getBuilderId());
    }

    protected void setupConfiguration(JpaFacet facet, ModifiableRootModel rootModel, FrameworkVersion version) {
        if (rootModel.getProject().isInitialized() && !DumbService.getInstance((Project)rootModel.getProject()).isDumb() && new JpaFacetDetector().configureJpaProvider(facet, (ModuleRootModel)rootModel)) {
            return;
        }
        List resourceRoots = rootModel.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        List sourceRoots = rootModel.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        VirtualFile existingConfigFile = Stream.concat(resourceRoots.stream(), sourceRoots.stream()).flatMap(contentRoot -> {
            File file;
            String descriptorUrl = JpaFrameworkSupportProvider.getPersistenceXmlUrl(contentRoot);
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            VirtualFile existingFile = fileSystem.refreshAndFindFileByIoFile(file = new File(VfsUtilCore.urlToPath((String)descriptorUrl)));
            if (existingFile != null) {
                return Stream.of(existingFile);
            }
            return Stream.empty();
        }).findFirst().orElse(null);
        if (existingConfigFile == null) {
            VirtualFile firstContentRoot = (VirtualFile)ContainerUtil.getFirstItem((Collection)resourceRoots, (Object)((VirtualFile)ContainerUtil.getFirstItem((Collection)sourceRoots, null)));
            if (firstContentRoot != null) {
                String descriptorUrl = JpaFrameworkSupportProvider.getPersistenceXmlUrl(firstContentRoot);
                ConfigFileVersion configFileVersion = ConfigFileUtil.getVersionByName((ConfigFileMetaData)JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, (String)version.getVersionName());
                ConfigFileFactory.getInstance().createFile(null, descriptorUrl, configFileVersion, true);
                facet.getDescriptorsContainer().getConfiguration().replaceConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, descriptorUrl);
            }
        } else {
            facet.getDescriptorsContainer().getConfiguration().replaceConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, existingConfigFile.getUrl());
        }
    }

    @NotNull
    private static String getPersistenceXmlUrl(VirtualFile contentRoot) {
        String string = contentRoot.getUrl() + "/" + JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getDirectoryPath() + "/" + JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA.getFileName();
        if (string == null) {
            JpaFrameworkSupportProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public FrameworkSupportConfigurableBase createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            JpaFrameworkSupportProvider.$$$reportNull$$$0(3);
        }
        return new JpaConfigurable(model, this.getVersions());
    }

    public static void setupJpaProvidersCombobox(JComboBox<JpaImplementationProvider> comboBox) {
        Object[] providers = JpaImplementationProvider.EP_NAME.getExtensionList().toArray(new JpaImplementationProvider[0]);
        Arrays.sort(providers, (o1, o2) -> Comparing.compare((Comparable)((Object)StringUtil.toLowerCase((String)o1.getProviderName())), (Comparable)((Object)StringUtil.toLowerCase((String)o2.getProviderName()))));
        JpaImplementationProvider[] items = (JpaImplementationProvider[])ArrayUtil.mergeArrays((Object[])new JpaImplementationProvider[]{null}, (Object[])providers);
        comboBox.setModel(new DefaultComboBoxModel<JpaImplementationProvider>(items));
        comboBox.setRenderer((ListCellRenderer<JpaImplementationProvider>)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(value != null ? value.getProviderIcon() : null);
            String name = value == null ? JpaHighlightingMessages.message("jpa.framework.provider.label.no.provider", new Object[0]) : value.getProviderName();
            label.setText(StringUtil.notNullize((String)name));
        }));
        comboBox.setEditable(false);
        comboBox.setModel(new DefaultComboBoxModel<JpaImplementationProvider>(items));
    }

    @Nullable
    public static JpaImplementationProvider findProviderByName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        for (JpaImplementationProvider provider : JpaImplementationProvider.EP_NAME.getExtensionList()) {
            if (!Objects.equals(provider.getProviderName(), name)) continue;
            return provider;
        }
        return null;
    }

    public static void scheduleRunnable(Module module, Runnable runnable) {
        DumbService.getInstance((Project)module.getProject()).smartInvokeLater(() -> {
            if (module.isDisposed()) {
                return;
            }
            runnable.run();
        }, ModalityState.NON_MODAL);
    }

    public static void scheduleDbImport(Module module, PersistenceFacet facet) {
        JpaFrameworkSupportProvider.scheduleRunnable(module, () -> GenerateJpaMappingAction.runGenerateAction(new DatabaseSchemaImporter(), dataId -> {
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return module.getProject();
            }
            if (PersistenceDataKeys.PERSISTENCE_FACET.is(dataId)) {
                return facet;
            }
            if (PersistenceDataKeys.PERSISTENCE_FACET_CONTEXT.is(dataId) && facet.getPersistenceUnits().isEmpty()) {
                return facet;
            }
            if (PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.is(dataId) && !facet.getPersistenceUnits().isEmpty()) {
                return facet.getPersistenceUnits().get(0);
            }
            return DataManager.getInstance().getDataContext().getData(dataId);
        }));
    }

    @NotNull
    private static JpaVersion getJpaVersion(String version) {
        JpaVersion jpaVersion = (JpaVersion)NamedEnumUtil.getEnumElementByValue(JpaVersion.class, (String)version);
        if (jpaVersion == null) {
            JpaFrameworkSupportProvider.$$$reportNull$$$0(4);
        }
        return jpaVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/facet/JpaFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/facet/JpaFrameworkSupportProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceXmlUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJpaVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForModuleBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class JpaConfigurable
    extends FrameworkSupportConfigurableBase {
        private JPanel myPanel;
        private JComboBox<JpaImplementationProvider> myProviderComboBox;
        private JCheckBox myDbImport;

        JpaConfigurable(FrameworkSupportModel model, List<FrameworkVersion> versions) {
            super((FrameworkSupportProviderBase)JpaFrameworkSupportProvider.this, model, versions, JpaHighlightingMessages.message("label.persistence.xml.version", new Object[0]));
        }

        public JComponent getComponent() {
            if (this.myPanel == null) {
                this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, true));
                JComponent superC = super.getComponent();
                if (superC != null) {
                    this.myPanel.add(superC);
                }
                this.myProviderComboBox = new ComboBox();
                JpaFrameworkSupportProvider.setupJpaProvidersCombobox(this.myProviderComboBox);
                this.myDbImport = new JCheckBox(JpaMessages.message((String)"framework.configurable.import.database", (Object[])new Object[0]));
                this.myPanel.add(this.myProviderComboBox);
                this.myPanel.add(this.myDbImport);
            }
            return this.myPanel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @Nullable Library library) {
            if (module == null) {
                JpaConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                JpaConfigurable.$$$reportNull$$$0(1);
            }
            super.addSupport(module, rootModel, library);
            JpaFacet facet = (JpaFacet)FacetManager.getInstance((Module)module).getFacetByType(JpaFacet.ID);
            assert (facet != null);
            JpaImplementationProvider provider = (JpaImplementationProvider)this.myProviderComboBox.getSelectedItem();
            ((JpaFacetConfiguration)facet.getConfiguration()).setDefaultJPAProviderName(provider == null ? null : provider.getProviderName());
            boolean isDbImport = this.myDbImport.isSelected();
            Runnable runnable = () -> {
                try {
                    ConfigFile deploymentDescriptor = facet.getMainDeploymentDescriptor();
                    if (deploymentDescriptor != null) {
                        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{deploymentDescriptor.getXmlFile()}).run(() -> {
                            PsiDocumentManager.getInstance((Project)module.getProject()).commitAllDocuments();
                            Persistence root = facet.getPersistenceRoot();
                            assert (root != null);
                            if (root.getPersistenceUnits().isEmpty()) {
                                PersistenceUnit unit = root.addPersistenceUnit();
                                unit.getName().setStringValue("NewPersistenceUnit");
                                if (provider != null) {
                                    provider.setDefaultProperties(unit);
                                }
                            }
                        });
                    }
                    if (isDbImport) {
                        if (!PackageUtil.checkSourceRootsConfigured((Module)module)) {
                            return;
                        }
                        JpaFrameworkSupportProvider.scheduleDbImport(module, (PersistenceFacet)facet);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            };
            JpaFrameworkSupportProvider.scheduleRunnable(module, runnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rootModel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jpa/facet/JpaFrameworkSupportProvider$JpaConfigurable";
            objectArray[2] = "addSupport";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

