/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetEditorsFactory;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.ui.JpaGeneralEditorTab;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class JpaFacetConfigurationImpl
implements JpaFacetConfiguration {
    @NonNls
    private static final String DATASOURCE_MAPPING = "datasource-mapping";
    @NonNls
    private static final String FACTORY_ENTRY = "factory-entry";
    @NonNls
    private static final String VALIDATION_ENABLED = "validation-enabled";
    @NonNls
    private static final String PROVIDER_NAME = "provider-name";
    private boolean myValidationEnabled = true;
    private String myDefaultProviderName;
    private final Map<String, String> myUnitToDataSourceMap = new HashMap<String, String>();
    private final Map<String, String> myUnitToNamingStrategyMap = new HashMap<String, String>();
    private final ConfigFileInfoSet myDescriptorsConfiguration;

    public JpaFacetConfigurationImpl(ConfigFileInfoSet descriptorsConfiguration) {
        this.myDescriptorsConfiguration = descriptorsConfiguration;
    }

    public ConfigFileInfoSet getDescriptorsConfiguration() {
        return this.myDescriptorsConfiguration;
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        JpaFacet facet = (JpaFacet)context.getFacet();
        DumbService dumbService = DumbService.getInstance((Project)facet.getModule().getProject());
        return (FacetEditorTab[])dumbService.computeWithAlternativeResolveEnabled(() -> {
            JpaVersion jpaVersion = JpaUtil.getJpaVersion(facet);
            FacetLibrariesValidator validator = FacetEditorsFactory.getInstance().createLibrariesValidator(JpaUtil.getJpaLibraryInfos(jpaVersion), new FacetLibrariesValidatorDescription(jpaVersion.getVersionTitle()), context, validatorsManager);
            validatorsManager.registerValidator((FacetEditorValidator)validator, new JComponent[0]);
            return new FacetEditorTab[]{new JpaGeneralEditorTab(this, context, validator)};
        });
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myValidationEnabled = JDOMExternalizer.readBoolean((Element)element, (String)VALIDATION_ENABLED);
        this.myDefaultProviderName = JDOMExternalizer.readString((Element)element, (String)PROVIDER_NAME);
        JDOMExternalizer.readMap((Element)element, this.myUnitToDataSourceMap, (String)DATASOURCE_MAPPING, (String)FACTORY_ENTRY);
        JDOMExternalizer.readMap((Element)element, this.myUnitToNamingStrategyMap, (String)"naming-strategy-map", (String)"unit-entry");
        this.myDescriptorsConfiguration.readExternal(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        JdomKt.addOptionTag((Element)element, (String)VALIDATION_ENABLED, (String)Boolean.toString(this.myValidationEnabled), (String)"setting");
        if (!StringUtil.isEmpty((String)this.myDefaultProviderName)) {
            JdomKt.addOptionTag((Element)element, (String)PROVIDER_NAME, (String)this.myDefaultProviderName, (String)"setting");
        }
        JDOMExternalizer.writeMap((Element)element, this.myUnitToDataSourceMap, (String)DATASOURCE_MAPPING, (String)FACTORY_ENTRY);
        JDOMExternalizer.writeMap((Element)element, this.myUnitToNamingStrategyMap, (String)"naming-strategy-map", (String)"unit-entry");
        this.myDescriptorsConfiguration.writeExternal(element);
    }

    public Map<String, String> getUnitToDataSourceMap() {
        return this.myUnitToDataSourceMap;
    }

    public String getDefaultJPAProviderName() {
        return this.myDefaultProviderName;
    }

    public void setDefaultJPAProviderName(String providerName) {
        this.myDefaultProviderName = providerName;
    }

    public Map<String, String> getUnitToNamingStrategyMap() {
        return this.myUnitToNamingStrategyMap;
    }
}

