/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.run.ParametersHolder;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jpa/engine/SessionVisibilityController;", "S", "Lcom/intellij/database/run/session/VisibleSession;", "Lcom/intellij/database/run/ParametersHolder$VisibilityController;", "session", "(Lcom/intellij/database/run/session/VisibleSession;)V", "content", "Lcom/intellij/ui/content/Content;", "Lcom/intellij/database/run/session/VisibleSession;", "state", "", "hide", "", "initContent", "holder", "Lcom/intellij/database/run/ParametersHolder;", "isToggled", "show", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "project", "Lcom/intellij/openapi/project/Project;", "toggleParamContent", "intellij.javaee.jpa.impl"})
public final class SessionVisibilityController<S extends VisibleSession<?>>
implements ParametersHolder.VisibilityController {
    private Content content;
    private boolean state;
    private final S session;

    public boolean isToggled() {
        return this.state;
    }

    @NotNull
    public Promise<Void> show(@NotNull Project project, @NotNull ParametersHolder holder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.initContent(holder);
        return this.toggleParamContent(true);
    }

    public void hide() {
        this.toggleParamContent(false);
    }

    private final void initContent(ParametersHolder holder) {
        if (this.content != null) {
            return;
        }
        LogView view = DatabaseSessionViewService.Companion.getInstance().getViewIfAny(this.session);
        if (view == null) {
            return;
        }
        this.content = view.getUi().createContent("Parameters", (JComponent)holder.getParamPanel(), DatabaseBundle.message((String)"jdbc.console.tab.title.parameters", (Object[])new Object[0]), PlatformIcons.PARAMETER_ICON, null);
        Disposable disposable = (Disposable)holder;
        Content content = this.content;
        Intrinsics.checkNotNull((Object)content);
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)content));
    }

    private final Promise<Void> toggleParamContent(boolean state) {
        if (state == this.state) {
            return Promises.resolvedPromise();
        }
        this.state = state;
        LogView view = DatabaseSessionViewService.Companion.getInstance().getViewIfAny(this.session);
        if (view != null) {
            if (state) {
                Promise promise;
                RunnerLayoutUi runnerLayoutUi = view.getUi();
                Content content = this.content;
                Intrinsics.checkNotNull((Object)content);
                runnerLayoutUi.addContent(content, 0, PlaceInGrid.right, false);
                if (!view.isShowing()) {
                    Promise promise2 = view.show(true, false);
                    promise = promise2;
                    Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"view.show(true, false)");
                } else {
                    promise = Promises.resolvedPromise();
                }
                return promise;
            }
            if (this.content == null) {
                return Promises.resolvedPromise();
            }
            DataManager dataManager = DataManager.getInstance();
            RunnerLayoutUi runnerLayoutUi = view.getUi();
            Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi, (String)"view.ui");
            RunnerContentUi runnerContentUi = (RunnerContentUi)RunnerContentUi.KEY.getData(dataManager.getDataContext((Component)runnerLayoutUi.getComponent()));
            if (runnerContentUi != null) {
                runnerContentUi.saveUiState();
            }
            RunnerLayoutUi runnerLayoutUi2 = view.getUi();
            Intrinsics.checkNotNullExpressionValue((Object)runnerLayoutUi2, (String)"view.ui");
            ContentManager contentManager = runnerLayoutUi2.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"view.ui.contentManager");
            ContentManager manager = contentManager;
            Content content = this.content;
            Intrinsics.checkNotNull((Object)content);
            manager.removeContent(content, false);
        }
        return Promises.resolvedPromise();
    }

    public SessionVisibilityController(@NotNull S session) {
        Intrinsics.checkNotNullParameter(session, (String)"session");
        this.session = session;
    }
}

